/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.scala.collection.concurrent;

import com.google.common.primitives.Ints;
import com.metamx.common.scala.collection.concurrent.BlockingQueue;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001i4A!\u0001\u0002\u0001\u001f\ty!)\u001f;f\u0005V4g-\u001a:Rk\u0016,XM\u0003\u0002\u0004\t\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u00151\u0011AC2pY2,7\r^5p]*\u0011q\u0001C\u0001\u0006g\u000e\fG.\u0019\u0006\u0003\u0013)\taaY8n[>t'BA\u0006\r\u0003\u0019iW\r^1nq*\tQ\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001!A\u0019\u0011C\u0005\u000b\u000e\u0003\tI!a\u0005\u0002\u0003\u001b\tcwnY6j]\u001e\fV/Z;f!\r)r#G\u0007\u0002-)\tq!\u0003\u0002\u0019-\t)\u0011I\u001d:bsB\u0011QCG\u0005\u00037Y\u0011AAQ=uK\"AQ\u0004\u0001B\u0001B\u0003%a$\u0001\u0004ck\u001a4WM\u001d\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\n1A\\5p\u0015\u0005\u0019\u0013\u0001\u00026bm\u0006L!!\n\u0011\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0003(\u0001\u0011\u0005\u0001&\u0001\u0004=S:LGO\u0010\u000b\u0003S)\u0002\"!\u0005\u0001\t\u000bu1\u0003\u0019\u0001\u0010\t\u000f1\u0002!\u0019!C\u0005[\u0005a\u0001.Z1eKJdUM\\4uQV\ta\u0006\u0005\u0002\u0016_%\u0011\u0001G\u0006\u0002\u0004\u0013:$\bB\u0002\u001a\u0001A\u0003%a&A\u0007iK\u0006$WM\u001d'f]\u001e$\b\u000e\t\u0005\bi\u0001\u0011\r\u0011\"\u0003.\u0003\u0011\u0019\u0018N_3\t\rY\u0002\u0001\u0015!\u0003/\u0003\u0015\u0019\u0018N_3!\u0011\u001dA\u0004\u00011A\u0005\n5\nQa\u001d;beRDqA\u000f\u0001A\u0002\u0013%1(A\u0005ti\u0006\u0014Ho\u0018\u0013fcR\u0011Ah\u0010\t\u0003+uJ!A\u0010\f\u0003\tUs\u0017\u000e\u001e\u0005\b\u0001f\n\t\u00111\u0001/\u0003\rAH%\r\u0005\u0007\u0005\u0002\u0001\u000b\u0015\u0002\u0018\u0002\rM$\u0018M\u001d;!\u0011\u001d!\u0005\u00011A\u0005\n5\n1!\u001a8e\u0011\u001d1\u0005\u00011A\u0005\n\u001d\u000bq!\u001a8e?\u0012*\u0017\u000f\u0006\u0002=\u0011\"9\u0001)RA\u0001\u0002\u0004q\u0003B\u0002&\u0001A\u0003&a&\u0001\u0003f]\u0012\u0004\u0003b\u0002'\u0001\u0005\u0004%I!T\u0001\u0006?V\u001cX\rZ\u000b\u0002\u001dB\u0011q*V\u0007\u0002!*\u0011\u0011KU\u0001\u0007CR|W.[2\u000b\u0005\r\u0019&B\u0001+#\u0003\u0011)H/\u001b7\n\u0005Y\u0003&AC!u_6L7\rT8oO\"1\u0001\f\u0001Q\u0001\n9\u000baaX;tK\u0012\u0004\u0003\"\u0002.\u0001\t\u0003Y\u0016\u0001B;tK\u0012$\u0012\u0001\u0018\t\u0003+uK!A\u0018\f\u0003\t1{gn\u001a\u0005\u0006A\u0002!\t&Y\u0001\bK:\fX/Z;f)\t\u0011W\r\u0005\u0002\u0016G&\u0011AM\u0006\u0002\b\u0005>|G.Z1o\u0011\u00151w\f1\u0001\u0015\u0003\u0011)G.Z7\t\u000b!\u0004A\u0011K5\u0002\u000f\u0011,\u0017/^3vKR\t!\u000eE\u0002\u0016WRI!\u0001\u001c\f\u0003\r=\u0003H/[8o\u0011\u0015q\u0007\u0001\"\u0003p\u0003)9(/\u001b;f\u0003J\u0014\u0018-\u001f\u000b\u0004yA\u0014\b\"B9n\u0001\u0004q\u0013AB8gMN,G\u000fC\u0003t[\u0002\u0007A#A\u0002beJDQ!\u001e\u0001\u0005\nY\f\u0011B]3bI\u0006\u0013(/Y=\u0015\u0007Q9\b\u0010C\u0003ri\u0002\u0007a\u0006C\u0003zi\u0002\u0007a&\u0001\u0004mK:<G\u000f\u001b")
public class ByteBufferQueue
extends BlockingQueue<byte[]> {
    public final ByteBuffer com$metamx$common$scala$collection$concurrent$ByteBufferQueue$$buffer;
    private final int headerLength;
    private final int com$metamx$common$scala$collection$concurrent$ByteBufferQueue$$size;
    private int start;
    private int end;
    private final AtomicLong _used;

    private int headerLength() {
        return this.headerLength;
    }

    public int com$metamx$common$scala$collection$concurrent$ByteBufferQueue$$size() {
        return this.com$metamx$common$scala$collection$concurrent$ByteBufferQueue$$size;
    }

    private int start() {
        return this.start;
    }

    private void start_$eq(int x$1) {
        this.start = x$1;
    }

    private int end() {
        return this.end;
    }

    private void end_$eq(int x$1) {
        this.end = x$1;
    }

    private AtomicLong _used() {
        return this._used;
    }

    public long used() {
        return this._used().get();
    }

    @Override
    public boolean enqueue(byte[] elem) {
        boolean bl;
        if (elem == null) {
            throw new NullPointerException("Can't put null element");
        }
        int elemTotalLength = this.headerLength() + elem.length;
        if (this.com$metamx$common$scala$collection$concurrent$ByteBufferQueue$$size() < elemTotalLength) {
            throw new IllegalStateException("Element too big to enqueue");
        }
        if ((long)this.com$metamx$common$scala$collection$concurrent$ByteBufferQueue$$size() - this._used().get() < (long)elemTotalLength) {
            bl = false;
        } else {
            byte[] hdr = Ints.toByteArray((int)elem.length);
            this.writeArray(this.end(), hdr);
            this.writeArray(this.end() + this.headerLength(), elem);
            this._used().addAndGet(elemTotalLength);
            this._count().incrementAndGet();
            this.end_$eq((this.end() + elemTotalLength) % this.com$metamx$common$scala$collection$concurrent$ByteBufferQueue$$size());
            bl = true;
        }
        return bl;
    }

    @Override
    public Option<byte[]> dequeue() {
        None$ none$;
        if (this._used().get() == 0L) {
            none$ = None$.MODULE$;
        } else {
            byte[] hdr = this.readArray(this.start(), this.headerLength());
            int length = Ints.fromByteArray((byte[])hdr);
            byte[] elem = this.readArray(this.start() + this.headerLength(), length);
            int elemTotalLength = this.headerLength() + elem.length;
            this._used().addAndGet(-elemTotalLength);
            this._count().decrementAndGet();
            this.start_$eq((this.start() + elemTotalLength) % this.com$metamx$common$scala$collection$concurrent$ByteBufferQueue$$size());
            none$ = new Some((Object)elem);
        }
        return none$;
    }

    private void writeArray(int offset, byte[] arr) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), arr.length).foreach((Function1)new Serializable(this, offset, arr){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ByteBufferQueue $outer;
            private final int offset$1;
            private final byte[] arr$1;

            public final ByteBuffer apply(int i) {
                return this.$outer.com$metamx$common$scala$collection$concurrent$ByteBufferQueue$$buffer.put((this.offset$1 + i) % this.$outer.com$metamx$common$scala$collection$concurrent$ByteBufferQueue$$size(), this.arr$1[i]);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offset$1 = offset$1;
                this.arr$1 = arr$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private byte[] readArray(int offset, int length) {
        void var3_3;
        byte[] arr = new byte[length];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), arr.length).foreach$mVc$sp((Function1)new Serializable(this, offset, arr){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ByteBufferQueue $outer;
            private final int offset$2;
            private final byte[] arr$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.arr$2[i] = this.$outer.com$metamx$common$scala$collection$concurrent$ByteBufferQueue$$buffer.get((this.offset$2 + i) % this.$outer.com$metamx$common$scala$collection$concurrent$ByteBufferQueue$$size());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offset$2 = offset$2;
                this.arr$2 = arr$2;
            }
        });
        return var3_3;
    }

    public ByteBufferQueue(ByteBuffer buffer) {
        this.com$metamx$common$scala$collection$concurrent$ByteBufferQueue$$buffer = buffer;
        this.headerLength = 4;
        this.com$metamx$common$scala$collection$concurrent$ByteBufferQueue$$size = buffer.capacity();
        this.start = 0;
        this.end = 0;
        this._used = new AtomicLong();
    }
}

