/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.collections.spatial.split;

import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.spatial.Node;
import com.metamx.collections.spatial.split.GutmanSplitStrategy;
import java.util.List;

public class LinearGutmanSplitStrategy
extends GutmanSplitStrategy {
    public LinearGutmanSplitStrategy(int minNumChildren, int maxNumChildren, BitmapFactory bf) {
        super(minNumChildren, maxNumChildren, bf);
    }

    @Override
    public Node[] pickSeeds(List<Node> nodes) {
        int[] optimalIndices = new int[2];
        int numDims = nodes.get(0).getNumDims();
        double bestNormalized = 0.0;
        for (int i = 0; i < numDims; ++i) {
            double normalizedSeparation;
            float minCoord = Float.MAX_VALUE;
            float maxCoord = -3.4028235E38f;
            float highestLowSide = -3.4028235E38f;
            float lowestHighside = Float.MAX_VALUE;
            int highestLowSideIndex = 0;
            int lowestHighSideIndex = 0;
            int counter = 0;
            for (Node node : nodes) {
                minCoord = Math.min(minCoord, node.getMinCoordinates()[i]);
                maxCoord = Math.max(maxCoord, node.getMaxCoordinates()[i]);
                if (node.getMinCoordinates()[i] > highestLowSide) {
                    highestLowSide = node.getMinCoordinates()[i];
                    highestLowSideIndex = counter;
                }
                if (node.getMaxCoordinates()[i] < lowestHighside) {
                    lowestHighside = node.getMaxCoordinates()[i];
                    lowestHighSideIndex = counter;
                }
                ++counter;
            }
            double d = normalizedSeparation = highestLowSideIndex == lowestHighSideIndex ? -1.0 : (double)Math.abs((highestLowSide - lowestHighside) / (maxCoord - minCoord));
            if (!(normalizedSeparation > bestNormalized)) continue;
            optimalIndices[0] = highestLowSideIndex;
            optimalIndices[1] = lowestHighSideIndex;
            bestNormalized = normalizedSeparation;
        }
        if (bestNormalized == 0.0) {
            optimalIndices[0] = 0;
            optimalIndices[1] = 1;
        }
        int indexToRemove1 = Math.min(optimalIndices[0], optimalIndices[1]);
        int indexToRemove2 = Math.max(optimalIndices[0], optimalIndices[1]);
        return new Node[]{nodes.remove(indexToRemove1), nodes.remove(indexToRemove2 - 1)};
    }

    @Override
    public Node pickNext(List<Node> nodes, Node[] groups) {
        return nodes.remove(0);
    }
}

