/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.collections.bitmap;

import com.metamx.collections.bitmap.MutableBitmap;
import com.metamx.collections.bitmap.WrappedImmutableBitSetBitmap;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class WrappedBitSetBitmap
extends WrappedImmutableBitSetBitmap
implements MutableBitmap {
    public WrappedBitSetBitmap() {
    }

    public WrappedBitSetBitmap(BitSet bitSet) {
        super(bitSet);
    }

    public WrappedBitSetBitmap(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    protected BitSet cloneBitSet() {
        return (BitSet)this.bitmap.clone();
    }

    @Override
    public void clear() {
        this.bitmap.clear();
    }

    @Override
    public void or(MutableBitmap mutableBitmap) {
        if (!(mutableBitmap instanceof WrappedBitSetBitmap)) {
            throw new IllegalArgumentException(String.format("Unknown class type: %s  expected %s", mutableBitmap.getClass().getCanonicalName(), WrappedBitSetBitmap.class.getCanonicalName()));
        }
        WrappedBitSetBitmap bitSet = (WrappedBitSetBitmap)mutableBitmap;
        this.bitmap.or(bitSet.bitmap);
    }

    @Override
    public void and(MutableBitmap mutableBitmap) {
        if (!(mutableBitmap instanceof WrappedBitSetBitmap)) {
            throw new IllegalArgumentException(String.format("Unknown class type: %s  expected %s", mutableBitmap.getClass().getCanonicalName(), WrappedBitSetBitmap.class.getCanonicalName()));
        }
        WrappedBitSetBitmap bitSet = (WrappedBitSetBitmap)mutableBitmap;
        this.bitmap.and(bitSet.bitmap);
    }

    @Override
    public void xor(MutableBitmap mutableBitmap) {
        if (!(mutableBitmap instanceof WrappedBitSetBitmap)) {
            throw new IllegalArgumentException(String.format("Unknown class type: %s  expected %s", mutableBitmap.getClass().getCanonicalName(), WrappedBitSetBitmap.class.getCanonicalName()));
        }
        WrappedBitSetBitmap bitSet = (WrappedBitSetBitmap)mutableBitmap;
        this.bitmap.xor(bitSet.bitmap);
    }

    @Override
    public void andNot(MutableBitmap mutableBitmap) {
        if (!(mutableBitmap instanceof WrappedBitSetBitmap)) {
            throw new IllegalArgumentException(String.format("Unknown class type: %s  expected %s", mutableBitmap.getClass().getCanonicalName(), WrappedBitSetBitmap.class.getCanonicalName()));
        }
        WrappedBitSetBitmap bitSet = (WrappedBitSetBitmap)mutableBitmap;
        this.bitmap.andNot(bitSet.bitmap);
    }

    @Override
    public int getSizeInBytes() {
        return this.bitmap.size() / 8;
    }

    @Override
    public void add(int entry) {
        this.bitmap.set(entry);
    }

    @Override
    public void remove(int entry) {
        this.bitmap.clear(entry);
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.put(this.bitmap.toByteArray());
    }
}

