/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.tag.xrequest;

import com.metamug.entity.Response;
import com.metamug.exec.ResponseProcessable;
import com.metamug.mason.entity.xrequest.XResponse;
import com.metamug.mason.exception.MasonError;
import com.metamug.mason.exception.MasonException;
import com.metamug.mason.service.XRequestService;
import com.metamug.mason.tag.RequestTag;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;

public class XRequestTagHandler
extends RequestTag {
    private String var;
    private String url;
    private String requestBody;
    private String className;
    private boolean outputHeaders;
    private boolean output;

    public int doEndTag() throws JspException {
        String acceptHeader = this.request.getHeader("Accept") == null ? "application/json" : this.request.getHeader("Accept");
        String xAcceptType = "json";
        for (Map.Entry entry : this.headers.entrySet()) {
            if (!((String)entry.getKey()).equals("Accept") || !((String)entry.getValue()).equals("application/xml")) continue;
            xAcceptType = "xml";
        }
        XRequestService xRequestService = new XRequestService(this.outputHeaders);
        XResponse xresponse = null;
        switch (this.method) {
            case "GET": {
                xresponse = xRequestService.get(this.url, this.headers, this.parameters);
                break;
            }
            case "POST": {
                xresponse = xRequestService.post(this.url, this.headers, this.parameters, this.requestBody);
                break;
            }
            case "PUT": {
                xresponse = xRequestService.put(this.url, this.headers, this.parameters, this.requestBody);
                break;
            }
            case "DELETE": {
                xresponse = xRequestService.delete(this.url, this.parameters);
                break;
            }
            default: {
                throw new JspTagException("Unsupported method \"" + this.method + "\".");
            }
        }
        Response res = xresponse.getResponse(acceptHeader, xAcceptType);
        if (this.className != null) {
            try {
                Class<?> cls = Class.forName(this.className);
                if (!ResponseProcessable.class.isAssignableFrom(cls)) {
                    throw new JspException("", (Throwable)new MasonException(MasonError.RESPONSE_PROCESSABLE_NOT_IMPLEMENTED, "Class " + cls + " is not Response processable"));
                }
                ResponseProcessable responseProcessor = (ResponseProcessable)cls.newInstance();
                res = responseProcessor.process(res);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                throw new JspException("", (Throwable)new MasonException(MasonError.CODE_ERROR, ex, ex.getMessage()));
            }
            catch (Exception ex) {
                throw new JspException("", (Throwable)new MasonException(MasonError.CODE_ERROR, ex, ex.getMessage()));
            }
        }
        this.addToBus(this.var, res);
        if (this.output) {
            this.addToOutput(this.var, res);
        }
        return 6;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setUrl(String u) {
        this.url = u;
    }

    public void setRequestBody(String b) {
        this.requestBody = b;
    }

    public void setOutput(Boolean output) {
        this.output = output;
    }

    public void setOutputHeaders(boolean outputHeaders) {
        this.outputHeaders = outputHeaders;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

