/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.tag;

import com.metamug.entity.Attachment;
import com.metamug.entity.Request;
import com.metamug.entity.Response;
import com.metamug.mason.entity.request.JsonBodyStrategy;
import com.metamug.mason.entity.request.RequestBodyStrategy;
import com.metamug.mason.entity.request.XmlBodyStrategy;
import com.metamug.mason.entity.response.DatasetOutput;
import com.metamug.mason.entity.response.FileOutput;
import com.metamug.mason.entity.response.JSONOutput;
import com.metamug.mason.entity.response.MasonOutput;
import com.metamug.mason.entity.response.ResponeBuilder;
import com.metamug.mason.entity.response.XMLOutput;
import com.metamug.mason.service.UploaderService;
import com.metamug.mason.tag.RequestTag;
import com.metamug.mason.tag.ResourceTagHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONValue;

public class RequestTagHandler
extends RequestTag {
    private String item;
    private boolean shouldEvaluate;
    private String className;
    private Request masonRequest;
    public static final String JSP_REQUEST_SCOPE = "requestScope";
    public static final String REQUEST_BODY_PARAM_NAME = "mbody";
    protected ResourceTagHandler parent;

    @Override
    public int doStartTag() throws JspException {
        super.doStartTag();
        String contentType = this.request.getHeader("Content-Type") == null ? "application/x-www-form-urlencoded" : this.request.getHeader("Content-Type");
        try {
            this.parent = (ResourceTagHandler)this.getParent();
        }
        catch (ClassCastException cce) {
            throw new JspException("m:request Tag can only be wrapped around a m:resource tag.");
        }
        this.parent.addChildMethod(this.method);
        this.masonRequest = (Request)this.request.getAttribute("mtgReq");
        if (this.method.equalsIgnoreCase(this.masonRequest.getMethod())) {
            boolean bl = this.shouldEvaluate = this.masonRequest.getId() != null == StringUtils.isNotBlank((CharSequence)this.item);
            if (this.shouldEvaluate) {
                this.addBody(contentType);
                HashMap output = new HashMap();
                this.pageContext.setAttribute("output", output);
                if (this.method.equalsIgnoreCase("POST") && contentType.equals("multipart/form-data")) {
                    UploaderService uploader = new UploaderService(this.pageContext);
                    uploader.upload();
                }
                return 1;
            }
        }
        return 0;
    }

    private void addBody(String contentType) throws JspException {
        try {
            this.addExtraParams();
            RequestBodyStrategy strategy = null;
            if (this.className != null) {
                Class<?> clazz = Class.forName(this.className);
                if (contentType.contains("application/json")) {
                    strategy = new JsonBodyStrategy();
                } else if (contentType.contains("application/xml")) {
                    strategy = new XmlBodyStrategy();
                } else {
                    return;
                }
                Object body = clazz.cast(strategy.getBodyObject((InputStream)this.request.getInputStream(), clazz));
                this.masonRequest.setBody(body);
            } else if (contentType.contains("application/json")) {
                this.masonRequest.setBody(JSONValue.parse((Reader)new InputStreamReader((InputStream)this.request.getInputStream())));
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(RequestTagHandler.class.getName()).log(Level.SEVERE, null, ex);
            throw new JspException("Unable to find the specified class");
        }
        catch (IOException ex) {
            Logger.getLogger(RequestTagHandler.class.getName()).log(Level.SEVERE, null, ex);
            throw new JspException("Status: 422 \n Could not parse the body of the request according to the provided Content-Type.");
        }
    }

    private void addExtraParams() {
        if (StringUtils.isNotBlank((CharSequence)this.item)) {
            this.request.setAttribute(this.item, (Object)this.masonRequest.getId());
        }
    }

    public int doEndTag() throws JspException {
        if (this.shouldEvaluate) {
            this.processOutput();
            return 5;
        }
        return 6;
    }

    private void processOutput() {
        block42: {
            boolean hasAttachment = false;
            Map outputMap = (Map)this.pageContext.getAttribute("output", 1);
            for (Map.Entry tag : outputMap.entrySet()) {
                if (!(tag.getValue() instanceof Attachment)) continue;
                hasAttachment = true;
                break;
            }
            if (this.headers != null) {
                this.headers.entrySet().forEach(entry -> this.response.setHeader((String)entry.getKey(), (String)entry.getValue()));
            }
            try (ServletOutputStream outputStream = this.response.getOutputStream();){
                if (!hasAttachment) {
                    JSONOutput output = null;
                    String header = this.request.getHeader("Accept") == null ? "application/json" : this.request.getHeader("Accept");
                    List<String> list = Arrays.asList(header.split("/"));
                    output = list.contains("xml") ? new XMLOutput() : (list.contains("json+dataset") ? new DatasetOutput() : new JSONOutput());
                    Response masonResponse = new ResponeBuilder(output).build(outputMap);
                    masonResponse.getHeaders().forEach((k, v) -> this.response.setHeader((String)k, (String)v));
                    byte[] bytes = ((MasonOutput)output).format(masonResponse).getBytes(StandardCharsets.UTF_8);
                    this.response.setContentLength(bytes.length);
                    outputStream.write(bytes);
                    outputStream.flush();
                    break block42;
                }
                Response masonResponse = new ResponeBuilder(FileOutput.class).build(outputMap);
                masonResponse.getHeaders().forEach((k, v) -> this.response.setHeader((String)k, (String)v));
                InputStream inputStream = ((Attachment)masonResponse.getPayload()).getStream();
                try (ReadableByteChannel in = Channels.newChannel(inputStream);
                     WritableByteChannel out = Channels.newChannel((OutputStream)outputStream);){
                    ByteBuffer buffer = ByteBuffer.allocate(2048);
                    while (in.read(buffer) != -1) {
                        buffer.flip();
                        out.write(buffer);
                        buffer.clear();
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(RequestTagHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void setItem(String item) {
        this.item = item;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

