/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.tag;

import com.metamug.entity.Request;
import com.metamug.mason.entity.response.ClientErrorResponse;
import com.metamug.mason.entity.response.ErrorResponse;
import com.metamug.mason.entity.response.InternalServerErrorResponse;
import com.metamug.mason.exception.MasonException;
import com.metamug.mason.service.ConnectionProvider;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import javax.sql.DataSource;
import org.json.JSONObject;
import org.json.XML;

public class ExceptionTagHandler
extends BodyTagSupport
implements TryCatchFinally {
    private Object value;
    private DataSource ds;

    public int doEndTag() throws JspException {
        System.out.println("Exception: End Tag");
        Exception exception = (Exception)this.value;
        this.ds = ConnectionProvider.getMasonDatasource();
        JspWriter out = this.pageContext.getOut();
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String header = request.getHeader("Accept") == null ? "application/json" : request.getHeader("Accept");
        try {
            ErrorResponse errorResponse = new InternalServerErrorResponse();
            if (exception.getCause() != null) {
                String cause = exception.getCause().toString();
                if (cause.contains("MySQLSyntaxErrorException") || cause.contains("MySQLIntegrityConstraintViolationException") || cause.contains("MysqlDataTruncation") || cause.contains("SQLException") || cause.contains("PSQLException")) {
                    this.logError(errorResponse, request, exception);
                } else if (cause.contains("NumberFormatException") || cause.contains("ParseException")) {
                    errorResponse.setMessage("Unable to parse input");
                    errorResponse.setStatus(422);
                } else if (cause.contains(MasonException.class.getName())) {
                    MasonException mtgCause = (MasonException)exception.getCause();
                    errorResponse = this.createErrorResponse(errorResponse, mtgCause);
                }
            }
            if (errorResponse instanceof InternalServerErrorResponse) {
                String msg = exception.getMessage();
                if (exception.getCause() != null && exception.getCause().toString().contains(MasonException.class.getName())) {
                    msg = exception.getCause().getMessage();
                }
            }
            response.setStatus(errorResponse.getStatus());
            if (Arrays.asList(header.split("/")).contains("xml")) {
                response.setContentType("application/xml");
                out.println("<response>");
                out.println(XML.toString((Object)errorResponse));
                out.println("</response>");
            } else {
                response.setContentType("application/json");
                JSONObject jsonObject = new JSONObject((Object)errorResponse);
                out.println(jsonObject.toString());
            }
            Logger.getLogger(ExceptionTagHandler.class.getName()).log(Level.SEVERE, exception.getMessage(), exception);
        }
        catch (IOException ex) {
            Logger.getLogger(ExceptionTagHandler.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        return 5;
    }

    private ErrorResponse createErrorResponse(ErrorResponse errorResponse, MasonException mtgCause) throws IOException {
        switch (mtgCause.getError()) {
            case BEARER_TOKEN_MISMATCH: {
                errorResponse = new ClientErrorResponse(401, "Failed to authenticate User");
                break;
            }
            case INCORRECT_ROLE_AUTHENTICATION: {
                errorResponse = new ClientErrorResponse(403, "Authorization Error. Access Denied");
                break;
            }
            case INCORRECT_STATUS_CODE: {
                errorResponse = new ClientErrorResponse(406, "Incorrect Status Code");
                break;
            }
            case INPUT_VALIDATION_ERROR: {
                errorResponse = new ClientErrorResponse(412, "Unable to validate input parameters");
                break;
            }
            case NO_UPLOAD_LISTENER: {
                errorResponse = new ClientErrorResponse(424, "Unable to handle file upload");
                break;
            }
            case PARENT_RESOURCE_MISSING: {
                errorResponse = new ClientErrorResponse(404, "Resource not found");
                break;
            }
            case ROLE_ACCESS_DENIED: {
                errorResponse = new ClientErrorResponse(401, "Access Denied");
                break;
            }
            case SQL_ERROR: {
                this.logError(errorResponse, (HttpServletRequest)this.pageContext.getRequest(), mtgCause.getRootException());
                break;
            }
            case UPLOAD_CODE_ERROR: {
                this.logUploadCodeError(errorResponse, (HttpServletRequest)this.pageContext.getRequest(), mtgCause.getRootException());
                errorResponse.setError("Error during upload process");
                break;
            }
            case UPLOAD_SIZE_EXCEEDED: {
                errorResponse = new ClientErrorResponse(413, "File Size Exceeded");
            }
        }
        return errorResponse;
    }

    private void logError(ErrorResponse errorResponse, HttpServletRequest request, Exception exception) {
        String exceptionMessage = exception.getMessage() != null ? exception.getMessage().replaceAll("(\\w+)_db\\.", "").replaceAll("(\\s|\\n|\\r|\\n\\r)+", " ") : exception.toString();
        if (errorResponse instanceof InternalServerErrorResponse) {
            this.dbLogError((InternalServerErrorResponse)errorResponse, request, exceptionMessage, new StringBuilder());
        }
        Logger.getLogger(ExceptionTagHandler.class.getName()).log(Level.SEVERE, exception.getMessage(), exception);
    }

    private void logCodeError(ErrorResponse response, HttpServletRequest request, Exception exception) {
        StackTraceElement[] stackTrace;
        String exceptionMessage = exception.getMessage() != null ? exception.getMessage().replaceAll("(\\s|\\n|\\r|\\n\\r)+", " ") : exception.toString();
        StringBuilder errorTraceBuilder = new StringBuilder();
        for (StackTraceElement stackTraceElement : stackTrace = exception.getStackTrace()) {
            errorTraceBuilder.append(stackTraceElement);
            if (stackTraceElement.getClassName().contains("CodeTagHandler")) break;
            errorTraceBuilder.append("\n");
        }
        if (response instanceof InternalServerErrorResponse) {
            this.dbLogError((InternalServerErrorResponse)response, request, exceptionMessage, errorTraceBuilder);
        }
        Logger.getLogger(ExceptionTagHandler.class.getName()).log(Level.SEVERE, exception.getMessage(), exception);
    }

    private void logUploadCodeError(ErrorResponse errorResponse, HttpServletRequest request, Exception exception) {
        StackTraceElement[] stackTrace;
        StringBuilder errorTraceBuilder = new StringBuilder();
        for (StackTraceElement stackTraceElement : stackTrace = exception.getStackTrace()) {
            if (stackTraceElement.getClassName().contains("UploadEventTagHandler")) {
                errorTraceBuilder.append(stackTraceElement);
                break;
            }
            errorTraceBuilder.append(stackTraceElement).append("\n");
        }
        String exceptionMessage = exception.getMessage() != null ? exception.getMessage().replaceAll("(\\w+)_db\\.", "").replaceAll("(\\s|\\n|\\r|\\n\\r)+", " ") : exception.toString();
        if (errorResponse instanceof InternalServerErrorResponse) {
            this.dbLogError((InternalServerErrorResponse)errorResponse, request, exceptionMessage, errorTraceBuilder);
        }
        Logger.getLogger(ExceptionTagHandler.class.getName()).log(Level.SEVERE, exception.getMessage(), exception);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void doCatch(Throwable throwable) throws Throwable {
        throw throwable;
    }

    public void doFinally() {
    }

    private void dbLogError(InternalServerErrorResponse response, HttpServletRequest request, String exceptionMessage, StringBuilder errorTraceBuilder) {
        System.out.println("dbLogError");
        Request masonRequest = (Request)request.getAttribute("mtgReq");
        String method = masonRequest.getMethod();
        String resourceURI = (String)request.getAttribute("javax.servlet.forward.request_uri");
        try (Connection con = this.ds.getConnection();
             PreparedStatement stmnt = con.prepareStatement("INSERT INTO error_log (error_id,request_method,message,trace, resource) VALUES(?,?,?,?,?)");){
            stmnt.setString(1, String.valueOf(response.getErrorId()));
            stmnt.setString(2, method);
            stmnt.setString(3, exceptionMessage);
            stmnt.setString(4, errorTraceBuilder.toString());
            stmnt.setString(5, resourceURI);
            stmnt.execute();
        }
        catch (SQLException ex) {
            Logger.getLogger(ExceptionTagHandler.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

