/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.service;

import com.metamug.mason.entity.xrequest.XResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class XRequestService {
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final String UTF8 = "UTF-8";
    private static final String XREQUEST_ERROR = "XRequest error: ";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String APP_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String APP_JSON = "application/json";
    private final OkHttpClient client = new OkHttpClient();
    private boolean outputHeaders;

    public XRequestService(boolean outputHeaders) {
        this.outputHeaders = outputHeaders;
    }

    private XResponse makeRequest(Request request) {
        XResponse xr;
        try (Response response = this.client.newCall(request).execute();){
            HashMap<String, String> headerMap = new HashMap<String, String>();
            if (this.outputHeaders) {
                Headers headers = response.headers();
                for (int i = 0; i < headers.size(); ++i) {
                    headerMap.put(headers.name(i), headers.value(i));
                }
            }
            if (!response.isSuccessful()) {
                String msg = response.message();
                if (response.code() == 404) {
                    msg = "Resource not found!";
                }
                xr = new XResponse(response.code(), headerMap, msg, true, this.outputHeaders);
            } else {
                xr = new XResponse(response.code(), headerMap, response.body().string().trim(), false, this.outputHeaders);
            }
        }
        catch (IOException ex) {
            xr = new XResponse(0, null, XREQUEST_ERROR + ex.getMessage(), true, this.outputHeaders);
        }
        return xr;
    }

    public XResponse get(String url, Map<String, String> headers, Map<String, Object> params) {
        Request.Builder reqBuilder = new Request.Builder().get();
        headers.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            reqBuilder.addHeader(key, value);
        });
        StringBuilder queryParams = new StringBuilder();
        Iterator<String> iterator = params.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                String str = iterator.next();
                String key = URLEncoder.encode(str, UTF8);
                String value = URLEncoder.encode((String)params.get(str), UTF8);
                queryParams.append(key).append("=").append(value);
                if (!iterator.hasNext()) continue;
                queryParams.append("&");
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(XRequestService.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        if (queryParams.length() > 0) {
            url = url + "?" + queryParams.toString();
        }
        Request request = reqBuilder.url(url).build();
        return this.makeRequest(request);
    }

    public XResponse post(String url, Map<String, String> headers, Map<String, Object> params, String body) {
        String contentType;
        Request.Builder reqBuilder = null;
        if (headers.get(CONTENT_TYPE) == null) {
            headers.put(CONTENT_TYPE, APP_FORM_URLENCODED);
        }
        if ((contentType = headers.get(CONTENT_TYPE).toLowerCase()).equals(APP_FORM_URLENCODED)) {
            FormBody.Builder formBuilder = new FormBody.Builder();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                formBuilder.add(entry.getKey(), (String)entry.getValue());
            }
            reqBuilder = new Request.Builder().post((RequestBody)formBuilder.build());
        } else if (contentType.equals(APP_JSON)) {
            if (StringUtils.isNotBlank((CharSequence)body)) {
                RequestBody reqBody = RequestBody.create((MediaType)JSON, (String)body);
                reqBuilder = new Request.Builder().post(reqBody);
            } else {
                JSONObject jo = new JSONObject();
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    jo.put(entry.getKey(), entry.getValue());
                }
                RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)jo.toString());
                reqBuilder = new Request.Builder().post(requestBody);
            }
        }
        if (null == reqBuilder) {
            RequestBody reqbody = RequestBody.create(null, (byte[])new byte[0]);
            reqBuilder = new Request.Builder().post(reqbody);
        }
        for (Map.Entry entry : headers.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            reqBuilder.addHeader(key, value);
        }
        Request request = reqBuilder.url(url).build();
        return this.makeRequest(request);
    }

    public XResponse put(String url, Map<String, String> headers, Map<String, Object> params, String body) {
        Request.Builder reqBuilder = null;
        String contentType = headers.get(CONTENT_TYPE).toLowerCase();
        if (contentType.equals(APP_FORM_URLENCODED)) {
            FormBody.Builder formBuilder = new FormBody.Builder();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                formBuilder.add(entry.getKey(), (String)entry.getValue());
            }
            reqBuilder = new Request.Builder().put((RequestBody)formBuilder.build());
        } else if (contentType.equals(APP_JSON)) {
            if (body != null && !body.equals("")) {
                RequestBody reqBody = RequestBody.create((MediaType)JSON, (String)body);
                reqBuilder = new Request.Builder().put(reqBody);
            } else {
                JSONObject jo = new JSONObject();
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    jo.put(entry.getKey(), entry.getValue());
                }
                RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)jo.toString());
                reqBuilder = new Request.Builder().put(requestBody);
            }
        }
        if (null == reqBuilder) {
            RequestBody reqbody = RequestBody.create(null, (byte[])new byte[0]);
            reqBuilder = new Request.Builder().put(reqbody);
        }
        for (Map.Entry entry : headers.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            reqBuilder.addHeader(key, value);
        }
        Request request = reqBuilder.url(url).build();
        return this.makeRequest(request);
    }

    public XResponse delete(String url, Map<String, Object> params) {
        StringBuilder queryParams = new StringBuilder();
        Iterator<String> iterator = params.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                String str = iterator.next();
                String key = URLEncoder.encode(str, UTF8);
                String value = URLEncoder.encode((String)params.get(str), UTF8);
                queryParams.append(key).append("=").append(value);
                if (!iterator.hasNext()) continue;
                queryParams.append("&");
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(XRequestService.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        if (queryParams.length() > 0) {
            url = url + "?" + queryParams.toString();
        }
        Request request = new Request.Builder().url(url).delete().build();
        return this.makeRequest(request);
    }
}

