/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.service;

import com.metamug.entity.Request;
import com.metamug.entity.Response;
import com.metamug.event.UploadEvent;
import com.metamug.event.UploadListener;
import com.metamug.mason.exception.MasonError;
import com.metamug.mason.exception.MasonException;
import com.metamug.mason.service.ConnectionProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.sql.DataSource;

@MultipartConfig(fileSizeThreshold=0x100000, maxFileSize=0x500000L, maxRequestSize=0x1900000L)
public class UploaderService {
    public final String UPLOAD_ATTR = "_upload";
    private static final String UPLOAD_DIR = "uploads";
    PageContext pageContext;

    public UploaderService(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public boolean upload() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if (request.getContentType() != null && request.getContentType().contains("multipart/form-data")) {
            try {
                String listenerClass;
                Properties prop = new Properties();
                try (InputStream fis = UploaderService.class.getClassLoader().getResourceAsStream("config.properties");){
                    prop.load(fis);
                    listenerClass = prop.getProperty("uploadlistener");
                }
                if (listenerClass == null) {
                    throw new JspTagException("No implementation of UploadListener was found.", (Throwable)new MasonException(MasonError.NO_UPLOAD_LISTENER));
                }
                this.uploadPart(request, listenerClass);
            }
            catch (IllegalStateException ex) {
                if (ex.getMessage().contains("FileSizeLimitExceededException")) {
                    throw new JspException("", (Throwable)new MasonException(MasonError.UPLOAD_SIZE_EXCEEDED));
                }
            }
            catch (IOException | NullPointerException ex) {
                throw new JspException("", (Throwable)new MasonException(MasonError.UPLOAD_CODE_ERROR, ex));
            }
            catch (RuntimeException ex) {
                throw new JspException("", (Throwable)new MasonException(MasonError.UPLOAD_CODE_ERROR, ex));
            }
            catch (Exception ex) {
                throw new JspException("", (Throwable)new MasonException(MasonError.UPLOAD_CODE_ERROR, ex));
            }
        }
        return true;
    }

    private void callUploadEvent(File uploadedFile, String listenerClass, Request req) throws Exception {
        Response result = null;
        Class<?> cls = Class.forName(listenerClass);
        Object newInstance = cls.newInstance();
        if (UploadListener.class.isAssignableFrom(cls)) {
            UploadListener listener = (UploadListener)newInstance;
            if (uploadedFile != null) {
                DataSource ds = ConnectionProvider.getMasonDatasource();
                result = listener.uploadPerformed(new UploadEvent(uploadedFile, uploadedFile.getName(), req), ds);
            }
        } else {
            throw new JspException("", (Throwable)new MasonException(MasonError.CLASS_NOT_IMPLEMENTED, "Class " + cls + " isn't an UploadListener."));
        }
        if (result instanceof Response) {
            this.pageContext.setAttribute("_upload", ((Response)result).getPayload());
        } else {
            this.pageContext.setAttribute("_upload", result);
        }
    }

    private void uploadPart(HttpServletRequest request, String listenerClass) throws Exception {
        try {
            String uploadFileLocation = System.getProperty("catalina.base") + File.separator + UPLOAD_DIR + request.getContextPath();
            Files.createDirectories(Paths.get(uploadFileLocation, new String[0]), new FileAttribute[0]);
            List fileParts = request.getParts().stream().filter(part -> "file".equals(part.getName())).collect(Collectors.toList());
            for (Part filePart : fileParts) {
                String fileName = Paths.get(filePart.getSubmittedFileName(), new String[0]).getFileName().toString();
                File uploadedFile = new File(uploadFileLocation + File.separator + filePart.getSubmittedFileName());
                if (uploadedFile.isDirectory()) continue;
                try (FileOutputStream fos = new FileOutputStream(uploadedFile);
                     InputStream fileContent = filePart.getInputStream();){
                    int read;
                    byte[] bytes = new byte[1024];
                    while ((read = fileContent.read(bytes)) != -1) {
                        fos.write(bytes, 0, read);
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(UploaderService.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.callUploadEvent(uploadedFile, listenerClass, (Request)request.getAttribute("mtgReq"));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | RuntimeException ex) {
            throw new JspTagException("Unable to load Upload Event Listener", (Throwable)new MasonException(MasonError.NO_UPLOAD_LISTENER));
        }
    }
}

