/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.plugin;

import com.metamug.entity.Request;
import com.metamug.entity.Response;
import com.metamug.exec.RequestProcessable;
import com.metamug.mason.entity.request.MasonRequest;
import com.metamug.mason.exception.MasonError;
import com.metamug.mason.exception.MasonException;
import groovy.lang.Binding;
import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.File;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import javax.sql.DataSource;

public class GroovyRunner
implements RequestProcessable {
    private static final String RESPONSE_VARIABLE = "response";
    private static final String SCRIPT_VARIABLE_PREFIX = "_$";
    private static final String SCRIPT_ROOT = "/WEB-INF/scripts/";

    public Response process(Request request, DataSource ds, Map<String, Object> args) throws Exception {
        String argFile = (String)args.get("file");
        LinkedHashMap object = new LinkedHashMap();
        try {
            MasonRequest masonRequest = (MasonRequest)request;
            File scriptFolder = new File(masonRequest.getRealPath(SCRIPT_ROOT));
            URL[] urls = new URL[]{scriptFolder.toURI().toURL()};
            GroovyScriptEngine engine = new GroovyScriptEngine(urls, this.getClass().getClassLoader());
            Binding binding = new Binding();
            for (Map.Entry requestVariable : request.getParams().entrySet()) {
                binding.setVariable(SCRIPT_VARIABLE_PREFIX + (String)requestVariable.getKey(), requestVariable.getValue());
            }
            binding.setVariable(SCRIPT_VARIABLE_PREFIX, (Object)request);
            binding.setVariable(RESPONSE_VARIABLE, object);
            engine.run(argFile, binding);
        }
        catch (ResourceException | ScriptException | IllegalArgumentException | SecurityException ex) {
            Logger.getLogger(GroovyRunner.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            throw new JspException("", (Throwable)new MasonException(MasonError.SCRIPT_ERROR));
        }
        return new Response(object);
    }
}

