/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.entity.xrequest;

import com.metamug.entity.Response;
import java.util.Arrays;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;

public class XResponse {
    private int statusCode;
    private Map<String, String> headers;
    private String body;
    private boolean error;
    private boolean outputHeaders;

    public XResponse(int statusCode, Map<String, String> headers, String body, boolean error, boolean outputHeaders) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.body = body;
        this.error = error;
        this.outputHeaders = outputHeaders;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Response getResponse(String accept, String xrequestAccept) {
        Response response;
        if (Arrays.asList(accept.split("/")).contains("xml")) {
            response = xrequestAccept.equals("xml") ? this.getXmlForXmlXResponse() : this.getXmlForJsonXResponse();
        } else {
            Response response2 = response = xrequestAccept.equals("xml") ? this.getJsonForXmlXResponse() : this.getJsonForJsonXResponse();
            if (!this.outputHeaders) {
                JSONObject payload = (JSONObject)response.getPayload();
                try {
                    response.setPayload((Object)payload.getJSONObject("body"));
                }
                catch (JSONException jx) {
                    try {
                        response.setPayload((Object)payload.getJSONArray("body"));
                    }
                    catch (JSONException jx1) {
                        response.setPayload((Object)payload.getString("body"));
                    }
                }
            }
        }
        return response;
    }

    private Response getJsonForXmlXResponse() {
        if (this.error) {
            return new Response((Object)this.getErrorJson());
        }
        return new Response((Object)this.getJson(this.statusCode, this.headers, this.body));
    }

    private Response getJsonForJsonXResponse() {
        if (this.error) {
            return new Response((Object)this.getErrorJson());
        }
        JSONObject obj = new JSONObject();
        obj.put("statusCode", this.statusCode);
        this.putHeaders(obj, this.headers);
        try {
            JSONObject bodyObject = new JSONObject(this.body);
            obj.put("body", (Object)bodyObject);
        }
        catch (JSONException jx) {
            try {
                JSONArray bodyArray = new JSONArray(this.body);
                obj.put("body", (Object)bodyArray);
            }
            catch (JSONException jx1) {
                obj.put("body", (Object)"Could Not Parse JSON Response.");
            }
        }
        return new Response((Object)obj);
    }

    private Response getXmlForXmlXResponse() {
        if (this.error) {
            return new Response((Object)this.getErrorXml());
        }
        return new Response((Object)XML.toString((Object)this.getJsonForXmlXResponse()));
    }

    private Response getXmlForJsonXResponse() {
        if (this.error) {
            return new Response((Object)this.getErrorXml());
        }
        JSONObject obj = new JSONObject();
        obj.put("statusCode", this.statusCode);
        this.putHeaders(obj, this.headers);
        try {
            JSONObject bodyObject = new JSONObject(this.body);
            obj.put("body", (Object)bodyObject);
        }
        catch (JSONException jx) {
            try {
                JSONArray bodyArray = new JSONArray(this.body);
                JSONObject responseBody = new JSONObject();
                responseBody.put("row", (Object)bodyArray);
                obj.put("body", (Object)responseBody);
            }
            catch (JSONException jx1) {
                obj.put("body", (Object)"Could not parse json response.");
            }
        }
        return new Response((Object)XML.toString((Object)obj));
    }

    private JSONObject getErrorJson() {
        return this.getJson(this.statusCode, this.headers, this.body);
    }

    private String getErrorXml() {
        return XML.toString((Object)this.getErrorJson());
    }

    private JSONObject getJson(int statusCode, Map<String, String> headers, String body) {
        JSONObject obj = new JSONObject();
        obj.put("statusCode", statusCode);
        this.putHeaders(obj, headers);
        obj.put("body", (Object)body);
        return obj;
    }

    private void putHeaders(JSONObject object, Map<String, String> headers) {
        JSONObject headersObject = new JSONObject();
        if (headers != null) {
            headers.entrySet().forEach(entry -> headersObject.put((String)entry.getKey(), entry.getValue()));
        }
        object.put("headers", (Object)headersObject);
    }
}

