/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.entity.response;

import com.metamug.mason.entity.response.DbLoggable;
import com.metamug.mason.entity.response.ErrorResponse;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;

public class InternalServerErrorResponse
extends ErrorResponse {
    protected String errorId;

    public InternalServerErrorResponse() {
        super(512, "Internal Server Error", "API Error. Please contact your API administrator.");
        String timestamp = String.valueOf(System.currentTimeMillis());
        long hash = UUID.nameUUIDFromBytes(timestamp.getBytes()).getMostSignificantBits();
        this.errorId = String.valueOf(Math.abs(hash));
    }

    public InternalServerErrorResponse(DbLoggable dbLoggable, DataSource ds, HttpServletRequest request, String exceptionMessage, StringBuilder errorTraceBuilder) {
        this();
        dbLoggable.log(this.errorId, request, ds, exceptionMessage, errorTraceBuilder);
    }

    public String getErrorId() {
        return this.errorId;
    }

    public void setErrorId(String errorId) {
        this.errorId = errorId;
    }
}

