/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.entity.response;

import com.metamug.mason.entity.response.JSONOutput;
import java.util.SortedMap;
import org.apache.taglibs.standard.tag.common.sql.ResultImpl;
import org.json.JSONArray;
import org.json.JSONObject;

public class DatasetOutput
extends JSONOutput {
    public static final String COLUMNS = "columns";
    public static final String DATASET = "dataset";

    @Override
    protected Object getJson(ResultImpl impl) {
        return this.resultSetToDataSet(impl);
    }

    private JSONObject resultSetToDataSet(ResultImpl resultImpl) {
        SortedMap[] rows = resultImpl.getRows();
        String[] columnNames = resultImpl.getColumnNames();
        JSONObject object = new JSONObject();
        JSONArray columnArray = new JSONArray();
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i].isEmpty() || columnNames[i].equalsIgnoreCase("null") ? "col" + i : columnNames[i];
            columnArray.put((Object)columnName);
        }
        object.put(COLUMNS, (Object)columnArray);
        JSONArray dataSetArray = new JSONArray();
        for (SortedMap row : rows) {
            JSONArray rowArray = new JSONArray();
            for (int i = 0; i < columnNames.length; ++i) {
                String columnName = columnNames[i].isEmpty() || columnNames[i].equalsIgnoreCase("null") ? "col" + i : columnNames[i];
                rowArray.put(row.get(columnName) != null ? row.get(columnName) : "null");
            }
            dataSetArray.put((Object)rowArray);
        }
        object.put(DATASET, (Object)dataSetArray);
        return object;
    }

    @Override
    public String getContentType() {
        return "application/json+dataset";
    }
}

