/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.entity.request;

import com.metamug.entity.Request;
import com.metamug.entity.Resource;
import com.metamug.mason.entity.request.JspResource;
import com.metamug.mason.entity.request.MasonRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class RequestAdapter {
    private HttpServletRequest httpRequest;
    private JspResource jspResource;

    public RequestAdapter(HttpServletRequest request) throws IOException, ServletException {
        this.httpRequest = request;
    }

    public void setJspResource(JspResource jspResource) {
        this.jspResource = jspResource;
    }

    public Request getRequest() {
        MasonRequest masonRequest = this.buildRequest();
        return masonRequest;
    }

    private MasonRequest buildRequest() {
        int position;
        List<String> ourListElements = this.inputUriExtraction(this.jspResource.getResourceUri());
        List<String> finalResponseElement = this.resultUriExtraction(this.jspResource.getResourceUri());
        MasonRequest request = new MasonRequest(this.httpRequest);
        request.setUri(this.jspResource.getResourceUri());
        if (finalResponseElement.get(finalResponseElement.size() - 1).equals("G")) {
            request.setUri(null);
        }
        if (finalResponseElement.get(position = finalResponseElement.size() - 1).equals("I")) {
            request.setId(ourListElements.get(position));
            --position;
        }
        int stackIterator = finalResponseElement.size() - 1;
        Stack<String> stack = new Stack<String>();
        for (String element : finalResponseElement) {
            stack.push(element);
        }
        String resourceName = null;
        while (!stack.empty()) {
            if (((String)stack.peek()).equals("R")) {
                resourceName = ourListElements.get(stackIterator);
                stack.pop();
                break;
            }
            --stackIterator;
            stack.pop();
        }
        position = stackIterator--;
        if (finalResponseElement.size() > 1) {
            for (int index = 0; index < finalResponseElement.size() - 1; ++index) {
                if (!finalResponseElement.get(index).equals("I") || !finalResponseElement.get(index + 1).equals("I")) continue;
                resourceName = null;
                request.setId(null);
                break;
            }
        }
        Resource resource = new Resource(resourceName, this.jspResource.getVersion());
        request.setResource(resource);
        for (int index = position; index >= 0; --index) {
            if (!finalResponseElement.get(index).equals("I")) continue;
            request.setPid(ourListElements.get(index));
            break;
        }
        Resource parentResource = null;
        while (!stack.empty()) {
            if (((String)stack.peek()).equals("R")) {
                parentResource = new Resource(ourListElements.get(stackIterator), resource.getVersion());
                stack.pop();
                break;
            }
            --stackIterator;
            stack.pop();
        }
        request.setParent(parentResource);
        return request;
    }

    private List<String> inputUriExtraction(String resourceUri) {
        resourceUri = resourceUri + "/";
        int sizeOfresourceUri = resourceUri.length();
        ArrayList<String> ourListElements = new ArrayList<String>(sizeOfresourceUri);
        int positionOfEachElement = 1;
        for (int index = 1; index < sizeOfresourceUri; ++index) {
            if (resourceUri.charAt(index) != '/') continue;
            String tokensValue = resourceUri.substring(positionOfEachElement, index);
            positionOfEachElement = index + 1;
            ourListElements.add(tokensValue);
        }
        return ourListElements;
    }

    private List<String> resultUriExtraction(String resourceUri) {
        String listInputAtFuture = "/";
        String listInputAtPresent = "";
        String listInputAtAlways = "";
        String listInputAtPast = "";
        resourceUri = resourceUri + "/";
        int sizeOfresourceUri = resourceUri.length();
        ArrayList<String> finalResponseElement = new ArrayList<String>(sizeOfresourceUri);
        int positionOfEachElement = 1;
        String prevToken = " ";
        String currentToken = " ";
        for (int index = 1; index < sizeOfresourceUri; ++index) {
            if (resourceUri.charAt(index) != '/') continue;
            String tokensValue = resourceUri.substring(positionOfEachElement, index);
            positionOfEachElement = index + 1;
            listInputAtPast = listInputAtFuture + tokensValue;
            listInputAtAlways = listInputAtPresent + listInputAtPast;
            if (!this.jspResource.resourceExists(listInputAtAlways)) {
                if (prevToken.equals(" ")) {
                    currentToken = "G";
                    listInputAtPresent = listInputAtAlways;
                } else if (prevToken.equals("G")) {
                    currentToken = "G";
                    listInputAtPresent = listInputAtAlways;
                } else if (prevToken.equals("R")) {
                    currentToken = "I";
                }
            } else {
                currentToken = "R";
            }
            prevToken = currentToken;
            finalResponseElement.add(prevToken);
        }
        return finalResponseElement;
    }
}

