/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.entity.request;

import java.io.File;
import javax.servlet.http.HttpServletRequest;

public class JspResource {
    private HttpServletRequest request;
    private String jspPath;
    private float version;
    private String resourceUri;
    private static final int VERSION_LENGTH = 3;
    private static final String JSP_EXTN = ".jsp";
    private static final String RESOURCES_FOLDER = "/WEB-INF/resources/";

    public String getResourceUri() {
        return this.resourceUri;
    }

    public JspResource(HttpServletRequest request) {
        this.request = request;
        String resourcePath = this.request.getServletPath();
        int versionIndex = 2;
        try {
            this.version = Float.parseFloat(resourcePath.substring(versionIndex, versionIndex + 3));
        }
        catch (NumberFormatException e) {
            versionIndex = resourcePath.indexOf("/", resourcePath.indexOf("/") + 1) + 2;
            this.version = Float.parseFloat(resourcePath.substring(versionIndex, versionIndex + 3));
        }
        this.resourceUri = resourcePath.substring(versionIndex + 3);
    }

    protected boolean resourceExists(String resourcePath) {
        String jspPath = "/WEB-INF/resources/v" + this.version + resourcePath + JSP_EXTN;
        boolean exists = new File(this.request.getServletContext().getRealPath(jspPath)).exists();
        if (exists) {
            this.jspPath = jspPath;
        }
        return exists;
    }

    public String getJspPath() {
        return this.jspPath;
    }

    public float getVersion() {
        return this.version;
    }
}

