/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason;

import com.metamug.entity.Request;
import com.metamug.mason.HttpRequestWrapper;
import com.metamug.mason.entity.request.JspResource;
import com.metamug.mason.entity.request.RequestAdapter;
import com.metamug.mason.service.ConnectionProvider;
import com.metamug.mason.service.QueryManagerService;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;

@MultipartConfig(fileSizeThreshold=0x100000, maxFileSize=0x500000L, maxRequestSize=0x1900000L)
public class Router
implements Filter {
    private String encoding;
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String QUERY_FILE_NAME = "query.properties";
    public static final String MASON_QUERY = "masonQuery";
    public static final String DATA_SOURCE = "datasource";
    private ConnectionProvider connectionProvider;
    public static final String CONNECTION_PROVIDER = "connectionProvider";
    public static final String MASON_REQUEST = "mtgReq";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (null == request.getCharacterEncoding()) {
            request.setCharacterEncoding(this.encoding);
        }
        String path = req.getServletPath();
        String[] tokens = path.split("/");
        int versionTokenIndex = -1;
        for (int i = 0; i < tokens.length; ++i) {
            if (!tokens[i].matches("^.*(v\\d+\\.\\d+).*$")) continue;
            versionTokenIndex = i;
            break;
        }
        if (tokens.length <= 2 || path.contains("index") || path.contains("docs")) {
            chain.doFilter(request, response);
            return;
        }
        this.processRequest(req, res);
    }

    private void processRequest(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (!this.validContentType(req)) {
            this.writeError(res, 415, "Unsupported Media Type");
            return;
        }
        res.setContentType("application/json");
        String resourceName = "";
        try {
            RequestAdapter adapter = new RequestAdapter(req);
            JspResource jspResource = new JspResource(req);
            adapter.setJspResource(jspResource);
            Request masonRequest = adapter.getRequest();
            resourceName = masonRequest.getResource().getName();
            if (resourceName == null) {
                this.writeError(res, 404, "Resource Not Found");
                return;
            }
            req.setAttribute(MASON_REQUEST, (Object)masonRequest);
            req.setAttribute(DATA_SOURCE, req.getServletContext().getAttribute(DATA_SOURCE));
            req.setAttribute(CONNECTION_PROVIDER, (Object)this.connectionProvider);
            Object queryMap = req.getServletContext().getAttribute(MASON_QUERY);
            req.setAttribute(MASON_QUERY, queryMap);
            HttpRequestWrapper requestWrapper = new HttpRequestWrapper(req);
            req.getRequestDispatcher(jspResource.getJspPath()).forward((ServletRequest)requestWrapper, (ServletResponse)res);
        }
        catch (IOException | ServletException | JSONException ex) {
            if (ex.getClass().toString().contains("com.eclipsesource.json.ParseException")) {
                this.writeError(res, 422, "Could not parse the body of the request according to the provided Content-Type.");
            } else if (ex.getCause() != null) {
                String[] causeSplit = ex.getCause().toString().split(": ");
                String cause = causeSplit.length > 1 ? causeSplit[1].replaceAll("(\\s|\\n|\\r|\\n\\r)+", " ") : "";
                this.writeError(res, 500, cause);
            } else if (ex.getMessage().contains("ELException")) {
                this.writeError(res, 512, "Incorrect test condition in '" + resourceName + "' resource");
            } else {
                this.writeError(res, 500, ex.getMessage().replaceAll("(\\s|\\n|\\r|\\n\\r)+", " "));
                Logger.getLogger(Router.class.getName()).log(Level.SEVERE, "Router " + resourceName + ":{0}", ex.getMessage());
            }
            Logger.getLogger(Router.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (NullPointerException ex) {
            Logger.getLogger(Router.class.getName()).log(Level.SEVERE, "Router " + resourceName + ":{0}", ex.getMessage());
            this.writeError(res, 404, "Resource Not Found" + ex.getMessage());
        }
    }

    public void writeError(HttpServletResponse res, int status, String message) throws IOException {
        Logger.getLogger(JspResource.class.getName()).log(Level.WARNING, "Error: " + message);
        try (PrintWriter writer = res.getWriter();){
            res.setContentType("application/json;charset=UTF-8");
            res.setCharacterEncoding("UTF-8");
            res.setStatus(status);
            JSONObject obj = new JSONObject();
            obj.put("status", status);
            obj.put("message", (Object)message);
            writer.print(obj.toString());
            writer.flush();
        }
    }

    public void destroy() {
        try {
            this.connectionProvider.shutdown();
        }
        catch (SQLException | NamingException ex) {
            Logger.getLogger(Router.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void init(FilterConfig config) {
        this.encoding = config.getInitParameter("requestEncoding");
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        if (config.getInitParameter(DATA_SOURCE) != null) {
            config.getServletContext().setAttribute(DATA_SOURCE, (Object)config.getInitParameter(DATA_SOURCE));
        } else {
            config.getServletContext().setAttribute(DATA_SOURCE, (Object)"jdbc/mason");
        }
        if (config.getInitParameterNames().hasMoreElements()) {
            String param = (String)config.getInitParameterNames().nextElement();
            config.getServletContext().setAttribute(param, (Object)config.getInitParameter(param));
        }
        InputStream queryFileInputStream = Router.class.getClassLoader().getResourceAsStream(QUERY_FILE_NAME);
        QueryManagerService queryManagerService = new QueryManagerService(queryFileInputStream);
        try {
            this.connectionProvider = new ConnectionProvider((String)config.getServletContext().getAttribute(DATA_SOURCE));
            config.getServletContext().setAttribute(MASON_QUERY, queryManagerService.getQueryMap());
            config.getServletContext().setAttribute(CONNECTION_PROVIDER, (Object)this.connectionProvider);
            queryFileInputStream.close();
        }
        catch (IOException | SQLException | NamingException ex) {
            Logger.getLogger(Router.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private boolean validContentType(HttpServletRequest req) {
        boolean validContentType;
        String contentType = req.getContentType() == null ? "text/html" : req.getContentType().toLowerCase();
        String method = req.getMethod();
        boolean bl = validContentType = contentType.contains("text/html") || contentType.contains("application/xml") || contentType.contains("application/x-www-form-urlencoded") || contentType.contains("application/json") || contentType.contains("multipart/form-data");
        return "GET".equals(method) || "DELETE".equals(method) || validContentType;
    }
}

