/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.tag;

import com.metamug.entity.Request;
import com.metamug.mason.exception.MasonError;
import com.metamug.mason.exception.MasonException;
import com.metamug.mason.tag.RestTag;
import groovy.lang.Binding;
import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;

public class ScriptTagHandler
extends RestTag {
    private String file;
    private String var;
    private static final String SCRIPT_ROOT = "scripts/";

    public void setFile(String file) {
        this.file = file;
    }

    public void setVar(String var) {
        this.var = var;
    }

    @Override
    public int doStartTag() throws JspException {
        super.doStartTag();
        this.runScript();
        return 0;
    }

    public void runScript() throws JspException {
        try {
            GroovyScriptEngine engine = new GroovyScriptEngine(new URL[]{ScriptTagHandler.class.getClassLoader().getResource("..")});
            Binding binding = new Binding();
            Request masonReq = (Request)this.request.getAttribute("mtgReq");
            binding.setVariable("_request", (Object)masonReq);
            binding.setVariable("_context", (Object)this.pageContext);
            LinkedHashMap object = new LinkedHashMap();
            binding.setVariable(this.var, object);
            engine.run(SCRIPT_ROOT + this.file, binding);
            this.addToBus(this.var, object);
        }
        catch (ResourceException | ScriptException | IllegalArgumentException | SecurityException ex) {
            Logger.getLogger(ScriptTagHandler.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            throw new JspException("", (Throwable)new MasonException(MasonError.SCRIPT_ERROR));
        }
    }
}

