/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.tag;

import com.metamug.entity.Request;
import com.metamug.entity.Resource;
import com.metamug.mason.exception.MasonError;
import com.metamug.mason.exception.MasonException;
import com.metamug.mason.service.AuthService;
import com.metamug.mason.service.ConnectionProvider;
import com.metamug.mason.tag.RestTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang3.StringUtils;

public class ResourceTagHandler
extends RestTag {
    private Request masonRequest;
    private String auth;
    private String parentName;
    private transient AuthService authService;
    public static final int STATUS_METHOD_NOT_ALLOWED = 405;
    public static final String MSG_METHOD_NOT_ALLOWED = "Method not allowed";
    public static final int STATUS_RESOURCE_NOT_FOUND = 404;
    public static final String MSG_RESOURCE_NOT_FOUND = "Resource not found";
    public static final String ACCESS_DENIED = "Access Denied due to unauthorization";
    public static final String ACCESS_FORBIDDEN = "Access Denied due to unauthorization!";
    public static final String BEARER_ = "Bearer ";
    private List<String> childMethods = new ArrayList<String>();

    public void setAuth(String auth) {
        this.auth = auth;
    }

    public void addChildMethod(String method) {
        this.childMethods.add(method.toLowerCase());
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    @Override
    public int doStartTag() throws JspException {
        super.doStartTag();
        if (StringUtils.isNotBlank((CharSequence)this.auth)) {
            this.processAuth();
        }
        this.masonRequest = (Request)this.request.getAttribute("mtgReq");
        Resource parent = this.masonRequest.getParent();
        if (parent != null && !parent.getName().equalsIgnoreCase(this.parentName)) {
            throw new JspException("Parent resource not found", (Throwable)new MasonException(MasonError.PARENT_RESOURCE_MISSING));
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        String requestMethod = this.masonRequest.getMethod().toLowerCase();
        if (!this.childMethods.contains(requestMethod)) {
            this.print405();
        } else {
            this.print404();
        }
        return 5;
    }

    private void print404() {
        this.response.setContentType("application/json");
        this.response.setStatus(404);
        try {
            this.pageContext.getOut().print("{\"message\":\"Resource not found\",\"status\":404}");
        }
        catch (IOException ex) {
            Logger.getLogger(ResourceTagHandler.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void print405() {
        this.response.setContentType("application/json");
        this.response.setStatus(405);
        try {
            this.pageContext.getOut().print("{\"message\":\"Method not allowed\",\"status\":405}");
        }
        catch (IOException ex) {
            Logger.getLogger(ResourceTagHandler.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void processAuth() throws JspException {
        block5: {
            String header = this.request.getHeader("Authorization");
            if (header == null) {
                throw new JspException(ACCESS_DENIED, (Throwable)new MasonException(MasonError.ROLE_ACCESS_DENIED));
            }
            Request masonReq = (Request)this.request.getAttribute("mtgReq");
            this.authService = new AuthService((ConnectionProvider)this.request.getAttribute("connectionProvider"));
            try {
                if (header.contains("Basic ")) {
                    String authQuery = (String)this.request.getServletContext().getAttribute("MTG_AUTH_BASIC");
                    masonReq.setUid(this.authService.validateBasic(header, this.auth, authQuery.trim()));
                    break block5;
                }
                if (header.contains(BEARER_)) {
                    String bearerToken = header.replaceFirst(BEARER_, "");
                    masonReq.setUid(this.authService.validateBearer(bearerToken.trim(), this.auth));
                    break block5;
                }
                throw new JspException(ACCESS_DENIED, (Throwable)new MasonException(MasonError.ROLE_ACCESS_DENIED));
            }
            catch (IllegalArgumentException ex) {
                throw new JspException(ACCESS_DENIED, (Throwable)new MasonException(MasonError.ROLE_ACCESS_DENIED));
            }
        }
    }
}

