/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.tag;

import com.metamug.entity.Attachment;
import com.metamug.entity.Request;
import com.metamug.entity.Response;
import com.metamug.mason.entity.response.DatasetOutput;
import com.metamug.mason.entity.response.FileOutput;
import com.metamug.mason.entity.response.JSONOutput;
import com.metamug.mason.entity.response.MasonOutput;
import com.metamug.mason.entity.response.ResponeBuilder;
import com.metamug.mason.entity.response.XMLOutput;
import com.metamug.mason.service.UploaderService;
import com.metamug.mason.tag.RequestTag;
import com.metamug.mason.tag.ResourceTagHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.jsp.JspException;

public class RequestTagHandler
extends RequestTag {
    private boolean item;
    private boolean evaluate;
    private Request masonRequest;
    protected ResourceTagHandler parent;

    @Override
    public int doStartTag() throws JspException {
        super.doStartTag();
        this.parent = (ResourceTagHandler)this.getParent();
        this.parent.addChildMethod(this.method);
        this.masonRequest = (Request)this.request.getAttribute("mtgReq");
        if (this.method.equalsIgnoreCase(this.masonRequest.getMethod())) {
            boolean bl = this.evaluate = this.masonRequest.getId() != null == this.item;
            if (this.evaluate) {
                HashMap output = new HashMap();
                this.pageContext.setAttribute("output", output);
                if (this.method.equalsIgnoreCase("POST")) {
                    UploaderService uploader = new UploaderService(this.pageContext);
                    uploader.upload();
                }
                return 1;
            }
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        if (this.evaluate) {
            this.processOutput();
            return 5;
        }
        return 6;
    }

    private void processOutput() {
        block42: {
            String header = this.request.getHeader("Accept") == null ? "application/json" : this.request.getHeader("Accept");
            boolean hasAttachment = false;
            Map outputMap = (Map)this.pageContext.getAttribute("output", 1);
            for (Map.Entry tag : outputMap.entrySet()) {
                if (!(tag.getValue() instanceof Attachment)) continue;
                hasAttachment = true;
                break;
            }
            if (this.headers != null) {
                this.headers.entrySet().forEach(entry -> this.response.setHeader((String)entry.getKey(), (String)entry.getValue()));
            }
            try (ServletOutputStream outputStream = this.response.getOutputStream();){
                if (!hasAttachment) {
                    MasonOutput output = null;
                    List<String> list = Arrays.asList(header.split("/"));
                    output = list.contains("xml") ? new XMLOutput() : (list.contains("json+dataset") ? new DatasetOutput() : new JSONOutput());
                    Response masonResponse = new ResponeBuilder(output).build(outputMap);
                    masonResponse.getHeaders().forEach((k, v) -> this.response.setHeader(k, v));
                    byte[] bytes = output.format(masonResponse).getBytes(StandardCharsets.UTF_8);
                    this.response.setContentLength(bytes.length);
                    outputStream.write(bytes);
                    outputStream.flush();
                    break block42;
                }
                Response masonResponse = new ResponeBuilder(FileOutput.class).build(outputMap);
                masonResponse.getHeaders().forEach((k, v) -> this.response.setHeader(k, v));
                InputStream inputStream = ((Attachment)masonResponse.getPayload()).getStream();
                try (ReadableByteChannel in = Channels.newChannel(inputStream);
                     WritableByteChannel out = Channels.newChannel((OutputStream)outputStream);){
                    ByteBuffer buffer = ByteBuffer.allocate(2048);
                    while (in.read(buffer) != -1) {
                        buffer.flip();
                        out.write(buffer);
                        buffer.clear();
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(RequestTagHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void setItem(boolean i) {
        this.item = i;
    }
}

