/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.tag;

import com.metamug.entity.Request;
import com.metamug.mason.exception.MasonError;
import com.metamug.mason.exception.MasonException;
import com.metamug.mason.tag.RestTag;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.jsp.JspException;

public class ParamTagHandler
extends RestTag {
    private String name;
    private String type;
    private Boolean isRequired;
    private Double max;
    private Double min;
    private Integer maxLen;
    private Integer minLen;
    private String pattern;
    private String defaultValue;
    private String value;

    /*
     * Unable to fully structure code
     */
    public int doEndTag() throws JspException {
        block38: {
            mtgReq = (Request)this.pageContext.getRequest().getAttribute("mtgReq");
            if (this.value == null) {
                if (this.defaultValue != null) {
                    mtgReq.setDefault(this.name, this.defaultValue);
                    this.release();
                    return 6;
                }
                if (this.isRequired != null && this.isRequired.booleanValue()) {
                    throw new JspException("", (Throwable)new MasonException(MasonError.INPUT_VALIDATION_ERROR, this.name + " parameter can't be null"));
                }
            }
            if (this.pattern != null) {
                try {
                    if (!this.value.matches(this.pattern)) {
                        throw new JspException("", (Throwable)new MasonException(MasonError.INPUT_VALIDATION_ERROR, "Input value doesn't match with specified pattern of " + this.name + " parameter"));
                    }
                }
                catch (PatternSyntaxException ex) {
                    throw new JspException("", (Throwable)new MasonException(MasonError.INPUT_VALIDATION_ERROR, "Incorrect pattern syntax of " + this.name + " parameter"));
                }
            }
            if (this.type == null) break block38;
            var4_5 = this.type.toLowerCase();
            var5_6 = -1;
            switch (var4_5.hashCode()) {
                case 3076014: {
                    if (!var4_5.equals("date")) break;
                    var5_6 = 0;
                    break;
                }
                case 1793702779: {
                    if (!var4_5.equals("datetime")) break;
                    var5_6 = 1;
                    break;
                }
                case 96619420: {
                    if (!var4_5.equals("email")) break;
                    var5_6 = 2;
                    break;
                }
                case -1034364087: {
                    if (!var4_5.equals("number")) break;
                    var5_6 = 3;
                    break;
                }
                case 3556653: {
                    if (!var4_5.equals("text")) break;
                    var5_6 = 4;
                    break;
                }
                case 3560141: {
                    if (!var4_5.equals("time")) break;
                    var5_6 = 5;
                    break;
                }
                case 116079: {
                    if (!var4_5.equals("url")) break;
                    var5_6 = 6;
                }
            }
            switch (var5_6) {
                case 0: {
                    if (this.pattern != null) break;
                    try {
                        this.validateDateTime(this.value, "yyyy-MM-dd");
                        break;
                    }
                    catch (ParseException ex) {
                        throw new JspException("", (Throwable)new MasonException(MasonError.INPUT_VALIDATION_ERROR, this.name + " parameter can't be null"));
                    }
                }
                case 1: {
                    if (this.pattern != null) break;
                    try {
                        this.validateDateTime(this.value, "yyyy-MM-dd HH:mm:ss");
                        break;
                    }
                    catch (ParseException ex) {
                        throw new JspException("", (Throwable)new MasonException(MasonError.INPUT_VALIDATION_ERROR, "Incorrect datetime pattern of " + this.name + " parameter"));
                    }
                }
                case 2: {
                    emailPattern = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
                    regexPattern = Pattern.compile(emailPattern);
                    matcher = regexPattern.matcher(this.value);
                    if (matcher.matches()) break;
                    throw new JspException("", (Throwable)new MasonException(MasonError.INPUT_VALIDATION_ERROR, "Invalid email input"));
                }
                case 3: {
                    try {
                        val = Double.parseDouble(this.value);
                        if (this.max != null && val > (maxVal = this.max.doubleValue())) {
                            throw new JspException("", (Throwable)new MasonException(MasonError.INPUT_VALIDATION_ERROR, "Max value allowed for " + this.name + " is " + maxVal));
                        }
                        if (this.min != null && val < (minVal = this.min.doubleValue())) {
                            throw new JspException("", (Throwable)new MasonException(MasonError.INPUT_VALIDATION_ERROR, "Min value allowed for " + this.name + " is " + minVal));
                        }
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new JspException("", (Throwable)new MasonException(MasonError.INPUT_VALIDATION_ERROR, "Empty or invalid parameter '" + this.name + "' value"));
                    }
                }
                case 4: {
                    if (this.maxLen == null) ** GOTO lbl88
                    maxLength = this.maxLen.intValue();
                    try {
                        if ((double)this.value.length() > maxLength) {
                            throw new JspException("", (Throwable)new MasonException(MasonError.INPUT_VALIDATION_ERROR, "Input " + this.value + " can be " + maxLength + " character long for " + this.name + " parameter"));
                        }
                    }
                    catch (NullPointerException ex) {
                        if (this.isRequired == null) ** GOTO lbl88
                        throw new JspException("", (Throwable)new MasonException(MasonError.INPUT_VALIDATION_ERROR, this.name + " parameter can't be null"));
                    }
lbl88:
                    // 3 sources

                    if (this.minLen == null) break;
                    minLength = this.minLen.intValue();
                    if (!((double)this.value.length() < minLength)) break;
                    throw new JspException("", (Throwable)new MasonException(MasonError.INPUT_VALIDATION_ERROR, "Input value must be " + minLength + " character long for " + this.name + " parameter"));
                }
                case 5: {
                    if (this.pattern != null) break;
                    try {
                        this.validateDateTime(this.value, "HH:mm:ss");
                        break;
                    }
                    catch (ParseException ex) {
                        throw new JspException("", (Throwable)new MasonException(MasonError.INPUT_VALIDATION_ERROR, "Incorrect time pattern of " + this.name + " parameter"));
                    }
                }
                case 6: {
                    urlPattern = "(?:(?:https?|ftp)://)(?:\\S+(?::\\S*)?@)?(?:(?!10(?:\\.\\d{1,3}){3})(?!127(?:\\.\\d{1,3}){3})(?!169\\.254(?:\\.\\d{1,3}){2})(?!192\\.168(?:\\.\\d{1,3}){2})(?!172\\.(?:1[6-9]|2\\d|3[0-1])(?:\\.\\d{1,3}){2})(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}(?:\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))|(?:(?:[a-z\\x{00a1}-\\x{ffff}0-9]+-?)*[a-z\\x{00a1}-\\x{ffff}0-9]+)(?:\\.(?:[a-z\\x{00a1}-\\x{ffff}0-9]+-?)*[a-z\\x{00a1}-\\x{ffff}0-9]+)*(?:\\.(?:[a-z\\x{00a1}-\\x{ffff}]{2,})))(?::\\d{2,5})?(?:/[^\\s]*)?";
                    regexPattern = Pattern.compile(urlPattern);
                    matcher = regexPattern.matcher(this.value);
                    if (matcher.matches()) break;
                    throw new JspException("", (Throwable)new MasonException(MasonError.INPUT_VALIDATION_ERROR, "Invalid URL input"));
                }
            }
        }
        this.release();
        return 6;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setIsRequired(boolean required) {
        this.isRequired = required;
    }

    public void setMax(String max) {
        this.max = Double.parseDouble(max);
    }

    public void setMin(String min) {
        this.min = Double.parseDouble(min);
    }

    public void setMaxLen(String maxLen) {
        this.maxLen = Integer.parseInt(maxLen);
    }

    public void setMinLen(String minLen) {
        this.minLen = Integer.parseInt(minLen);
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setValue(String value) {
        this.value = value.isEmpty() ? null : value;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue.isEmpty() ? null : defaultValue;
    }

    private void validateDateTime(String value, String format) throws ParseException, JspException {
        block2: {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                sdf.setLenient(false);
                sdf.parse(value);
            }
            catch (NullPointerException ex) {
                if (this.isRequired == null) break block2;
                throw new JspException("", (Throwable)new MasonException(MasonError.INPUT_VALIDATION_ERROR, this.name + " parameter can't be null"));
            }
        }
    }
}

