/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.tag;

import com.metamug.mason.exception.MasonException;
import com.metamug.mason.service.ConnectionProvider;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import javax.sql.DataSource;

public class ExceptionTagHandler
extends BodyTagSupport
implements TryCatchFinally {
    private Object value;
    private DataSource ds;

    public int doEndTag() throws JspException {
        Exception exception = (Exception)this.value;
        this.ds = ConnectionProvider.getMasonDatasource();
        JspWriter out = this.pageContext.getOut();
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String header = request.getHeader("Accept") == null ? "application/json" : request.getHeader("Accept");
        try {
            if (Arrays.asList(header.split("/")).contains("xml")) {
                response.setContentType("application/xml");
                out.println("<response>\n");
                if (exception.getCause() != null) {
                    String cause = exception.getCause().toString();
                    if (cause.contains("MySQLSyntaxErrorException") || cause.contains("MySQLIntegrityConstraintViolationException") || cause.contains("MysqlDataTruncation") || cause.contains("SQLException") || cause.contains("PSQLException")) {
                        response.setStatus(512);
                        String timestamp = String.valueOf(System.currentTimeMillis());
                        long hash = UUID.nameUUIDFromBytes(timestamp.getBytes()).getMostSignificantBits();
                        String errorId = String.valueOf(Math.abs(hash));
                        this.logError(errorId, request, exception);
                        out.println("<errorid>" + errorId + "</errorid>\n<status>" + 512 + "</status>\n<message>API Error. Please contact your API administrator.</message>");
                    } else if (cause.contains("NumberFormatException") || cause.contains("ParseException")) {
                        response.setStatus(422);
                        out.println("<message>Unable to parse input</message>\n<status>422</status>");
                        Logger.getLogger(ExceptionTagHandler.class.getName()).log(Level.SEVERE, exception.getMessage(), exception);
                    } else if (cause.contains(MasonException.class.getName())) {
                        MasonException mtgCause = (MasonException)exception.getCause();
                        String timestamp = String.valueOf(System.currentTimeMillis());
                        long hash = UUID.nameUUIDFromBytes(timestamp.getBytes()).getMostSignificantBits();
                        String errorId = String.valueOf(Math.abs(hash));
                        switch (mtgCause.getError()) {
                            case BEARER_TOKEN_MISMATCH: {
                                response.setStatus(401);
                                out.println("<message>" + mtgCause.getMessage() + "</message>\n<status>" + 401 + "</status>");
                                break;
                            }
                            case INCORRECT_ROLE_AUTHENTICATION: {
                                response.setStatus(401);
                                response.setHeader("WWW-Authenticate", "Basic");
                                out.println("<message>" + mtgCause.getMessage() + "</message>\n<status>" + 401 + "</status>");
                                break;
                            }
                            case INCORRECT_STATUS_CODE: {
                                response.setStatus(406);
                                out.println("<message>" + mtgCause.getMessage() + "</message>\n<status>" + 406 + "</status>");
                                break;
                            }
                            case INPUT_VALIDATION_ERROR: {
                                response.setStatus(412);
                                out.println("<message>" + mtgCause.getMessage() + "</message>\n<status>" + 412 + "</status>");
                                break;
                            }
                            case NO_UPLOAD_LISTENER: {
                                response.setStatus(424);
                                out.println("<message>" + mtgCause.getMessage() + "</message>\n<status>" + 424 + "</status>");
                                break;
                            }
                            case PARENT_RESOURCE_MISSING: {
                                response.setStatus(404);
                                out.println("<message>" + mtgCause.getMessage() + "</message>\n<status>" + 424 + "</status>");
                                break;
                            }
                            case ROLE_ACCESS_DENIED: {
                                response.setStatus(403);
                                out.println("<message>" + mtgCause.getMessage() + "</message>\n<status>" + 403 + "</status>");
                                break;
                            }
                            case SQL_ERROR: {
                                response.setStatus(512);
                                this.logError(errorId, request, exception);
                                out.println("<errorid>" + errorId + "</errorid>\n<status>" + 512 + "</status>\n<error>" + mtgCause.getMessage() + "</error>\n<message>API Error. Please contact your API administrator.</message>");
                                break;
                            }
                            case UPLOAD_CODE_ERROR: {
                                response.setStatus(512);
                                this.logUploadCodeError(errorId, request, mtgCause.getRootException());
                                out.println("<errorid>" + errorId + "</errorid>\n<status>" + 512 + "</status>\n<error>" + mtgCause.getMessage() + "</error>\n<message>API Error. Please contact your API administrator.</message>");
                                break;
                            }
                            case UPLOAD_SIZE_EXCEEDED: {
                                response.setStatus(413);
                                out.println("<message>" + mtgCause.getMessage() + "</message>\n<status>" + 413 + "</status>");
                            }
                        }
                    } else {
                        response.setStatus(512);
                        String timestamp = String.valueOf(System.currentTimeMillis());
                        long hash = UUID.nameUUIDFromBytes(timestamp.getBytes()).getMostSignificantBits();
                        String errorId = String.valueOf(Math.abs(hash));
                        this.logError(errorId, request, exception);
                        out.println("<errorid>" + errorId + "</errorid>\n<status>" + 512 + "</status>\n<message>API Error. Please contact your API administrator.</message>");
                    }
                } else {
                    response.setStatus(512);
                    String timestamp = String.valueOf(System.currentTimeMillis());
                    long hash = UUID.nameUUIDFromBytes(timestamp.getBytes()).getMostSignificantBits();
                    String errorId = String.valueOf(Math.abs(hash));
                    this.logError(errorId, request, exception);
                    out.println("<errorid>" + errorId + "</errorid>\n<status>" + 512 + "</status>\n<message>API Error. Please contact your API administrator.</message>");
                }
                out.println("\n</response>");
            } else {
                response.setContentType("application/json");
                if (exception.getCause() != null) {
                    String cause = exception.getCause().toString();
                    if (cause.contains("MySQLSyntaxErrorException") || cause.contains("MySQLIntegrityConstraintViolationException") || cause.contains("MysqlDataTruncation") || cause.contains("SQLException")) {
                        response.setStatus(512);
                        String timestamp = String.valueOf(System.currentTimeMillis());
                        long hash = UUID.nameUUIDFromBytes(timestamp.getBytes()).getMostSignificantBits();
                        String errorId = String.valueOf(Math.abs(hash));
                        this.logError(errorId, request, exception);
                        out.println("{\"errorId\":" + errorId + ",\"status\":" + 512 + ",\"message\": \"API Error. Please contact your API administrator.\"}");
                    } else if (cause.contains("NumberFormatException") || cause.contains("ParseException")) {
                        response.setStatus(422);
                        out.println("{\"message\": \"Unable to parse input\",\"status\":422}");
                        Logger.getLogger(ExceptionTagHandler.class.getName()).log(Level.SEVERE, exception.getMessage(), exception);
                    } else if (cause.contains(MasonException.class.getName())) {
                        MasonException mtgCause = (MasonException)exception.getCause();
                        String timestamp = String.valueOf(System.currentTimeMillis());
                        long hash = UUID.nameUUIDFromBytes(timestamp.getBytes()).getMostSignificantBits();
                        String errorId = String.valueOf(Math.abs(hash));
                        switch (mtgCause.getError()) {
                            case BEARER_TOKEN_MISMATCH: {
                                response.setStatus(401);
                                out.println("{\"message\": \"" + mtgCause.getMessage() + "\",\"status\":" + 401 + "}");
                                break;
                            }
                            case CLASS_NOT_IMPLEMENTED: {
                                response.setStatus(422);
                                this.logCodeError(errorId, request, mtgCause);
                                out.println("{\"errorId\":" + errorId + ",\"error\":\"" + mtgCause.getMessage() + "\",\"message\": \"API Error. Please contact your API administrator.\",\"status\":" + 422 + "}");
                                break;
                            }
                            case CODE_ERROR: {
                                response.setStatus(512);
                                this.logCodeError(errorId, request, mtgCause.getRootException());
                                out.println("{\"errorId\":" + errorId + ",\"error\":\"" + mtgCause.getMessage() + "\",\"message\": \"API Error. Please contact your API administrator.\",\"status\":" + 512 + "}");
                                break;
                            }
                            case EMPTY_PERSIST_ERROR: {
                                response.setStatus(409);
                                out.println("{\"message\": \"" + mtgCause.getMessage() + "\",\"status\":" + 409 + "}");
                                break;
                            }
                            case INCORRECT_ROLE_AUTHENTICATION: {
                                response.setStatus(401);
                                response.setHeader("WWW-Authenticate", "Basic");
                                out.println("{\"message\": \"" + mtgCause.getMessage() + "\",\"status\":" + 401 + "}");
                                break;
                            }
                            case INCORRECT_STATUS_CODE: {
                                response.setStatus(406);
                                out.println("{\"message\": \"" + mtgCause.getMessage() + "\",\"status\":" + 406 + "}");
                                break;
                            }
                            case INPUT_VALIDATION_ERROR: {
                                response.setStatus(412);
                                out.println("{\"message\": \"" + mtgCause.getMessage() + "\",\"status\":" + 412 + "}");
                                break;
                            }
                            case NO_UPLOAD_LISTENER: {
                                response.setStatus(424);
                                out.println("{\"message\": \"" + mtgCause.getMessage() + "\",\"status\":" + 424 + "}");
                                break;
                            }
                            case PARENT_RESOURCE_MISSING: {
                                response.setStatus(404);
                                out.println("{\"message\": \"" + mtgCause.getMessage() + "\",\"status\":" + 404 + "}");
                                break;
                            }
                            case ROLE_ACCESS_DENIED: {
                                response.setStatus(403);
                                out.println("{\"message\": \"" + mtgCause.getMessage() + "\",\"status\":" + 403 + "}");
                                break;
                            }
                            case SQL_ERROR: {
                                response.setStatus(512);
                                this.logError(errorId, request, mtgCause);
                                out.println("{\"errorId\":" + errorId + ",\"error\":\"" + mtgCause.getMessage() + "\",\"message\": \"API Error. Please contact your API administrator.\",\"status\":" + 512 + "}");
                                break;
                            }
                            case UPLOAD_CODE_ERROR: {
                                response.setStatus(512);
                                this.logUploadCodeError(errorId, request, mtgCause.getRootException());
                                out.println("{\"errorId\":" + errorId + ",\"error\":\"" + mtgCause.getMessage() + "\",\"message\": \"API Error. Please contact your API administrator.\",\"status\":" + 512 + "}");
                                break;
                            }
                            case UPLOAD_SIZE_EXCEEDED: {
                                response.setStatus(413);
                                out.println("{\"message\": \"" + mtgCause.getMessage() + "\",\"status\":" + 413 + "}");
                            }
                        }
                    } else {
                        response.setStatus(512);
                        String timestamp = String.valueOf(System.currentTimeMillis());
                        long hash = UUID.nameUUIDFromBytes(timestamp.getBytes()).getMostSignificantBits();
                        String errorId = String.valueOf(Math.abs(hash));
                        this.logError(errorId, request, exception);
                        out.println("{\"errorId\":" + errorId + ",\"status\":" + 512 + ",\"message\": \"API Error. Please contact your API administrator.\"}");
                    }
                } else {
                    response.setStatus(512);
                    String timestamp = String.valueOf(System.currentTimeMillis());
                    long hash = UUID.nameUUIDFromBytes(timestamp.getBytes()).getMostSignificantBits();
                    String errorId = String.valueOf(Math.abs(hash));
                    this.logError(errorId, request, exception);
                    out.println("{\"errorId\":" + errorId + ",\"status\":" + 512 + ",\"message\": \"API Error. Please contact your API administrator.\"}");
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ExceptionTagHandler.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        return 5;
    }

    private void logError(String errorId, HttpServletRequest request, Exception exception) {
        String exceptionMessage = exception.getMessage() != null ? exception.getMessage().replaceAll("(\\w+)_db\\.", "").replaceAll("(\\s|\\n|\\r|\\n\\r)+", " ") : exception.toString();
        this.dbLogErorr(errorId, request, exceptionMessage, new StringBuilder());
        Logger.getLogger(ExceptionTagHandler.class.getName()).log(Level.SEVERE, exception.getMessage(), exception);
    }

    private void logCodeError(String errorId, HttpServletRequest request, Exception exception) {
        StackTraceElement[] stackTrace;
        String exceptionMessage = exception.getMessage() != null ? exception.getMessage().replaceAll("(\\s|\\n|\\r|\\n\\r)+", " ") : exception.toString();
        StringBuilder errorTraceBuilder = new StringBuilder();
        for (StackTraceElement stackTraceElement : stackTrace = exception.getStackTrace()) {
            errorTraceBuilder.append(stackTraceElement);
            if (stackTraceElement.getClassName().contains("CodeTagHandler")) break;
            errorTraceBuilder.append("\n");
        }
        this.dbLogErorr(errorId, request, exceptionMessage, errorTraceBuilder);
        Logger.getLogger(ExceptionTagHandler.class.getName()).log(Level.SEVERE, exception.getMessage(), exception);
    }

    private void logUploadCodeError(String errorId, HttpServletRequest request, Exception exception) {
        StackTraceElement[] stackTrace;
        StringBuilder errorTraceBuilder = new StringBuilder();
        for (StackTraceElement stackTraceElement : stackTrace = exception.getStackTrace()) {
            if (stackTraceElement.getClassName().contains("UploadEventTagHandler")) {
                errorTraceBuilder.append(stackTraceElement);
                break;
            }
            errorTraceBuilder.append(stackTraceElement).append("\n");
        }
        String exceptionMessage = exception.getMessage() != null ? exception.getMessage().replaceAll("(\\w+)_db\\.", "").replaceAll("(\\s|\\n|\\r|\\n\\r)+", " ") : exception.toString();
        this.dbLogErorr(errorId, request, exceptionMessage, errorTraceBuilder);
        Logger.getLogger(ExceptionTagHandler.class.getName()).log(Level.SEVERE, exception.getMessage(), exception);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void doCatch(Throwable throwable) throws Throwable {
        throw throwable;
    }

    public void doFinally() {
    }

    private void dbLogErorr(String errorId, HttpServletRequest request, String exceptionMessage, StringBuilder errorTraceBuilder) {
        String method = (String)request.getAttribute("mtgMethod");
        String resourceURI = (String)request.getAttribute("javax.servlet.forward.request_uri");
        try (Connection con = this.ds.getConnection();
             PreparedStatement stmnt = con.prepareStatement("INSERT INTO error_log (error_id,request_method,message,trace, resource) VALUES(?,?,?,?,?)");){
            stmnt.setString(1, String.valueOf(errorId));
            stmnt.setString(2, method);
            stmnt.setString(3, exceptionMessage);
            stmnt.setString(4, errorTraceBuilder.toString());
            stmnt.setString(5, resourceURI);
            stmnt.execute();
        }
        catch (SQLException ex) {
            Logger.getLogger(ExceptionTagHandler.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

