/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.service;

import com.mysql.cj.jdbc.AbandonedConnectionCleanupThread;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class ConnectionProvider {
    private static String masonDatasource;
    private final DataSource ds;

    public static DataSource getMasonDatasource() {
        try {
            InitialContext initialContext = new InitialContext();
            Context envContext = (Context)initialContext.lookup("java:/comp/env");
            return (DataSource)envContext.lookup(masonDatasource);
        }
        catch (NamingException ex) {
            Logger.getLogger(ConnectionProvider.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public ConnectionProvider(String masonDatasource) throws SQLException, NamingException {
        ConnectionProvider.masonDatasource = masonDatasource;
        this.ds = ConnectionProvider.getMasonDatasource();
    }

    public Connection getConnection() {
        try {
            return this.ds.getConnection();
        }
        catch (SQLException ex) {
            Logger.getLogger(ConnectionProvider.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void shutdown() throws SQLException, NamingException {
        String driver = "";
        if (!driver.contains("hsql") && driver.contains("mysql")) {
            AbandonedConnectionCleanupThread.checkedShutdown();
        }
    }
}

