/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.service;

import com.metamug.mason.dao.AuthDAO;
import com.metamug.mason.entity.auth.JWebToken;
import com.metamug.mason.exception.MasonError;
import com.metamug.mason.exception.MasonException;
import com.metamug.mason.service.ConnectionProvider;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.servlet.jsp.JspException;
import org.json.JSONObject;

public class AuthService {
    private AuthDAO dao;

    public AuthService(ConnectionProvider instance) {
        this.dao = new AuthDAO(instance);
    }

    public AuthService(AuthDAO dao) {
        this.dao = dao;
    }

    public String validateBasic(String header, String roleName, String authQuery) throws JspException {
        String authHeader = header.replaceFirst("Basic ", "");
        String userCred = new String(Base64.getDecoder().decode(authHeader.getBytes()));
        String[] split = userCred.split(":");
        String user = split[0];
        String password = split[1];
        if (split.length < 2 || user.isEmpty() || password.isEmpty()) {
            throw new JspException("Access Denied due to unauthorization", (Throwable)new MasonException(MasonError.ROLE_ACCESS_DENIED));
        }
        JSONObject status = this.dao.validateBasic(user, password, roleName, authQuery);
        switch (status.getInt("status")) {
            case 0: {
                throw new JspException("Access Denied due to unauthorization", (Throwable)new MasonException(MasonError.INCORRECT_ROLE_AUTHENTICATION));
            }
            case 1: {
                return status.getString("user_id");
            }
        }
        throw new JspException("Access Denied due to unauthorization!", (Throwable)new MasonException(MasonError.ROLE_ACCESS_DENIED));
    }

    public String validateBearer(String bearerToken, String roleName) throws JspException {
        try {
            JWebToken incomingToken = new JWebToken(bearerToken);
            if (!incomingToken.isValid()) {
                throw new JspException("Access Denied due to unauthorization", (Throwable)new MasonException(MasonError.BEARER_TOKEN_MISMATCH));
            }
            if (incomingToken.getAudience().contains("'" + roleName + "'")) {
                throw new JspException("Access Denied due to unauthorization!", (Throwable)new MasonException(MasonError.BEARER_TOKEN_MISMATCH));
            }
            return incomingToken.getSubject();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new JspException("Access Denied due to unauthorization", (Throwable)new MasonException(MasonError.BEARER_TOKEN_MISMATCH));
        }
    }

    public String createBearer(String user, String pass, String authQuery) {
        JSONObject payload = this.dao.getBearerDetails(user, pass, authQuery);
        return new JWebToken(payload).toString();
    }
}

