/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.io.mpath;

import com.github.wnameless.json.flattener.JsonFlattener;
import com.github.wnameless.json.unflattener.JsonUnflattener;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.xml.sax.SAXException;

public class MPathUtil {
    public static Object getValueFromJson(String inputJson, String mPath) {
        Map flatMap = JsonFlattener.flattenAsMap((String)inputJson);
        return flatMap.get(mPath);
    }

    public static Object getValueFromXml(String xmlInput, String mPath) throws IOException, SAXException, XPathExpressionException, ParserConfigurationException {
        JSONObject jobj = XML.toJSONObject((String)xmlInput);
        String jobjStr = jobj.toString();
        Map flatMap = JsonFlattener.flattenAsMap((String)jobjStr);
        Object value = flatMap.get(mPath);
        if (null == value) {
            value = flatMap.get(mPath + ".content");
        }
        return value;
    }

    public static JSONObject getJsonFromMPath(String mPath, String value) {
        String flatJson = "{\"" + mPath + "\":\"" + value + "\"}";
        String unFlatJson = new JsonUnflattener(flatJson).unflatten();
        return new JSONObject(unFlatJson);
    }

    public static JSONObject appendJsonFromMPath(JSONObject initialJsonObject, String mPath, Object value) {
        String flatString = JsonFlattener.flatten((String)initialJsonObject.toString());
        JSONObject flatJson = new JSONObject(flatString);
        try {
            JSONArray jsonArray = new JSONArray(String.valueOf(value));
            flatJson.accumulate(mPath, (Object)jsonArray);
        }
        catch (JSONException ex) {
            try {
                JSONObject jsonObject = new JSONObject(String.valueOf(value));
                flatJson.accumulate(mPath, (Object)jsonObject);
            }
            catch (JSONException ex1) {
                flatJson.accumulate(mPath, value);
            }
        }
        String unFlatJson = new JsonUnflattener(flatJson.toString()).unflatten();
        return new JSONObject(unFlatJson);
    }

    public static JSONObject collect(JSONArray inputArray) {
        int len = inputArray.length();
        if (len > 0) {
            JSONObject firstObj = inputArray.getJSONObject(0);
            if (len == 1) {
                return firstObj;
            }
            for (int i = 1; i < len; ++i) {
                JSONObject object = inputArray.getJSONObject(i);
                object.keySet().forEach(key -> {
                    Object firstObjectValue = firstObj.get(key);
                    if (firstObjectValue instanceof JSONArray) {
                        JSONArray array = (JSONArray)firstObjectValue;
                        array.put(object.get(key));
                        firstObj.put(key, (Object)array);
                    } else {
                        Object currentObjectValue = object.get(key);
                        if (!firstObjectValue.equals(currentObjectValue)) {
                            JSONArray array = new JSONArray();
                            array.put(firstObjectValue);
                            array.put(currentObjectValue);
                            firstObj.put(key, (Object)array);
                        }
                    }
                });
            }
            return firstObj;
        }
        return null;
    }
}

