/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.entity.response;

import com.metamug.entity.Response;
import com.metamug.mason.entity.response.JSONOutput;
import com.metamug.mason.entity.response.MasonOutput;
import com.metamug.mason.entity.response.ResponeBuilder;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.json.JSONObject;
import org.json.XML;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLOutput
extends MasonOutput<Document> {
    private Document getXml(JSONObject jsonObject) {
        StringBuilder xmlBuilder = new StringBuilder();
        xmlBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        xmlBuilder.append("<response>");
        xmlBuilder.append(XML.toString((Object)jsonObject));
        xmlBuilder.append("</response>");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            doc = builder.parse(new InputSource(new StringReader(xmlBuilder.toString())));
            return doc;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Logger.getLogger(XMLOutput.class.getName()).log(Level.SEVERE, e.getMessage(), e);
            return doc;
        }
    }

    @Override
    protected Document getContent() {
        Response response = new ResponeBuilder(JSONOutput.class).build(this.outputMap);
        return this.getXml((JSONObject)response.getPayload());
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }

    public String getStringFromDocument(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException e) {
            Logger.getLogger(XMLOutput.class.getName()).log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    @Override
    public String format(Response response) {
        return this.getStringFromDocument((Document)response.getPayload());
    }

    @Override
    protected Map<String, String> getExtraHeaders() {
        return new HashMap<String, String>();
    }
}

