/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.entity.response;

import com.metamug.entity.Response;
import com.metamug.mason.entity.response.MasonOutput;
import com.metamug.mason.io.mpath.MPathUtil;
import com.metamug.mason.io.objectreturn.ObjectReturn;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import org.apache.taglibs.standard.tag.common.sql.ResultImpl;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONOutput
extends MasonOutput<JSONObject> {
    @Override
    protected JSONObject getContent() {
        JSONObject responseJson = new JSONObject();
        this.outputMap.entrySet().forEach(entry -> {
            Object obj = entry.getValue();
            String key = (String)entry.getKey();
            if (obj == null) {
                responseJson.put(key, (Object)new JSONObject());
            } else if (obj instanceof ResultImpl) {
                responseJson.put(key, this.getJson((ResultImpl)obj));
            } else if (obj instanceof JSONObject) {
                responseJson.put(key, obj);
            } else if (obj instanceof JSONArray) {
                responseJson.put(key, obj);
            } else if (obj instanceof String) {
                responseJson.put(key, obj);
            } else if (obj instanceof List) {
                JSONArray array = new JSONArray();
                List list = (List)obj;
                for (Object o : list) {
                    if (o == null) {
                        array.put((Object)new JSONObject());
                        continue;
                    }
                    if (o instanceof String || o instanceof JSONObject || o instanceof JSONArray) {
                        array.put(o);
                        continue;
                    }
                    if (o instanceof ResultImpl) {
                        array.put(this.getJson((ResultImpl)o));
                        continue;
                    }
                    try {
                        array.put((Object)new JSONObject(ObjectReturn.convert(o, "application/json")));
                    }
                    catch (JAXBException ex) {
                        Logger.getLogger(JSONOutput.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                responseJson.put(key, (Object)array);
            } else {
                try {
                    responseJson.put(key, (Object)new JSONObject(ObjectReturn.convert(obj, "application/json")));
                }
                catch (MarshalException mex) {
                    responseJson.put(key, obj);
                }
                catch (JAXBException ex) {
                    Logger.getLogger(JSONOutput.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        return responseJson;
    }

    @Override
    public String format(Response response) {
        JSONObject responseJson = (JSONObject)response.getPayload();
        return responseJson.toString();
    }

    protected Object getJson(ResultImpl impl) {
        return this.resultSetToJson(impl);
    }

    private JSONArray resultSetToJson(ResultImpl resultImpl) {
        SortedMap[] rows = resultImpl.getRows();
        String[] columnNames = resultImpl.getColumnNames();
        JSONArray array = new JSONArray();
        for (SortedMap row : rows) {
            JSONObject rowJson = new JSONObject();
            for (int i = 0; i < columnNames.length; ++i) {
                String columnName = columnNames[i].isEmpty() || columnNames[i].equalsIgnoreCase("null") ? "col" + i : columnNames[i];
                rowJson = MPathUtil.appendJsonFromMPath(rowJson, columnName, row.get(columnName) != null ? row.get(columnName) : JSONObject.NULL);
            }
            if (rowJson.length() <= 0) continue;
            array.put((Object)rowJson);
        }
        return array;
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    protected Map<String, String> getExtraHeaders() {
        return new HashMap<String, String>();
    }
}

