/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.entity.request;

import com.metamug.entity.Request;
import com.metamug.entity.Resource;
import com.metamug.mason.entity.request.FormStrategy;
import com.metamug.mason.entity.request.HtmlStrategy;
import com.metamug.mason.entity.request.ImmutableRequest;
import com.metamug.mason.entity.request.JsonStrategy;
import com.metamug.mason.entity.request.MultipartFormStrategy;
import com.metamug.mason.entity.request.ParamExtractStrategy;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class RequestAdapter {
    private static final int VERSION_LENGTH = 4;

    public static Request create(HttpServletRequest request) throws IOException, ServletException {
        String contentType;
        String path = request.getServletPath();
        CharSequence[] tokens = path.split("/");
        int versionTokenIndex = -1;
        for (int i = 0; i < tokens.length; ++i) {
            if (!tokens[i].matches("^.*(v\\d+\\.\\d+).*$")) continue;
            versionTokenIndex = i;
            break;
        }
        float version = Float.parseFloat(tokens[versionTokenIndex].substring(1));
        String resourceName = tokens.length == versionTokenIndex + 4 || tokens.length == versionTokenIndex + 5 ? tokens[versionTokenIndex + 3] : tokens[versionTokenIndex + 1];
        String method = request.getMethod().toLowerCase();
        String string = contentType = request.getHeader("Content-Type") == null ? "application/x-www-form-urlencoded" : request.getHeader("Content-Type");
        ParamExtractStrategy strategy = contentType.contains("application/json") ? new JsonStrategy(request) : (contentType.contains("multipart/form-data") ? new MultipartFormStrategy(request) : (contentType.contains("application/html") ? new HtmlStrategy(request) : new FormStrategy(request)));
        Request masonRequest = strategy.getRequest();
        if (tokens.length == versionTokenIndex + 4 || tokens.length == versionTokenIndex + 4 + 1) {
            masonRequest.setPid(tokens[versionTokenIndex + 2]);
            masonRequest.setId(tokens.length > versionTokenIndex + 4 ? tokens[versionTokenIndex + 4] : null);
        } else {
            Resource resource = new Resource(resourceName, version, String.join((CharSequence)"/", tokens), null);
            masonRequest.setResource(resource);
            masonRequest.setId(tokens.length > versionTokenIndex + 2 ? tokens[versionTokenIndex + 2] : null);
        }
        masonRequest.setMethod(method);
        masonRequest.setUri((String)tokens[versionTokenIndex + 1]);
        return new ImmutableRequest(masonRequest);
    }
}

