/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.entity.request;

import com.github.wnameless.json.flattener.JsonFlattener;
import com.metamug.mason.entity.request.ParamExtractStrategy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class JsonStrategy
extends ParamExtractStrategy {
    public static final String APPLICATION_JSON = "application/json";

    public JsonStrategy(HttpServletRequest request) {
        super(request);
        StringBuilder jsonData = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));){
            String line;
            while ((line = br.readLine()) != null) {
                jsonData.append(line);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(JsonStrategy.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        Map flattenAsMap = JsonFlattener.flattenAsMap((String)jsonData.toString());
        flattenAsMap.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            String value = String.valueOf(entry.getValue());
            JsonStrategy.addKeyPair(this.masonRequest, new String[]{key, value}, this.params);
        });
        this.params.put("mtgRawJson", jsonData.toString());
    }
}

