/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.entity;

import com.metamug.mason.service.AuthService;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;

public class RootResource {
    HttpServletRequest request;
    HttpServletResponse response;

    public RootResource(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    private void writeError(int status, String message) throws IOException {
        try (PrintWriter writer = this.response.getWriter();){
            this.response.setContentType("application/json;charset=UTF-8");
            this.response.setCharacterEncoding("UTF-8");
            this.response.setStatus(status);
            JSONObject obj = new JSONObject();
            obj.put("status", status);
            obj.put("message", (Object)message);
            writer.print(obj.toString());
            writer.flush();
        }
    }

    public void processAuth(AuthService service) {
        String contentType = this.request.getHeader("Accept");
        if ("bearer".equals(this.request.getParameter("auth"))) {
            String user = this.request.getParameter("userid");
            String pass = this.request.getParameter("password");
            String authQuery = (String)this.request.getServletContext().getAttribute("MTG_AUTH_BEARER");
            String token = service.createBearer(user, pass, authQuery.trim());
            try (PrintWriter out = this.response.getWriter();){
                if (contentType.contains("application/xml")) {
                    out.print("<token>" + token + "</token>");
                } else {
                    out.print("{\"token\":\"" + token + "\"}");
                }
            }
            catch (IOException e) {
                try {
                    this.writeError(512, "Unable to generate token");
                }
                catch (IOException ex) {
                    Logger.getLogger(RootResource.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
    }
}

