/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason.dao;

import com.metamug.mason.service.ConnectionProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class AuthDAO {
    ConnectionProvider provider;
    private static final int EXPIRY_DAYS = 90;

    public AuthDAO(ConnectionProvider provider) {
        this.provider = provider;
    }

    public JSONObject validateBasic(String userName, String password, String roleName, String authQuery) {
        JSONObject status;
        block40: {
            status = new JSONObject();
            status.put("status", 0);
            try (Connection con = this.provider.getConnection();){
                if (!authQuery.isEmpty()) {
                    try (PreparedStatement basicStmnt = con.prepareStatement(authQuery.replaceAll("\\$(\\w+(\\.\\w+){0,})", "? "));){
                        basicStmnt.setString(1, userName);
                        basicStmnt.setString(2, password);
                        try (ResultSet basicResult = basicStmnt.executeQuery();){
                            while (basicResult.next()) {
                                status.put("user_id", (Object)basicResult.getString(1));
                                status.put("role", (Object)basicResult.getString(2));
                                if (!basicResult.getString(2).equalsIgnoreCase(roleName)) continue;
                                status.put("status", 1);
                                break block40;
                            }
                            break block40;
                        }
                    }
                }
                status.put("status", -1);
            }
            catch (SQLException ex) {
                Logger.getLogger(AuthDAO.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        return status;
    }

    public JSONObject getBearerDetails(String user, String pass, String authQuery) {
        JSONObject jwtPayload;
        block39: {
            jwtPayload = new JSONObject();
            jwtPayload.put("status", 0);
            try (Connection con = this.provider.getConnection();){
                if (authQuery.isEmpty()) break block39;
                try (PreparedStatement stmt = con.prepareStatement(authQuery.replaceAll("\\$(\\w+(\\.\\w+){0,})", "? "));){
                    stmt.setString(1, user);
                    stmt.setString(2, pass);
                    try (ResultSet result = stmt.executeQuery();){
                        JSONArray audArray = new JSONArray();
                        while (result.next()) {
                            jwtPayload.put("sub", (Object)result.getString(1));
                            audArray.put((Object)result.getString(2));
                        }
                        jwtPayload.put("aud", (Object)audArray);
                        LocalDateTime ldt = LocalDateTime.now().plusDays(90L);
                        jwtPayload.put("exp", ldt.toEpochSecond(ZoneOffset.UTC));
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(AuthDAO.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        return jwtPayload;
    }
}

