/*
 * Decompiled with CFR 0.152.
 */
package com.metamug.mason;

import com.eclipsesource.json.ParseException;
import com.metamug.entity.Request;
import com.metamug.mason.entity.RootResource;
import com.metamug.mason.entity.request.RequestAdapter;
import com.metamug.mason.service.AuthService;
import com.metamug.mason.service.ConnectionProvider;
import com.metamug.mason.service.QueryManagerService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;

@MultipartConfig(fileSizeThreshold=0x100000, maxFileSize=0x500000L, maxRequestSize=0x1900000L)
public class Router
implements Filter {
    private static final String JSP_EXTN = ".jsp";
    private static final String RESOURCES_FOLDER = "/WEB-INF/resources/";
    private String encoding;
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String QUERY_FILE_NAME = "query.properties";
    public static final String MASON_QUERY = "masonQuery";
    public static final String DATA_SOURCE = "datasource";
    public static final String MTG_AUTH_BASIC = "MTG_AUTH_BASIC";
    public static final String MTG_AUTH_BEARER = "MTG_AUTH_BEARER";
    private ConnectionProvider connectionProvider;
    public static final String CONNECTION_PROVIDER = "connectionProvider";
    public static final String MASON_REQUEST = "mtgReq";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (null == request.getCharacterEncoding()) {
            request.setCharacterEncoding(this.encoding);
        }
        String path = req.getServletPath();
        String[] tokens = path.split("/");
        int versionTokenIndex = -1;
        for (int i = 0; i < tokens.length; ++i) {
            if (!tokens[i].matches("^.*(v\\d+\\.\\d+).*$")) continue;
            versionTokenIndex = i;
            break;
        }
        if (versionTokenIndex == -1 && req.getMethod().equalsIgnoreCase("post") && !path.contains("query")) {
            RootResource rootResource = new RootResource(req, res);
            rootResource.processAuth(new AuthService(this.connectionProvider));
            return;
        }
        if (tokens.length <= 2 || path.contains("index") || path.contains("docs")) {
            chain.doFilter(request, response);
            return;
        }
        this.processRequest(req, res);
    }

    private void processRequest(HttpServletRequest req, HttpServletResponse res) throws IOException {
        boolean validContentType;
        String contentType = req.getContentType() == null ? "application/html" : req.getContentType().toLowerCase();
        String method = req.getMethod().toLowerCase();
        boolean bl = validContentType = contentType.contains("application/html") || contentType.contains("application/xml") || contentType.contains("application/x-www-form-urlencoded") || contentType.contains("application/json") || contentType.contains("multipart/form-data");
        if (!("get".equals(method) || "delete".equals(method) || validContentType)) {
            this.writeError(res, 415, "Unsupported Media Type");
            return;
        }
        res.setContentType("application/json");
        String resourceName = "";
        try {
            Request mtgReq = RequestAdapter.create(req);
            resourceName = mtgReq.getResource().getName();
            String jspPath = "/WEB-INF/resources/v" + mtgReq.getResource().getVersion() + "/" + resourceName + JSP_EXTN;
            File file = new File(req.getServletContext().getRealPath(jspPath));
            if (file.exists()) {
                req.setAttribute(MASON_REQUEST, (Object)mtgReq);
                req.setAttribute(DATA_SOURCE, req.getServletContext().getAttribute(DATA_SOURCE));
                req.setAttribute(CONNECTION_PROVIDER, (Object)this.connectionProvider);
                Object queryMap = req.getServletContext().getAttribute(MASON_QUERY);
                req.setAttribute(MASON_QUERY, queryMap);
                req.setAttribute("mtgMethod", (Object)req.getMethod());
                req.getRequestDispatcher(jspPath).forward((ServletRequest)new HttpServletRequestWrapper(req){

                    public String getMethod() {
                        String method = super.getMethod();
                        if (method.equalsIgnoreCase("delete") || method.equalsIgnoreCase("put")) {
                            return "POST";
                        }
                        return method;
                    }
                }, (ServletResponse)res);
            } else {
                this.writeError(res, 404, "Resource not found");
            }
        }
        catch (ParseException | IOException | ServletException | JSONException ex) {
            if (ex.getClass().toString().contains("com.eclipsesource.json.ParseException")) {
                this.writeError(res, 422, "Could not parse the body of the request according to the provided Content-Type.");
            } else if (ex.getCause() != null) {
                String cause = ex.getCause().toString().split(": ")[1].replaceAll("(\\s|\\n|\\r|\\n\\r)+", " ");
                this.writeError(res, 500, cause);
            } else if (ex.getMessage().contains("ELException")) {
                this.writeError(res, 512, "Incorrect test condition in '" + resourceName + "' resource");
            } else {
                this.writeError(res, 500, ex.getMessage().replaceAll("(\\s|\\n|\\r|\\n\\r)+", " "));
                Logger.getLogger(Router.class.getName()).log(Level.SEVERE, "Router " + resourceName + ":{0}", ex.getMessage());
            }
            Logger.getLogger(Router.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (NullPointerException ex) {
            Logger.getLogger(Router.class.getName()).log(Level.SEVERE, "Router " + resourceName + ":{0}", ex.getMessage());
            this.writeError(res, 404, "Resource doesn't exist." + ex.getMessage());
        }
    }

    private void writeError(HttpServletResponse res, int status, String message) throws IOException {
        try (PrintWriter writer = res.getWriter();){
            res.setContentType("application/json;charset=UTF-8");
            res.setCharacterEncoding("UTF-8");
            res.setStatus(status);
            JSONObject obj = new JSONObject();
            obj.put("status", status);
            obj.put("message", (Object)message);
            writer.print(obj.toString());
            writer.flush();
        }
    }

    public void destroy() {
        try {
            this.connectionProvider.shutdown();
        }
        catch (SQLException | NamingException ex) {
            Logger.getLogger(Router.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void init(FilterConfig config) {
        this.encoding = config.getInitParameter("requestEncoding");
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        if (config.getInitParameter(DATA_SOURCE) != null) {
            config.getServletContext().setAttribute(DATA_SOURCE, (Object)config.getInitParameter(DATA_SOURCE));
        } else {
            config.getServletContext().setAttribute(DATA_SOURCE, (Object)"jdbc/mason");
        }
        if (config.getInitParameter(MTG_AUTH_BASIC) != null) {
            config.getServletContext().setAttribute(MTG_AUTH_BASIC, (Object)config.getInitParameter(MTG_AUTH_BASIC));
        }
        if (config.getInitParameter(MTG_AUTH_BEARER) != null) {
            config.getServletContext().setAttribute(MTG_AUTH_BEARER, (Object)config.getInitParameter(MTG_AUTH_BEARER));
        }
        InputStream queryFileInputStream = Router.class.getClassLoader().getResourceAsStream(QUERY_FILE_NAME);
        QueryManagerService queryManagerService = new QueryManagerService(queryFileInputStream);
        try {
            this.connectionProvider = new ConnectionProvider((String)config.getServletContext().getAttribute(DATA_SOURCE));
            config.getServletContext().setAttribute(MASON_QUERY, queryManagerService.getQueryMap());
            config.getServletContext().setAttribute(CONNECTION_PROVIDER, (Object)this.connectionProvider);
            queryFileInputStream.close();
        }
        catch (IOException | SQLException | NamingException ex) {
            Logger.getLogger(Router.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

