/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.model;

import androidx.room.Embedded;
import androidx.room.Relation;
import com.metallicus.protonsdk.model.CurrencyBalance;
import com.metallicus.protonsdk.model.TokenContract;
import java.text.NumberFormat;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\u0017\u001a\u00020\u00142\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u0006\u0010\u001b\u001a\u00020\u000fJ\t\u0010\u001c\u001a\u00020\u0012H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/metallicus/protonsdk/model/TokenCurrencyBalance;", "", "currencyBalance", "Lcom/metallicus/protonsdk/model/CurrencyBalance;", "tokenContract", "Lcom/metallicus/protonsdk/model/TokenContract;", "(Lcom/metallicus/protonsdk/model/CurrencyBalance;Lcom/metallicus/protonsdk/model/TokenContract;)V", "getCurrencyBalance", "()Lcom/metallicus/protonsdk/model/CurrencyBalance;", "getTokenContract", "()Lcom/metallicus/protonsdk/model/TokenContract;", "component1", "component2", "copy", "equals", "", "other", "formatBalance", "", "adjustments", "", "formatBalanceForCurrency", "currency", "getBalanceDouble", "getBalanceForCurrencyDouble", "hashCode", "", "isSystemToken", "toString", "protonsdk_release"})
public final class TokenCurrencyBalance {
    @Embedded
    @NotNull
    private final CurrencyBalance currencyBalance;
    @Relation(parentColumn="tokenContractId", entityColumn="id")
    @NotNull
    private final TokenContract tokenContract;

    public final boolean isSystemToken() {
        return this.tokenContract.isSystemToken();
    }

    private final double getBalanceDouble(double adjustments) {
        return this.currencyBalance.getAmountDouble() + adjustments;
    }

    static /* synthetic */ double getBalanceDouble$default(TokenCurrencyBalance tokenCurrencyBalance, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        return tokenCurrencyBalance.getBalanceDouble(d);
    }

    @NotNull
    public final String formatBalance(double adjustments) {
        NumberFormat nf;
        double balance = this.getBalanceDouble(adjustments);
        NumberFormat numberFormat = nf = NumberFormat.getNumberInstance(Locale.US);
        Intrinsics.checkNotNullExpressionValue((Object)numberFormat, (String)"nf");
        numberFormat.setMinimumFractionDigits(this.tokenContract.getPrecision());
        nf.setMaximumFractionDigits(this.tokenContract.getPrecision());
        String string2 = nf.format(balance);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nf.format(balance)");
        return string2;
    }

    public static /* synthetic */ String formatBalance$default(TokenCurrencyBalance tokenCurrencyBalance, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        return tokenCurrencyBalance.formatBalance(d);
    }

    public final double getBalanceForCurrencyDouble(@NotNull String currency, double adjustments) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        double amount = this.getBalanceDouble(adjustments);
        double rate = this.tokenContract.getRate(currency);
        return amount * rate;
    }

    public static /* synthetic */ double getBalanceForCurrencyDouble$default(TokenCurrencyBalance tokenCurrencyBalance, String string2, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        return tokenCurrencyBalance.getBalanceForCurrencyDouble(string2, d);
    }

    @NotNull
    public final String formatBalanceForCurrency(@NotNull String currency, double adjustments) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        double amountCurrency = this.getBalanceForCurrencyDouble(currency, adjustments);
        NumberFormat nf = NumberFormat.getCurrencyInstance(Locale.US);
        String string2 = nf.format(amountCurrency);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nf.format(amountCurrency)");
        return string2;
    }

    public static /* synthetic */ String formatBalanceForCurrency$default(TokenCurrencyBalance tokenCurrencyBalance, String string2, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        return tokenCurrencyBalance.formatBalanceForCurrency(string2, d);
    }

    @NotNull
    public final CurrencyBalance getCurrencyBalance() {
        return this.currencyBalance;
    }

    @NotNull
    public final TokenContract getTokenContract() {
        return this.tokenContract;
    }

    public TokenCurrencyBalance(@NotNull CurrencyBalance currencyBalance, @NotNull TokenContract tokenContract) {
        Intrinsics.checkNotNullParameter((Object)currencyBalance, (String)"currencyBalance");
        Intrinsics.checkNotNullParameter((Object)tokenContract, (String)"tokenContract");
        this.currencyBalance = currencyBalance;
        this.tokenContract = tokenContract;
    }

    @NotNull
    public final CurrencyBalance component1() {
        return this.currencyBalance;
    }

    @NotNull
    public final TokenContract component2() {
        return this.tokenContract;
    }

    @NotNull
    public final TokenCurrencyBalance copy(@NotNull CurrencyBalance currencyBalance, @NotNull TokenContract tokenContract) {
        Intrinsics.checkNotNullParameter((Object)currencyBalance, (String)"currencyBalance");
        Intrinsics.checkNotNullParameter((Object)tokenContract, (String)"tokenContract");
        return new TokenCurrencyBalance(currencyBalance, tokenContract);
    }

    public static /* synthetic */ TokenCurrencyBalance copy$default(TokenCurrencyBalance tokenCurrencyBalance, CurrencyBalance currencyBalance, TokenContract tokenContract, int n, Object object) {
        if ((n & 1) != 0) {
            currencyBalance = tokenCurrencyBalance.currencyBalance;
        }
        if ((n & 2) != 0) {
            tokenContract = tokenCurrencyBalance.tokenContract;
        }
        return tokenCurrencyBalance.copy(currencyBalance, tokenContract);
    }

    @NotNull
    public String toString() {
        return "TokenCurrencyBalance(currencyBalance=" + this.currencyBalance + ", tokenContract=" + this.tokenContract + ")";
    }

    public int hashCode() {
        CurrencyBalance currencyBalance = this.currencyBalance;
        TokenContract tokenContract = this.tokenContract;
        return (currencyBalance != null ? ((Object)currencyBalance).hashCode() : 0) * 31 + (tokenContract != null ? ((Object)tokenContract).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof TokenCurrencyBalance)) break block3;
                TokenCurrencyBalance tokenCurrencyBalance = (TokenCurrencyBalance)object;
                if (!Intrinsics.areEqual((Object)this.currencyBalance, (Object)tokenCurrencyBalance.currencyBalance) || !Intrinsics.areEqual((Object)this.tokenContract, (Object)tokenCurrencyBalance.tokenContract)) break block3;
            }
            return true;
        }
        return false;
    }
}

