/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.model;

import androidx.room.Entity;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import com.google.gson.annotations.SerializedName;
import com.metallicus.protonsdk.db.DefaultTypeConverters;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0002\b3\b\u0087\b\u0018\u00002\u00020\u0001Bo\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000f\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0012J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000fH\u00c6\u0003J\t\u0010,\u001a\u00020\u0010H\u00c6\u0003J\t\u0010-\u001a\u00020\u0003H\u00c6\u0003J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\t\u0010/\u001a\u00020\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\u0003H\u00c6\u0003J\t\u00101\u001a\u00020\u0003H\u00c6\u0003J\t\u00102\u001a\u00020\u0003H\u00c6\u0003J\t\u00103\u001a\u00020\u000bH\u00c6\u0003J\t\u00104\u001a\u00020\rH\u00c6\u0003J\u0083\u0001\u00105\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0010H\u00c6\u0001J\u0013\u00106\u001a\u00020\r2\b\u00107\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u00108\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u0010J\u0016\u0010:\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u00102\u0006\u0010;\u001a\u00020\u0003J\u0006\u0010<\u001a\u00020\u0003J\u000e\u0010=\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u0003J\u0006\u0010>\u001a\u00020\u000bJ\u000e\u0010?\u001a\u00020\u00102\u0006\u0010;\u001a\u00020\u0003J\u0006\u0010@\u001a\u00020\u0003J\t\u0010A\u001a\u00020\u000bH\u00d6\u0001J\t\u0010B\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0007\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0016\u0010\b\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0016\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0016\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016R\u0016\u0010\t\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0016R\u001a\u0010\u0011\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R&\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0016\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0016\u00a8\u0006C"}, d2={"Lcom/metallicus/protonsdk/model/TokenContract;", "", "id", "", "contract", "name", "url", "description", "iconUrl", "precisionSymbol", "blacklisted", "", "isSystemToken", "", "rates", "", "", "priceChangePercent", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IZLjava/util/Map;D)V", "getBlacklisted", "()I", "getContract", "()Ljava/lang/String;", "getDescription", "getIconUrl", "getId", "setId", "(Ljava/lang/String;)V", "()Z", "setSystemToken", "(Z)V", "getName", "getPrecisionSymbol", "getPriceChangePercent", "()D", "setPriceChangePercent", "(D)V", "getRates", "()Ljava/util/Map;", "setRates", "(Ljava/util/Map;)V", "getUrl", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "formatAmountAsAsset", "amount", "formatAmountForCurrency", "currency", "formatPriceChangePercent", "formatRateForCurrency", "getPrecision", "getRate", "getSymbol", "hashCode", "toString", "protonsdk_release"})
@Entity
@TypeConverters(value={DefaultTypeConverters.class})
public final class TokenContract {
    @SerializedName(value="id")
    @PrimaryKey
    @NotNull
    private String id;
    @SerializedName(value="tcontract")
    @NotNull
    private final String contract;
    @SerializedName(value="tname")
    @NotNull
    private final String name;
    @SerializedName(value="url")
    @NotNull
    private final String url;
    @SerializedName(value="desc")
    @NotNull
    private final String description;
    @SerializedName(value="iconurl")
    @NotNull
    private final String iconUrl;
    @SerializedName(value="symbol")
    @NotNull
    private final String precisionSymbol;
    @SerializedName(value="blisted")
    private final int blacklisted;
    private boolean isSystemToken;
    @NotNull
    private Map<String, Double> rates;
    private double priceChangePercent;

    @NotNull
    public final String getSymbol() {
        return (String)StringsKt.split$default((CharSequence)this.precisionSymbol, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null).get(1);
    }

    public final int getPrecision() {
        String precision;
        String string2 = precision = (String)StringsKt.split$default((CharSequence)this.precisionSymbol, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null).get(0);
        boolean bl = false;
        return Integer.parseInt(string2);
    }

    public final double getRate(@NotNull String currency) {
        double d;
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Map<String, Double> map = this.rates;
        boolean bl = false;
        Map<String, Double> map2 = map;
        boolean bl2 = false;
        if (map2.containsKey(currency)) {
            map = this.rates;
            bl = false;
            Double d2 = map.get(currency);
            if (d2 == null) {
                boolean bl3 = false;
                d2 = 0.0;
            }
            d = ((Number)d2).doubleValue();
        } else {
            map = this.rates;
            String string2 = "USD";
            boolean bl4 = false;
            Double d3 = map.get(string2);
            if (d3 == null) {
                boolean bl5 = false;
                d3 = 0.0;
            }
            d = ((Number)d3).doubleValue();
        }
        return d;
    }

    @NotNull
    public final String formatRateForCurrency(@NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        double rate = this.getRate(currency);
        NumberFormat nf = NumberFormat.getCurrencyInstance(Locale.US);
        String string2 = nf.format(rate);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nf.format(rate)");
        return string2;
    }

    @NotNull
    public final String formatAmountAsAsset(double amount) {
        NumberFormat nf;
        double d = amount;
        boolean bl = false;
        BigDecimal amountBD = new BigDecimal(String.valueOf(d));
        String symbol = this.getSymbol();
        int precision = this.getPrecision();
        NumberFormat numberFormat = nf = NumberFormat.getNumberInstance(Locale.US);
        Intrinsics.checkNotNullExpressionValue((Object)numberFormat, (String)"nf");
        numberFormat.setMinimumFractionDigits(precision);
        nf.setMaximumFractionDigits(precision);
        return nf.format(amountBD) + ' ' + symbol;
    }

    @NotNull
    public final String formatAmountForCurrency(double amount, @NotNull String currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        double rate = this.getRate(currency);
        double amountCurrency = amount * rate;
        NumberFormat nf = NumberFormat.getCurrencyInstance(Locale.US);
        String string2 = nf.format(amountCurrency);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nf.format(amountCurrency)");
        return string2;
    }

    @NotNull
    public final String formatPriceChangePercent() {
        return this.priceChangePercent <= 0.0 ? "" + this.priceChangePercent + '%' : "" + '+' + this.priceChangePercent + '%';
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final void setId(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.id = string2;
    }

    @NotNull
    public final String getContract() {
        return this.contract;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final String getIconUrl() {
        return this.iconUrl;
    }

    @NotNull
    public final String getPrecisionSymbol() {
        return this.precisionSymbol;
    }

    public final int getBlacklisted() {
        return this.blacklisted;
    }

    public final boolean isSystemToken() {
        return this.isSystemToken;
    }

    public final void setSystemToken(boolean bl) {
        this.isSystemToken = bl;
    }

    @NotNull
    public final Map<String, Double> getRates() {
        return this.rates;
    }

    public final void setRates(@NotNull Map<String, Double> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.rates = map;
    }

    public final double getPriceChangePercent() {
        return this.priceChangePercent;
    }

    public final void setPriceChangePercent(double d) {
        this.priceChangePercent = d;
    }

    public TokenContract(@NotNull String id, @NotNull String contract, @NotNull String name, @NotNull String url, @NotNull String description, @NotNull String iconUrl, @NotNull String precisionSymbol, int blacklisted, boolean isSystemToken, @NotNull Map<String, Double> rates, double priceChangePercent) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)iconUrl, (String)"iconUrl");
        Intrinsics.checkNotNullParameter((Object)precisionSymbol, (String)"precisionSymbol");
        Intrinsics.checkNotNullParameter(rates, (String)"rates");
        this.id = id;
        this.contract = contract;
        this.name = name;
        this.url = url;
        this.description = description;
        this.iconUrl = iconUrl;
        this.precisionSymbol = precisionSymbol;
        this.blacklisted = blacklisted;
        this.isSystemToken = isSystemToken;
        this.rates = rates;
        this.priceChangePercent = priceChangePercent;
    }

    public /* synthetic */ TokenContract(String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n, boolean bl, Map map, double d, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x100) != 0) {
            bl = false;
        }
        if ((n2 & 0x200) != 0) {
            map = MapsKt.mapOf((Pair)new Pair((Object)"USD", (Object)0.0));
        }
        if ((n2 & 0x400) != 0) {
            d = 0.0;
        }
        this(string2, string3, string4, string5, string6, string7, string8, n, bl, map, d);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final String component2() {
        return this.contract;
    }

    @NotNull
    public final String component3() {
        return this.name;
    }

    @NotNull
    public final String component4() {
        return this.url;
    }

    @NotNull
    public final String component5() {
        return this.description;
    }

    @NotNull
    public final String component6() {
        return this.iconUrl;
    }

    @NotNull
    public final String component7() {
        return this.precisionSymbol;
    }

    public final int component8() {
        return this.blacklisted;
    }

    public final boolean component9() {
        return this.isSystemToken;
    }

    @NotNull
    public final Map<String, Double> component10() {
        return this.rates;
    }

    public final double component11() {
        return this.priceChangePercent;
    }

    @NotNull
    public final TokenContract copy(@NotNull String id, @NotNull String contract, @NotNull String name, @NotNull String url, @NotNull String description, @NotNull String iconUrl, @NotNull String precisionSymbol, int blacklisted, boolean isSystemToken, @NotNull Map<String, Double> rates, double priceChangePercent) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)iconUrl, (String)"iconUrl");
        Intrinsics.checkNotNullParameter((Object)precisionSymbol, (String)"precisionSymbol");
        Intrinsics.checkNotNullParameter(rates, (String)"rates");
        return new TokenContract(id, contract, name, url, description, iconUrl, precisionSymbol, blacklisted, isSystemToken, rates, priceChangePercent);
    }

    public static /* synthetic */ TokenContract copy$default(TokenContract tokenContract, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n, boolean bl, Map map, double d, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string2 = tokenContract.id;
        }
        if ((n2 & 2) != 0) {
            string3 = tokenContract.contract;
        }
        if ((n2 & 4) != 0) {
            string4 = tokenContract.name;
        }
        if ((n2 & 8) != 0) {
            string5 = tokenContract.url;
        }
        if ((n2 & 0x10) != 0) {
            string6 = tokenContract.description;
        }
        if ((n2 & 0x20) != 0) {
            string7 = tokenContract.iconUrl;
        }
        if ((n2 & 0x40) != 0) {
            string8 = tokenContract.precisionSymbol;
        }
        if ((n2 & 0x80) != 0) {
            n = tokenContract.blacklisted;
        }
        if ((n2 & 0x100) != 0) {
            bl = tokenContract.isSystemToken;
        }
        if ((n2 & 0x200) != 0) {
            map = tokenContract.rates;
        }
        if ((n2 & 0x400) != 0) {
            d = tokenContract.priceChangePercent;
        }
        return tokenContract.copy(string2, string3, string4, string5, string6, string7, string8, n, bl, map, d);
    }

    @NotNull
    public String toString() {
        return "TokenContract(id=" + this.id + ", contract=" + this.contract + ", name=" + this.name + ", url=" + this.url + ", description=" + this.description + ", iconUrl=" + this.iconUrl + ", precisionSymbol=" + this.precisionSymbol + ", blacklisted=" + this.blacklisted + ", isSystemToken=" + this.isSystemToken + ", rates=" + this.rates + ", priceChangePercent=" + this.priceChangePercent + ")";
    }

    public int hashCode() {
        String string2 = this.id;
        String string3 = this.contract;
        String string4 = this.name;
        String string5 = this.url;
        String string6 = this.description;
        String string7 = this.iconUrl;
        String string8 = this.precisionSymbol;
        int n = ((((((((string2 != null ? string2.hashCode() : 0) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31 + (string6 != null ? string6.hashCode() : 0)) * 31 + (string7 != null ? string7.hashCode() : 0)) * 31 + (string8 != null ? string8.hashCode() : 0)) * 31 + Integer.hashCode(this.blacklisted)) * 31;
        int n2 = this.isSystemToken ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        Map<String, Double> map = this.rates;
        return ((n + n2) * 31 + (map != null ? ((Object)map).hashCode() : 0)) * 31 + Double.hashCode(this.priceChangePercent);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof TokenContract)) break block3;
                TokenContract tokenContract = (TokenContract)object;
                if (!Intrinsics.areEqual((Object)this.id, (Object)tokenContract.id) || !Intrinsics.areEqual((Object)this.contract, (Object)tokenContract.contract) || !Intrinsics.areEqual((Object)this.name, (Object)tokenContract.name) || !Intrinsics.areEqual((Object)this.url, (Object)tokenContract.url) || !Intrinsics.areEqual((Object)this.description, (Object)tokenContract.description) || !Intrinsics.areEqual((Object)this.iconUrl, (Object)tokenContract.iconUrl) || !Intrinsics.areEqual((Object)this.precisionSymbol, (Object)tokenContract.precisionSymbol) || this.blacklisted != tokenContract.blacklisted || this.isSystemToken != tokenContract.isSystemToken || !Intrinsics.areEqual(this.rates, tokenContract.rates) || Double.compare(this.priceChangePercent, tokenContract.priceChangePercent) != 0) break block3;
            }
            return true;
        }
        return false;
    }
}

