/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander.model.chain;

import com.google.gson.annotations.Expose;
import com.metallicus.protonsdk.eosio.commander.BitUtils;
import com.metallicus.protonsdk.eosio.commander.HexUtils;
import com.metallicus.protonsdk.eosio.commander.model.types.EosType;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class TransactionHeader
implements EosType.Packer {
    @Expose
    private String expiration;
    @Expose
    private int ref_block_num = 0;
    @Expose
    private long ref_block_prefix = 0L;
    @Expose
    private long max_net_usage_words;
    @Expose
    private long max_cpu_usage_ms;
    @Expose
    private long delay_sec;

    public TransactionHeader() {
    }

    public TransactionHeader(TransactionHeader other) {
        this.expiration = other.expiration;
        this.ref_block_num = other.ref_block_num;
        this.ref_block_prefix = other.ref_block_prefix;
        this.max_net_usage_words = other.max_net_usage_words;
        this.max_cpu_usage_ms = other.max_cpu_usage_ms;
        this.delay_sec = other.delay_sec;
    }

    public String getExpiration() {
        return this.expiration;
    }

    public void setExpiration(String expiration) {
        this.expiration = expiration;
    }

    public void setReferenceBlock(String refBlockIdAsSha256) {
        this.ref_block_num = new BigInteger(1, HexUtils.toBytes(refBlockIdAsSha256.substring(0, 8))).intValue();
        this.ref_block_prefix = BitUtils.uint32ToLong(HexUtils.toBytes(refBlockIdAsSha256.substring(16, 24)), 0);
    }

    public int getRefBlockNum() {
        return this.ref_block_num;
    }

    public long getRefBlockPrefix() {
        return this.ref_block_prefix;
    }

    private Date getExpirationAsDate(String dateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
        try {
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            return sdf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public Long getMaxNetUsageWords() {
        return this.max_net_usage_words;
    }

    public void setMaxNetUsageWords(long netUsage) {
        this.max_net_usage_words = netUsage;
    }

    public Long getMaxCpuUsageMs() {
        return this.max_cpu_usage_ms;
    }

    public void setMaxCpuUsageMs(long kCpuUsage) {
        this.max_cpu_usage_ms = kCpuUsage;
    }

    public Long getDelaySec() {
        return this.delay_sec;
    }

    public void setDelaySec(long delaySec) {
        this.delay_sec = delaySec;
    }

    @Override
    public void pack(EosType.Writer writer) {
        writer.putIntLE((int)(this.getExpirationAsDate(this.expiration).getTime() / 1000L));
        writer.putShortLE((short)(this.ref_block_num & 0xFFFF));
        writer.putIntLE((int)(this.ref_block_prefix & 0xFFFFFFFFFFFFFFFFL));
        writer.putVariableUInt(this.max_net_usage_words);
        writer.putVariableUInt(this.max_cpu_usage_ms);
        writer.putVariableUInt(this.delay_sec);
    }
}

