/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.db;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.metallicus.protonsdk.db.DefaultTypeConverters;
import com.metallicus.protonsdk.db.TokenContractDao;
import com.metallicus.protonsdk.model.TokenContract;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class TokenContractDao_Impl
implements TokenContractDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<TokenContract> __insertionAdapterOfTokenContract;
    private final EntityDeletionOrUpdateAdapter<TokenContract> __updateAdapterOfTokenContract;
    private final SharedSQLiteStatement __preparedStmtOfUpdateRates;
    private final SharedSQLiteStatement __preparedStmtOfRemoveAll;

    public TokenContractDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfTokenContract = new EntityInsertionAdapter<TokenContract>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `TokenContract` (`id`,`contract`,`name`,`url`,`description`,`iconUrl`,`precisionSymbol`,`blacklisted`,`isSystemToken`,`rates`,`priceChangePercent`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, TokenContract value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                if (value.getContract() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getContract());
                }
                if (value.getName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getName());
                }
                if (value.getUrl() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getUrl());
                }
                if (value.getDescription() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getDescription());
                }
                if (value.getIconUrl() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getIconUrl());
                }
                if (value.getPrecisionSymbol() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getPrecisionSymbol());
                }
                stmt.bindLong(8, (long)value.getBlacklisted());
                int _tmp = value.isSystemToken() ? 1 : 0;
                stmt.bindLong(9, (long)_tmp);
                String _tmp_1 = DefaultTypeConverters.stringDoubleMapToString(value.getRates());
                if (_tmp_1 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_1);
                }
                stmt.bindDouble(11, value.getPriceChangePercent());
            }
        };
        this.__updateAdapterOfTokenContract = new EntityDeletionOrUpdateAdapter<TokenContract>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `TokenContract` SET `id` = ?,`contract` = ?,`name` = ?,`url` = ?,`description` = ?,`iconUrl` = ?,`precisionSymbol` = ?,`blacklisted` = ?,`isSystemToken` = ?,`rates` = ?,`priceChangePercent` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, TokenContract value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                if (value.getContract() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getContract());
                }
                if (value.getName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getName());
                }
                if (value.getUrl() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getUrl());
                }
                if (value.getDescription() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getDescription());
                }
                if (value.getIconUrl() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getIconUrl());
                }
                if (value.getPrecisionSymbol() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getPrecisionSymbol());
                }
                stmt.bindLong(8, (long)value.getBlacklisted());
                int _tmp = value.isSystemToken() ? 1 : 0;
                stmt.bindLong(9, (long)_tmp);
                String _tmp_1 = DefaultTypeConverters.stringDoubleMapToString(value.getRates());
                if (_tmp_1 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_1);
                }
                stmt.bindDouble(11, value.getPriceChangePercent());
                if (value.getId() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getId());
                }
            }
        };
        this.__preparedStmtOfUpdateRates = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE tokenContract SET rates = ?, priceChangePercent = ? WHERE id = ?";
                return "UPDATE tokenContract SET rates = ?, priceChangePercent = ? WHERE id = ?";
            }
        };
        this.__preparedStmtOfRemoveAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM tokenContract";
                return "DELETE FROM tokenContract";
            }
        };
    }

    @Override
    public Object insert(final TokenContract tokenContract, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                TokenContractDao_Impl.this.__db.beginTransaction();
                try {
                    TokenContractDao_Impl.this.__insertionAdapterOfTokenContract.insert((Object)tokenContract);
                    TokenContractDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    TokenContractDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object update(final TokenContract tokenContract, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                TokenContractDao_Impl.this.__db.beginTransaction();
                try {
                    TokenContractDao_Impl.this.__updateAdapterOfTokenContract.handle((Object)tokenContract);
                    TokenContractDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    TokenContractDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object updateRates(final String tokenContractId, final String rates, final double priceChangePercent, Continuation<? super Unit> p3) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = TokenContractDao_Impl.this.__preparedStmtOfUpdateRates.acquire();
                int _argIndex = 1;
                if (rates == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, rates);
                }
                _argIndex = 2;
                _stmt.bindDouble(_argIndex, priceChangePercent);
                _argIndex = 3;
                if (tokenContractId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, tokenContractId);
                }
                TokenContractDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    TokenContractDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    TokenContractDao_Impl.this.__db.endTransaction();
                    TokenContractDao_Impl.this.__preparedStmtOfUpdateRates.release(_stmt);
                }
            }
        }, p3);
    }

    @Override
    public Object removeAll(Continuation<? super Unit> p0) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = TokenContractDao_Impl.this.__preparedStmtOfRemoveAll.acquire();
                TokenContractDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    TokenContractDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    TokenContractDao_Impl.this.__db.endTransaction();
                    TokenContractDao_Impl.this.__preparedStmtOfRemoveAll.release(_stmt);
                }
            }
        }, p0);
    }

    @Override
    public Object findById(String id, Continuation<? super TokenContract> p1) {
        String _sql = "SELECT * FROM tokenContract WHERE id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM tokenContract WHERE id = ?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<TokenContract>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TokenContract call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)TokenContractDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    TokenContract _result;
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfContract = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contract");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfIconUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iconUrl");
                    int _cursorIndexOfPrecisionSymbol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"precisionSymbol");
                    int _cursorIndexOfBlacklisted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blacklisted");
                    int _cursorIndexOfIsSystemToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSystemToken");
                    int _cursorIndexOfRates = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rates");
                    int _cursorIndexOfPriceChangePercent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priceChangePercent");
                    if (_cursor.moveToFirst()) {
                        String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                        String _tmpContract = _cursor.isNull(_cursorIndexOfContract) ? null : _cursor.getString(_cursorIndexOfContract);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        String _tmpUrl = _cursor.isNull(_cursorIndexOfUrl) ? null : _cursor.getString(_cursorIndexOfUrl);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        String _tmpIconUrl = _cursor.isNull(_cursorIndexOfIconUrl) ? null : _cursor.getString(_cursorIndexOfIconUrl);
                        String _tmpPrecisionSymbol = _cursor.isNull(_cursorIndexOfPrecisionSymbol) ? null : _cursor.getString(_cursorIndexOfPrecisionSymbol);
                        int _tmpBlacklisted = _cursor.getInt(_cursorIndexOfBlacklisted);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsSystemToken);
                        boolean _tmpIsSystemToken = _tmp != 0;
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfRates) ? null : _cursor.getString(_cursorIndexOfRates);
                        Map<String, Double> _tmpRates = DefaultTypeConverters.stringToStringDoubleMap(_tmp_1);
                        double _tmpPriceChangePercent = _cursor.getDouble(_cursorIndexOfPriceChangePercent);
                        _result = new TokenContract(_tmpId, _tmpContract, _tmpName, _tmpUrl, _tmpDescription, _tmpIconUrl, _tmpPrecisionSymbol, _tmpBlacklisted, _tmpIsSystemToken, _tmpRates, _tmpPriceChangePercent);
                    } else {
                        _result = null;
                    }
                    TokenContract tokenContract = _result;
                    return tokenContract;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p1);
    }

    @Override
    public Object findAll(Continuation<? super List<TokenContract>> p0) {
        String _sql = "SELECT * FROM tokenContract";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM tokenContract", (int)0);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<TokenContract>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<TokenContract> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)TokenContractDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfContract = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contract");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfIconUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iconUrl");
                    int _cursorIndexOfPrecisionSymbol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"precisionSymbol");
                    int _cursorIndexOfBlacklisted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blacklisted");
                    int _cursorIndexOfIsSystemToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSystemToken");
                    int _cursorIndexOfRates = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rates");
                    int _cursorIndexOfPriceChangePercent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"priceChangePercent");
                    ArrayList<TokenContract> _result = new ArrayList<TokenContract>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                        String _tmpContract = _cursor.isNull(_cursorIndexOfContract) ? null : _cursor.getString(_cursorIndexOfContract);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        String _tmpUrl = _cursor.isNull(_cursorIndexOfUrl) ? null : _cursor.getString(_cursorIndexOfUrl);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        String _tmpIconUrl = _cursor.isNull(_cursorIndexOfIconUrl) ? null : _cursor.getString(_cursorIndexOfIconUrl);
                        String _tmpPrecisionSymbol = _cursor.isNull(_cursorIndexOfPrecisionSymbol) ? null : _cursor.getString(_cursorIndexOfPrecisionSymbol);
                        int _tmpBlacklisted = _cursor.getInt(_cursorIndexOfBlacklisted);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsSystemToken);
                        boolean _tmpIsSystemToken = _tmp != 0;
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfRates) ? null : _cursor.getString(_cursorIndexOfRates);
                        Map<String, Double> _tmpRates = DefaultTypeConverters.stringToStringDoubleMap(_tmp_1);
                        double _tmpPriceChangePercent = _cursor.getDouble(_cursorIndexOfPriceChangePercent);
                        TokenContract _item = new TokenContract(_tmpId, _tmpContract, _tmpName, _tmpUrl, _tmpDescription, _tmpIconUrl, _tmpPrecisionSymbol, _tmpBlacklisted, _tmpIsSystemToken, _tmpRates, _tmpPriceChangePercent);
                        _result.add(_item);
                    }
                    ArrayList<TokenContract> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p0);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

