/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.db;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.metallicus.protonsdk.db.EOSTypeConverters;
import com.metallicus.protonsdk.db.ESRSessionDao;
import com.metallicus.protonsdk.db.ProtonTypeConverters;
import com.metallicus.protonsdk.model.Account;
import com.metallicus.protonsdk.model.AccountCpuLimit;
import com.metallicus.protonsdk.model.AccountNetLimit;
import com.metallicus.protonsdk.model.AccountPermission;
import com.metallicus.protonsdk.model.AccountSelfDelegatedBandwidth;
import com.metallicus.protonsdk.model.AccountTotalResources;
import com.metallicus.protonsdk.model.AccountVoterInfo;
import com.metallicus.protonsdk.model.ESRSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class ESRSessionDao_Impl
implements ESRSessionDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ESRSession> __insertionAdapterOfESRSession;
    private final EntityDeletionOrUpdateAdapter<ESRSession> __updateAdapterOfESRSession;
    private final SharedSQLiteStatement __preparedStmtOfRemove;
    private final SharedSQLiteStatement __preparedStmtOfRemoveAll;

    public ESRSessionDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfESRSession = new EntityInsertionAdapter<ESRSession>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ESRSession` (`id`,`signer`,`callbackUrl`,`receiveKey`,`receiveChannelUrl`,`createdAt`,`updatedAt`,`requester_accountChainId`,`requester_accountContact`,`requester_votersXPRInfo`,`requester_refundsXPRInfo`,`requester_accountName`,`requester_headBlockNum`,`requester_headBlockTime`,`requester_privileged`,`requester_lastCodeUpdate`,`requester_created`,`requester_coreLiquidBalance`,`requester_ramQuota`,`requester_netWeight`,`requester_cpuWeight`,`requester_ramUsage`,`requester_permissions`,`requester_net_limit_used`,`requester_net_limit_available`,`requester_net_limit_max`,`requester_cpu_limit_used`,`requester_cpu_limit_available`,`requester_cpu_limit_max`,`requester_total_resources_owner`,`requester_total_resources_netWeight`,`requester_total_resources_cpuWeight`,`requester_total_resources_ramBytes`,`requester_self_delegated_bandwidth_from`,`requester_self_delegated_bandwidth_to`,`requester_self_delegated_bandwidth_netWeight`,`requester_self_delegated_bandwidth_cpuWeight`,`requester_voter_info_owner`,`requester_voter_info_proxy`,`requester_voter_info_staked`,`requester_voter_info_lastVoteWeight`,`requester_voter_info_proxiedVoteWeight`,`requester_voter_info_isProxy`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ESRSession value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                if (value.getSigner() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getSigner());
                }
                if (value.getCallbackUrl() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getCallbackUrl());
                }
                if (value.getReceiveKey() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getReceiveKey());
                }
                if (value.getReceiveChannelUrl() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getReceiveChannelUrl());
                }
                stmt.bindLong(6, value.getCreatedAt());
                stmt.bindLong(7, value.getUpdatedAt());
                Account _tmpRequester = value.getRequester();
                if (_tmpRequester != null) {
                    if (_tmpRequester.accountChainId == null) {
                        stmt.bindNull(8);
                    } else {
                        stmt.bindString(8, _tmpRequester.accountChainId);
                    }
                    String _tmp = ProtonTypeConverters.accountContactToString(_tmpRequester.accountContact);
                    if (_tmp == null) {
                        stmt.bindNull(9);
                    } else {
                        stmt.bindString(9, _tmp);
                    }
                    String _tmp_1 = ProtonTypeConverters.accountVotersXPRInfoToString(_tmpRequester.votersXPRInfo);
                    if (_tmp_1 == null) {
                        stmt.bindNull(10);
                    } else {
                        stmt.bindString(10, _tmp_1);
                    }
                    String _tmp_2 = ProtonTypeConverters.accountRefundsXPRInfoToString(_tmpRequester.refundsXPRInfo);
                    if (_tmp_2 == null) {
                        stmt.bindNull(11);
                    } else {
                        stmt.bindString(11, _tmp_2);
                    }
                    if (_tmpRequester.getAccountName() == null) {
                        stmt.bindNull(12);
                    } else {
                        stmt.bindString(12, _tmpRequester.getAccountName());
                    }
                    stmt.bindLong(13, (long)_tmpRequester.getHeadBlockNum());
                    if (_tmpRequester.getHeadBlockTime() == null) {
                        stmt.bindNull(14);
                    } else {
                        stmt.bindString(14, _tmpRequester.getHeadBlockTime());
                    }
                    int _tmp_3 = _tmpRequester.getPrivileged() ? 1 : 0;
                    stmt.bindLong(15, (long)_tmp_3);
                    if (_tmpRequester.getLastCodeUpdate() == null) {
                        stmt.bindNull(16);
                    } else {
                        stmt.bindString(16, _tmpRequester.getLastCodeUpdate());
                    }
                    if (_tmpRequester.getCreated() == null) {
                        stmt.bindNull(17);
                    } else {
                        stmt.bindString(17, _tmpRequester.getCreated());
                    }
                    if (_tmpRequester.getCoreLiquidBalance() == null) {
                        stmt.bindNull(18);
                    } else {
                        stmt.bindString(18, _tmpRequester.getCoreLiquidBalance());
                    }
                    stmt.bindLong(19, (long)_tmpRequester.getRamQuota());
                    stmt.bindLong(20, _tmpRequester.getNetWeight());
                    stmt.bindLong(21, _tmpRequester.getCpuWeight());
                    stmt.bindLong(22, _tmpRequester.getRamUsage());
                    String _tmp_4 = EOSTypeConverters.accountPermissionListToString(_tmpRequester.getPermissions());
                    if (_tmp_4 == null) {
                        stmt.bindNull(23);
                    } else {
                        stmt.bindString(23, _tmp_4);
                    }
                    AccountNetLimit _tmpNetLimit = _tmpRequester.getNetLimit();
                    if (_tmpNetLimit != null) {
                        stmt.bindLong(24, _tmpNetLimit.getUsed());
                        stmt.bindLong(25, _tmpNetLimit.getAvailable());
                        stmt.bindLong(26, _tmpNetLimit.getMax());
                    } else {
                        stmt.bindNull(24);
                        stmt.bindNull(25);
                        stmt.bindNull(26);
                    }
                    AccountCpuLimit _tmpCpuLimit = _tmpRequester.getCpuLimit();
                    if (_tmpCpuLimit != null) {
                        stmt.bindLong(27, _tmpCpuLimit.getUsed());
                        stmt.bindLong(28, _tmpCpuLimit.getAvailable());
                        stmt.bindLong(29, _tmpCpuLimit.getMax());
                    } else {
                        stmt.bindNull(27);
                        stmt.bindNull(28);
                        stmt.bindNull(29);
                    }
                    AccountTotalResources _tmpTotalResources = _tmpRequester.getTotalResources();
                    if (_tmpTotalResources != null) {
                        if (_tmpTotalResources.getOwner() == null) {
                            stmt.bindNull(30);
                        } else {
                            stmt.bindString(30, _tmpTotalResources.getOwner());
                        }
                        if (_tmpTotalResources.getNetWeight() == null) {
                            stmt.bindNull(31);
                        } else {
                            stmt.bindString(31, _tmpTotalResources.getNetWeight());
                        }
                        if (_tmpTotalResources.getCpuWeight() == null) {
                            stmt.bindNull(32);
                        } else {
                            stmt.bindString(32, _tmpTotalResources.getCpuWeight());
                        }
                        stmt.bindLong(33, (long)_tmpTotalResources.getRamBytes());
                    } else {
                        stmt.bindNull(30);
                        stmt.bindNull(31);
                        stmt.bindNull(32);
                        stmt.bindNull(33);
                    }
                    AccountSelfDelegatedBandwidth _tmpSelfDelegatedBandwidth = _tmpRequester.getSelfDelegatedBandwidth();
                    if (_tmpSelfDelegatedBandwidth != null) {
                        if (_tmpSelfDelegatedBandwidth.getFrom() == null) {
                            stmt.bindNull(34);
                        } else {
                            stmt.bindString(34, _tmpSelfDelegatedBandwidth.getFrom());
                        }
                        if (_tmpSelfDelegatedBandwidth.getTo() == null) {
                            stmt.bindNull(35);
                        } else {
                            stmt.bindString(35, _tmpSelfDelegatedBandwidth.getTo());
                        }
                        if (_tmpSelfDelegatedBandwidth.getNetWeight() == null) {
                            stmt.bindNull(36);
                        } else {
                            stmt.bindString(36, _tmpSelfDelegatedBandwidth.getNetWeight());
                        }
                        if (_tmpSelfDelegatedBandwidth.getCpuWeight() == null) {
                            stmt.bindNull(37);
                        } else {
                            stmt.bindString(37, _tmpSelfDelegatedBandwidth.getCpuWeight());
                        }
                    } else {
                        stmt.bindNull(34);
                        stmt.bindNull(35);
                        stmt.bindNull(36);
                        stmt.bindNull(37);
                    }
                    AccountVoterInfo _tmpVoterInfo = _tmpRequester.getVoterInfo();
                    if (_tmpVoterInfo != null) {
                        if (_tmpVoterInfo.getOwner() == null) {
                            stmt.bindNull(38);
                        } else {
                            stmt.bindString(38, _tmpVoterInfo.getOwner());
                        }
                        if (_tmpVoterInfo.getProxy() == null) {
                            stmt.bindNull(39);
                        } else {
                            stmt.bindString(39, _tmpVoterInfo.getProxy());
                        }
                        stmt.bindLong(40, _tmpVoterInfo.getStaked());
                        if (_tmpVoterInfo.getLastVoteWeight() == null) {
                            stmt.bindNull(41);
                        } else {
                            stmt.bindString(41, _tmpVoterInfo.getLastVoteWeight());
                        }
                        if (_tmpVoterInfo.getProxiedVoteWeight() == null) {
                            stmt.bindNull(42);
                        } else {
                            stmt.bindString(42, _tmpVoterInfo.getProxiedVoteWeight());
                        }
                        stmt.bindLong(43, (long)_tmpVoterInfo.isProxy());
                    } else {
                        stmt.bindNull(38);
                        stmt.bindNull(39);
                        stmt.bindNull(40);
                        stmt.bindNull(41);
                        stmt.bindNull(42);
                        stmt.bindNull(43);
                    }
                } else {
                    stmt.bindNull(8);
                    stmt.bindNull(9);
                    stmt.bindNull(10);
                    stmt.bindNull(11);
                    stmt.bindNull(12);
                    stmt.bindNull(13);
                    stmt.bindNull(14);
                    stmt.bindNull(15);
                    stmt.bindNull(16);
                    stmt.bindNull(17);
                    stmt.bindNull(18);
                    stmt.bindNull(19);
                    stmt.bindNull(20);
                    stmt.bindNull(21);
                    stmt.bindNull(22);
                    stmt.bindNull(23);
                    stmt.bindNull(24);
                    stmt.bindNull(25);
                    stmt.bindNull(26);
                    stmt.bindNull(27);
                    stmt.bindNull(28);
                    stmt.bindNull(29);
                    stmt.bindNull(30);
                    stmt.bindNull(31);
                    stmt.bindNull(32);
                    stmt.bindNull(33);
                    stmt.bindNull(34);
                    stmt.bindNull(35);
                    stmt.bindNull(36);
                    stmt.bindNull(37);
                    stmt.bindNull(38);
                    stmt.bindNull(39);
                    stmt.bindNull(40);
                    stmt.bindNull(41);
                    stmt.bindNull(42);
                    stmt.bindNull(43);
                }
            }
        };
        this.__updateAdapterOfESRSession = new EntityDeletionOrUpdateAdapter<ESRSession>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `ESRSession` SET `id` = ?,`signer` = ?,`callbackUrl` = ?,`receiveKey` = ?,`receiveChannelUrl` = ?,`createdAt` = ?,`updatedAt` = ?,`requester_accountChainId` = ?,`requester_accountContact` = ?,`requester_votersXPRInfo` = ?,`requester_refundsXPRInfo` = ?,`requester_accountName` = ?,`requester_headBlockNum` = ?,`requester_headBlockTime` = ?,`requester_privileged` = ?,`requester_lastCodeUpdate` = ?,`requester_created` = ?,`requester_coreLiquidBalance` = ?,`requester_ramQuota` = ?,`requester_netWeight` = ?,`requester_cpuWeight` = ?,`requester_ramUsage` = ?,`requester_permissions` = ?,`requester_net_limit_used` = ?,`requester_net_limit_available` = ?,`requester_net_limit_max` = ?,`requester_cpu_limit_used` = ?,`requester_cpu_limit_available` = ?,`requester_cpu_limit_max` = ?,`requester_total_resources_owner` = ?,`requester_total_resources_netWeight` = ?,`requester_total_resources_cpuWeight` = ?,`requester_total_resources_ramBytes` = ?,`requester_self_delegated_bandwidth_from` = ?,`requester_self_delegated_bandwidth_to` = ?,`requester_self_delegated_bandwidth_netWeight` = ?,`requester_self_delegated_bandwidth_cpuWeight` = ?,`requester_voter_info_owner` = ?,`requester_voter_info_proxy` = ?,`requester_voter_info_staked` = ?,`requester_voter_info_lastVoteWeight` = ?,`requester_voter_info_proxiedVoteWeight` = ?,`requester_voter_info_isProxy` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ESRSession value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                if (value.getSigner() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getSigner());
                }
                if (value.getCallbackUrl() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getCallbackUrl());
                }
                if (value.getReceiveKey() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getReceiveKey());
                }
                if (value.getReceiveChannelUrl() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getReceiveChannelUrl());
                }
                stmt.bindLong(6, value.getCreatedAt());
                stmt.bindLong(7, value.getUpdatedAt());
                Account _tmpRequester = value.getRequester();
                if (_tmpRequester != null) {
                    if (_tmpRequester.accountChainId == null) {
                        stmt.bindNull(8);
                    } else {
                        stmt.bindString(8, _tmpRequester.accountChainId);
                    }
                    String _tmp = ProtonTypeConverters.accountContactToString(_tmpRequester.accountContact);
                    if (_tmp == null) {
                        stmt.bindNull(9);
                    } else {
                        stmt.bindString(9, _tmp);
                    }
                    String _tmp_1 = ProtonTypeConverters.accountVotersXPRInfoToString(_tmpRequester.votersXPRInfo);
                    if (_tmp_1 == null) {
                        stmt.bindNull(10);
                    } else {
                        stmt.bindString(10, _tmp_1);
                    }
                    String _tmp_2 = ProtonTypeConverters.accountRefundsXPRInfoToString(_tmpRequester.refundsXPRInfo);
                    if (_tmp_2 == null) {
                        stmt.bindNull(11);
                    } else {
                        stmt.bindString(11, _tmp_2);
                    }
                    if (_tmpRequester.getAccountName() == null) {
                        stmt.bindNull(12);
                    } else {
                        stmt.bindString(12, _tmpRequester.getAccountName());
                    }
                    stmt.bindLong(13, (long)_tmpRequester.getHeadBlockNum());
                    if (_tmpRequester.getHeadBlockTime() == null) {
                        stmt.bindNull(14);
                    } else {
                        stmt.bindString(14, _tmpRequester.getHeadBlockTime());
                    }
                    int _tmp_3 = _tmpRequester.getPrivileged() ? 1 : 0;
                    stmt.bindLong(15, (long)_tmp_3);
                    if (_tmpRequester.getLastCodeUpdate() == null) {
                        stmt.bindNull(16);
                    } else {
                        stmt.bindString(16, _tmpRequester.getLastCodeUpdate());
                    }
                    if (_tmpRequester.getCreated() == null) {
                        stmt.bindNull(17);
                    } else {
                        stmt.bindString(17, _tmpRequester.getCreated());
                    }
                    if (_tmpRequester.getCoreLiquidBalance() == null) {
                        stmt.bindNull(18);
                    } else {
                        stmt.bindString(18, _tmpRequester.getCoreLiquidBalance());
                    }
                    stmt.bindLong(19, (long)_tmpRequester.getRamQuota());
                    stmt.bindLong(20, _tmpRequester.getNetWeight());
                    stmt.bindLong(21, _tmpRequester.getCpuWeight());
                    stmt.bindLong(22, _tmpRequester.getRamUsage());
                    String _tmp_4 = EOSTypeConverters.accountPermissionListToString(_tmpRequester.getPermissions());
                    if (_tmp_4 == null) {
                        stmt.bindNull(23);
                    } else {
                        stmt.bindString(23, _tmp_4);
                    }
                    AccountNetLimit _tmpNetLimit = _tmpRequester.getNetLimit();
                    if (_tmpNetLimit != null) {
                        stmt.bindLong(24, _tmpNetLimit.getUsed());
                        stmt.bindLong(25, _tmpNetLimit.getAvailable());
                        stmt.bindLong(26, _tmpNetLimit.getMax());
                    } else {
                        stmt.bindNull(24);
                        stmt.bindNull(25);
                        stmt.bindNull(26);
                    }
                    AccountCpuLimit _tmpCpuLimit = _tmpRequester.getCpuLimit();
                    if (_tmpCpuLimit != null) {
                        stmt.bindLong(27, _tmpCpuLimit.getUsed());
                        stmt.bindLong(28, _tmpCpuLimit.getAvailable());
                        stmt.bindLong(29, _tmpCpuLimit.getMax());
                    } else {
                        stmt.bindNull(27);
                        stmt.bindNull(28);
                        stmt.bindNull(29);
                    }
                    AccountTotalResources _tmpTotalResources = _tmpRequester.getTotalResources();
                    if (_tmpTotalResources != null) {
                        if (_tmpTotalResources.getOwner() == null) {
                            stmt.bindNull(30);
                        } else {
                            stmt.bindString(30, _tmpTotalResources.getOwner());
                        }
                        if (_tmpTotalResources.getNetWeight() == null) {
                            stmt.bindNull(31);
                        } else {
                            stmt.bindString(31, _tmpTotalResources.getNetWeight());
                        }
                        if (_tmpTotalResources.getCpuWeight() == null) {
                            stmt.bindNull(32);
                        } else {
                            stmt.bindString(32, _tmpTotalResources.getCpuWeight());
                        }
                        stmt.bindLong(33, (long)_tmpTotalResources.getRamBytes());
                    } else {
                        stmt.bindNull(30);
                        stmt.bindNull(31);
                        stmt.bindNull(32);
                        stmt.bindNull(33);
                    }
                    AccountSelfDelegatedBandwidth _tmpSelfDelegatedBandwidth = _tmpRequester.getSelfDelegatedBandwidth();
                    if (_tmpSelfDelegatedBandwidth != null) {
                        if (_tmpSelfDelegatedBandwidth.getFrom() == null) {
                            stmt.bindNull(34);
                        } else {
                            stmt.bindString(34, _tmpSelfDelegatedBandwidth.getFrom());
                        }
                        if (_tmpSelfDelegatedBandwidth.getTo() == null) {
                            stmt.bindNull(35);
                        } else {
                            stmt.bindString(35, _tmpSelfDelegatedBandwidth.getTo());
                        }
                        if (_tmpSelfDelegatedBandwidth.getNetWeight() == null) {
                            stmt.bindNull(36);
                        } else {
                            stmt.bindString(36, _tmpSelfDelegatedBandwidth.getNetWeight());
                        }
                        if (_tmpSelfDelegatedBandwidth.getCpuWeight() == null) {
                            stmt.bindNull(37);
                        } else {
                            stmt.bindString(37, _tmpSelfDelegatedBandwidth.getCpuWeight());
                        }
                    } else {
                        stmt.bindNull(34);
                        stmt.bindNull(35);
                        stmt.bindNull(36);
                        stmt.bindNull(37);
                    }
                    AccountVoterInfo _tmpVoterInfo = _tmpRequester.getVoterInfo();
                    if (_tmpVoterInfo != null) {
                        if (_tmpVoterInfo.getOwner() == null) {
                            stmt.bindNull(38);
                        } else {
                            stmt.bindString(38, _tmpVoterInfo.getOwner());
                        }
                        if (_tmpVoterInfo.getProxy() == null) {
                            stmt.bindNull(39);
                        } else {
                            stmt.bindString(39, _tmpVoterInfo.getProxy());
                        }
                        stmt.bindLong(40, _tmpVoterInfo.getStaked());
                        if (_tmpVoterInfo.getLastVoteWeight() == null) {
                            stmt.bindNull(41);
                        } else {
                            stmt.bindString(41, _tmpVoterInfo.getLastVoteWeight());
                        }
                        if (_tmpVoterInfo.getProxiedVoteWeight() == null) {
                            stmt.bindNull(42);
                        } else {
                            stmt.bindString(42, _tmpVoterInfo.getProxiedVoteWeight());
                        }
                        stmt.bindLong(43, (long)_tmpVoterInfo.isProxy());
                    } else {
                        stmt.bindNull(38);
                        stmt.bindNull(39);
                        stmt.bindNull(40);
                        stmt.bindNull(41);
                        stmt.bindNull(42);
                        stmt.bindNull(43);
                    }
                } else {
                    stmt.bindNull(8);
                    stmt.bindNull(9);
                    stmt.bindNull(10);
                    stmt.bindNull(11);
                    stmt.bindNull(12);
                    stmt.bindNull(13);
                    stmt.bindNull(14);
                    stmt.bindNull(15);
                    stmt.bindNull(16);
                    stmt.bindNull(17);
                    stmt.bindNull(18);
                    stmt.bindNull(19);
                    stmt.bindNull(20);
                    stmt.bindNull(21);
                    stmt.bindNull(22);
                    stmt.bindNull(23);
                    stmt.bindNull(24);
                    stmt.bindNull(25);
                    stmt.bindNull(26);
                    stmt.bindNull(27);
                    stmt.bindNull(28);
                    stmt.bindNull(29);
                    stmt.bindNull(30);
                    stmt.bindNull(31);
                    stmt.bindNull(32);
                    stmt.bindNull(33);
                    stmt.bindNull(34);
                    stmt.bindNull(35);
                    stmt.bindNull(36);
                    stmt.bindNull(37);
                    stmt.bindNull(38);
                    stmt.bindNull(39);
                    stmt.bindNull(40);
                    stmt.bindNull(41);
                    stmt.bindNull(42);
                    stmt.bindNull(43);
                }
                if (value.getId() == null) {
                    stmt.bindNull(44);
                } else {
                    stmt.bindString(44, value.getId());
                }
            }
        };
        this.__preparedStmtOfRemove = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM esrSession WHERE id = ?";
                return "DELETE FROM esrSession WHERE id = ?";
            }
        };
        this.__preparedStmtOfRemoveAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM esrSession";
                return "DELETE FROM esrSession";
            }
        };
    }

    @Override
    public Object insert(final ESRSession esrSession, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ESRSessionDao_Impl.this.__db.beginTransaction();
                try {
                    ESRSessionDao_Impl.this.__insertionAdapterOfESRSession.insert((Object)esrSession);
                    ESRSessionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ESRSessionDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object update(final ESRSession esrSession, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ESRSessionDao_Impl.this.__db.beginTransaction();
                try {
                    ESRSessionDao_Impl.this.__updateAdapterOfESRSession.handle((Object)esrSession);
                    ESRSessionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ESRSessionDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object remove(final String id, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ESRSessionDao_Impl.this.__preparedStmtOfRemove.acquire();
                int _argIndex = 1;
                if (id == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, id);
                }
                ESRSessionDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ESRSessionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ESRSessionDao_Impl.this.__db.endTransaction();
                    ESRSessionDao_Impl.this.__preparedStmtOfRemove.release(_stmt);
                }
            }
        }, p1);
    }

    @Override
    public Object removeAll(Continuation<? super Unit> p0) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ESRSessionDao_Impl.this.__preparedStmtOfRemoveAll.acquire();
                ESRSessionDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ESRSessionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ESRSessionDao_Impl.this.__db.endTransaction();
                    ESRSessionDao_Impl.this.__preparedStmtOfRemoveAll.release(_stmt);
                }
            }
        }, p0);
    }

    @Override
    public Object findById(String id, Continuation<? super ESRSession> p1) {
        String _sql = "SELECT * FROM esrSession WHERE id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM esrSession WHERE id = ?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ESRSession>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ESRSession call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ESRSessionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ESRSession _result;
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfSigner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signer");
                    int _cursorIndexOfCallbackUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"callbackUrl");
                    int _cursorIndexOfReceiveKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"receiveKey");
                    int _cursorIndexOfReceiveChannelUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"receiveChannelUrl");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfAccountChainId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_accountChainId");
                    int _cursorIndexOfAccountContact = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_accountContact");
                    int _cursorIndexOfVotersXPRInfo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_votersXPRInfo");
                    int _cursorIndexOfRefundsXPRInfo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_refundsXPRInfo");
                    int _cursorIndexOfAccountName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_accountName");
                    int _cursorIndexOfHeadBlockNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_headBlockNum");
                    int _cursorIndexOfHeadBlockTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_headBlockTime");
                    int _cursorIndexOfPrivileged = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_privileged");
                    int _cursorIndexOfLastCodeUpdate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_lastCodeUpdate");
                    int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_created");
                    int _cursorIndexOfCoreLiquidBalance = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_coreLiquidBalance");
                    int _cursorIndexOfRamQuota = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_ramQuota");
                    int _cursorIndexOfNetWeight = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_netWeight");
                    int _cursorIndexOfCpuWeight = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_cpuWeight");
                    int _cursorIndexOfRamUsage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_ramUsage");
                    int _cursorIndexOfPermissions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_permissions");
                    int _cursorIndexOfUsed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_net_limit_used");
                    int _cursorIndexOfAvailable = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_net_limit_available");
                    int _cursorIndexOfMax = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_net_limit_max");
                    int _cursorIndexOfUsed_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_cpu_limit_used");
                    int _cursorIndexOfAvailable_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_cpu_limit_available");
                    int _cursorIndexOfMax_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_cpu_limit_max");
                    int _cursorIndexOfOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_total_resources_owner");
                    int _cursorIndexOfNetWeight_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_total_resources_netWeight");
                    int _cursorIndexOfCpuWeight_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_total_resources_cpuWeight");
                    int _cursorIndexOfRamBytes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_total_resources_ramBytes");
                    int _cursorIndexOfFrom = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_self_delegated_bandwidth_from");
                    int _cursorIndexOfTo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_self_delegated_bandwidth_to");
                    int _cursorIndexOfNetWeight_2 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_self_delegated_bandwidth_netWeight");
                    int _cursorIndexOfCpuWeight_2 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_self_delegated_bandwidth_cpuWeight");
                    int _cursorIndexOfOwner_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_voter_info_owner");
                    int _cursorIndexOfProxy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_voter_info_proxy");
                    int _cursorIndexOfStaked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_voter_info_staked");
                    int _cursorIndexOfLastVoteWeight = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_voter_info_lastVoteWeight");
                    int _cursorIndexOfProxiedVoteWeight = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_voter_info_proxiedVoteWeight");
                    int _cursorIndexOfIsProxy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_voter_info_isProxy");
                    if (_cursor.moveToFirst()) {
                        Account _tmpRequester;
                        String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                        String _tmpSigner = _cursor.isNull(_cursorIndexOfSigner) ? null : _cursor.getString(_cursorIndexOfSigner);
                        String _tmpCallbackUrl = _cursor.isNull(_cursorIndexOfCallbackUrl) ? null : _cursor.getString(_cursorIndexOfCallbackUrl);
                        String _tmpReceiveKey = _cursor.isNull(_cursorIndexOfReceiveKey) ? null : _cursor.getString(_cursorIndexOfReceiveKey);
                        String _tmpReceiveChannelUrl = _cursor.isNull(_cursorIndexOfReceiveChannelUrl) ? null : _cursor.getString(_cursorIndexOfReceiveChannelUrl);
                        long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                        long _tmpUpdatedAt = _cursor.getLong(_cursorIndexOfUpdatedAt);
                        if (!(_cursor.isNull(_cursorIndexOfAccountChainId) && _cursor.isNull(_cursorIndexOfAccountContact) && _cursor.isNull(_cursorIndexOfVotersXPRInfo) && _cursor.isNull(_cursorIndexOfRefundsXPRInfo) && _cursor.isNull(_cursorIndexOfAccountName) && _cursor.isNull(_cursorIndexOfHeadBlockNum) && _cursor.isNull(_cursorIndexOfHeadBlockTime) && _cursor.isNull(_cursorIndexOfPrivileged) && _cursor.isNull(_cursorIndexOfLastCodeUpdate) && _cursor.isNull(_cursorIndexOfCreated) && _cursor.isNull(_cursorIndexOfCoreLiquidBalance) && _cursor.isNull(_cursorIndexOfRamQuota) && _cursor.isNull(_cursorIndexOfNetWeight) && _cursor.isNull(_cursorIndexOfCpuWeight) && _cursor.isNull(_cursorIndexOfRamUsage) && _cursor.isNull(_cursorIndexOfPermissions) && _cursor.isNull(_cursorIndexOfUsed) && _cursor.isNull(_cursorIndexOfAvailable) && _cursor.isNull(_cursorIndexOfMax) && _cursor.isNull(_cursorIndexOfUsed_1) && _cursor.isNull(_cursorIndexOfAvailable_1) && _cursor.isNull(_cursorIndexOfMax_1) && _cursor.isNull(_cursorIndexOfOwner) && _cursor.isNull(_cursorIndexOfNetWeight_1) && _cursor.isNull(_cursorIndexOfCpuWeight_1) && _cursor.isNull(_cursorIndexOfRamBytes) && _cursor.isNull(_cursorIndexOfFrom) && _cursor.isNull(_cursorIndexOfTo) && _cursor.isNull(_cursorIndexOfNetWeight_2) && _cursor.isNull(_cursorIndexOfCpuWeight_2) && _cursor.isNull(_cursorIndexOfOwner_1) && _cursor.isNull(_cursorIndexOfProxy) && _cursor.isNull(_cursorIndexOfStaked) && _cursor.isNull(_cursorIndexOfLastVoteWeight) && _cursor.isNull(_cursorIndexOfProxiedVoteWeight) && _cursor.isNull(_cursorIndexOfIsProxy))) {
                            AccountVoterInfo _tmpVoterInfo;
                            AccountSelfDelegatedBandwidth _tmpSelfDelegatedBandwidth;
                            AccountTotalResources _tmpTotalResources;
                            AccountCpuLimit _tmpCpuLimit;
                            AccountNetLimit _tmpNetLimit;
                            String _tmpAccountName = _cursor.isNull(_cursorIndexOfAccountName) ? null : _cursor.getString(_cursorIndexOfAccountName);
                            int _tmpHeadBlockNum = _cursor.getInt(_cursorIndexOfHeadBlockNum);
                            String _tmpHeadBlockTime = _cursor.isNull(_cursorIndexOfHeadBlockTime) ? null : _cursor.getString(_cursorIndexOfHeadBlockTime);
                            int _tmp = _cursor.getInt(_cursorIndexOfPrivileged);
                            boolean _tmpPrivileged = _tmp != 0;
                            String _tmpLastCodeUpdate = _cursor.isNull(_cursorIndexOfLastCodeUpdate) ? null : _cursor.getString(_cursorIndexOfLastCodeUpdate);
                            String _tmpCreated = _cursor.isNull(_cursorIndexOfCreated) ? null : _cursor.getString(_cursorIndexOfCreated);
                            String _tmpCoreLiquidBalance = _cursor.isNull(_cursorIndexOfCoreLiquidBalance) ? null : _cursor.getString(_cursorIndexOfCoreLiquidBalance);
                            int _tmpRamQuota = _cursor.getInt(_cursorIndexOfRamQuota);
                            long _tmpNetWeight = _cursor.getLong(_cursorIndexOfNetWeight);
                            long _tmpCpuWeight = _cursor.getLong(_cursorIndexOfCpuWeight);
                            long _tmpRamUsage = _cursor.getLong(_cursorIndexOfRamUsage);
                            String _tmp_1 = _cursor.isNull(_cursorIndexOfPermissions) ? null : _cursor.getString(_cursorIndexOfPermissions);
                            List<AccountPermission> _tmpPermissions = EOSTypeConverters.stringToAccountPermissionList(_tmp_1);
                            if (!(_cursor.isNull(_cursorIndexOfUsed) && _cursor.isNull(_cursorIndexOfAvailable) && _cursor.isNull(_cursorIndexOfMax))) {
                                long _tmpUsed = _cursor.getLong(_cursorIndexOfUsed);
                                long _tmpAvailable = _cursor.getLong(_cursorIndexOfAvailable);
                                long _tmpMax = _cursor.getLong(_cursorIndexOfMax);
                                _tmpNetLimit = new AccountNetLimit(_tmpUsed, _tmpAvailable, _tmpMax);
                            } else {
                                _tmpNetLimit = null;
                            }
                            if (!(_cursor.isNull(_cursorIndexOfUsed_1) && _cursor.isNull(_cursorIndexOfAvailable_1) && _cursor.isNull(_cursorIndexOfMax_1))) {
                                long _tmpUsed_1 = _cursor.getLong(_cursorIndexOfUsed_1);
                                long _tmpAvailable_1 = _cursor.getLong(_cursorIndexOfAvailable_1);
                                long _tmpMax_1 = _cursor.getLong(_cursorIndexOfMax_1);
                                _tmpCpuLimit = new AccountCpuLimit(_tmpUsed_1, _tmpAvailable_1, _tmpMax_1);
                            } else {
                                _tmpCpuLimit = null;
                            }
                            if (!(_cursor.isNull(_cursorIndexOfOwner) && _cursor.isNull(_cursorIndexOfNetWeight_1) && _cursor.isNull(_cursorIndexOfCpuWeight_1) && _cursor.isNull(_cursorIndexOfRamBytes))) {
                                String _tmpOwner = _cursor.isNull(_cursorIndexOfOwner) ? null : _cursor.getString(_cursorIndexOfOwner);
                                String _tmpNetWeight_1 = _cursor.isNull(_cursorIndexOfNetWeight_1) ? null : _cursor.getString(_cursorIndexOfNetWeight_1);
                                String _tmpCpuWeight_1 = _cursor.isNull(_cursorIndexOfCpuWeight_1) ? null : _cursor.getString(_cursorIndexOfCpuWeight_1);
                                int _tmpRamBytes = _cursor.getInt(_cursorIndexOfRamBytes);
                                _tmpTotalResources = new AccountTotalResources(_tmpOwner, _tmpNetWeight_1, _tmpCpuWeight_1, _tmpRamBytes);
                            } else {
                                _tmpTotalResources = null;
                            }
                            if (!(_cursor.isNull(_cursorIndexOfFrom) && _cursor.isNull(_cursorIndexOfTo) && _cursor.isNull(_cursorIndexOfNetWeight_2) && _cursor.isNull(_cursorIndexOfCpuWeight_2))) {
                                String _tmpFrom = _cursor.isNull(_cursorIndexOfFrom) ? null : _cursor.getString(_cursorIndexOfFrom);
                                String _tmpTo = _cursor.isNull(_cursorIndexOfTo) ? null : _cursor.getString(_cursorIndexOfTo);
                                String _tmpNetWeight_2 = _cursor.isNull(_cursorIndexOfNetWeight_2) ? null : _cursor.getString(_cursorIndexOfNetWeight_2);
                                String _tmpCpuWeight_2 = _cursor.isNull(_cursorIndexOfCpuWeight_2) ? null : _cursor.getString(_cursorIndexOfCpuWeight_2);
                                _tmpSelfDelegatedBandwidth = new AccountSelfDelegatedBandwidth(_tmpFrom, _tmpTo, _tmpNetWeight_2, _tmpCpuWeight_2);
                            } else {
                                _tmpSelfDelegatedBandwidth = null;
                            }
                            if (!(_cursor.isNull(_cursorIndexOfOwner_1) && _cursor.isNull(_cursorIndexOfProxy) && _cursor.isNull(_cursorIndexOfStaked) && _cursor.isNull(_cursorIndexOfLastVoteWeight) && _cursor.isNull(_cursorIndexOfProxiedVoteWeight) && _cursor.isNull(_cursorIndexOfIsProxy))) {
                                String _tmpOwner_1 = _cursor.isNull(_cursorIndexOfOwner_1) ? null : _cursor.getString(_cursorIndexOfOwner_1);
                                String _tmpProxy = _cursor.isNull(_cursorIndexOfProxy) ? null : _cursor.getString(_cursorIndexOfProxy);
                                long _tmpStaked = _cursor.getLong(_cursorIndexOfStaked);
                                String _tmpLastVoteWeight = _cursor.isNull(_cursorIndexOfLastVoteWeight) ? null : _cursor.getString(_cursorIndexOfLastVoteWeight);
                                String _tmpProxiedVoteWeight = _cursor.isNull(_cursorIndexOfProxiedVoteWeight) ? null : _cursor.getString(_cursorIndexOfProxiedVoteWeight);
                                int _tmpIsProxy = _cursor.getInt(_cursorIndexOfIsProxy);
                                _tmpVoterInfo = new AccountVoterInfo(_tmpOwner_1, _tmpProxy, _tmpStaked, _tmpLastVoteWeight, _tmpProxiedVoteWeight, _tmpIsProxy);
                            } else {
                                _tmpVoterInfo = null;
                            }
                            _tmpRequester = new Account(_tmpAccountName, _tmpHeadBlockNum, _tmpHeadBlockTime, _tmpPrivileged, _tmpLastCodeUpdate, _tmpCreated, _tmpCoreLiquidBalance, _tmpRamQuota, _tmpNetWeight, _tmpCpuWeight, _tmpRamUsage, _tmpNetLimit, _tmpCpuLimit, _tmpPermissions, _tmpTotalResources, _tmpSelfDelegatedBandwidth, _tmpVoterInfo);
                            _tmpRequester.accountChainId = _cursor.isNull(_cursorIndexOfAccountChainId) ? null : _cursor.getString(_cursorIndexOfAccountChainId);
                            String _tmp_2 = _cursor.isNull(_cursorIndexOfAccountContact) ? null : _cursor.getString(_cursorIndexOfAccountContact);
                            _tmpRequester.accountContact = ProtonTypeConverters.stringToAccountContact(_tmp_2);
                            String _tmp_3 = _cursor.isNull(_cursorIndexOfVotersXPRInfo) ? null : _cursor.getString(_cursorIndexOfVotersXPRInfo);
                            _tmpRequester.votersXPRInfo = ProtonTypeConverters.stringToAccountVotersXPRInfo(_tmp_3);
                            String _tmp_4 = _cursor.isNull(_cursorIndexOfRefundsXPRInfo) ? null : _cursor.getString(_cursorIndexOfRefundsXPRInfo);
                            _tmpRequester.refundsXPRInfo = ProtonTypeConverters.stringToAccountRefundsXPRInfo(_tmp_4);
                        } else {
                            _tmpRequester = null;
                        }
                        _result = new ESRSession(_tmpId, _tmpSigner, _tmpCallbackUrl, _tmpReceiveKey, _tmpReceiveChannelUrl, _tmpCreatedAt, _tmpUpdatedAt, _tmpRequester);
                    } else {
                        _result = null;
                    }
                    ESRSession eSRSession = _result;
                    return eSRSession;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p1);
    }

    @Override
    public Object findAll(Continuation<? super List<ESRSession>> p0) {
        String _sql = "SELECT * FROM esrSession";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM esrSession", (int)0);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ESRSession>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ESRSession> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ESRSessionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfSigner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signer");
                    int _cursorIndexOfCallbackUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"callbackUrl");
                    int _cursorIndexOfReceiveKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"receiveKey");
                    int _cursorIndexOfReceiveChannelUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"receiveChannelUrl");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfAccountChainId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_accountChainId");
                    int _cursorIndexOfAccountContact = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_accountContact");
                    int _cursorIndexOfVotersXPRInfo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_votersXPRInfo");
                    int _cursorIndexOfRefundsXPRInfo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_refundsXPRInfo");
                    int _cursorIndexOfAccountName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_accountName");
                    int _cursorIndexOfHeadBlockNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_headBlockNum");
                    int _cursorIndexOfHeadBlockTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_headBlockTime");
                    int _cursorIndexOfPrivileged = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_privileged");
                    int _cursorIndexOfLastCodeUpdate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_lastCodeUpdate");
                    int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_created");
                    int _cursorIndexOfCoreLiquidBalance = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_coreLiquidBalance");
                    int _cursorIndexOfRamQuota = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_ramQuota");
                    int _cursorIndexOfNetWeight = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_netWeight");
                    int _cursorIndexOfCpuWeight = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_cpuWeight");
                    int _cursorIndexOfRamUsage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_ramUsage");
                    int _cursorIndexOfPermissions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_permissions");
                    int _cursorIndexOfUsed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_net_limit_used");
                    int _cursorIndexOfAvailable = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_net_limit_available");
                    int _cursorIndexOfMax = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_net_limit_max");
                    int _cursorIndexOfUsed_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_cpu_limit_used");
                    int _cursorIndexOfAvailable_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_cpu_limit_available");
                    int _cursorIndexOfMax_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_cpu_limit_max");
                    int _cursorIndexOfOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_total_resources_owner");
                    int _cursorIndexOfNetWeight_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_total_resources_netWeight");
                    int _cursorIndexOfCpuWeight_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_total_resources_cpuWeight");
                    int _cursorIndexOfRamBytes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_total_resources_ramBytes");
                    int _cursorIndexOfFrom = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_self_delegated_bandwidth_from");
                    int _cursorIndexOfTo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_self_delegated_bandwidth_to");
                    int _cursorIndexOfNetWeight_2 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_self_delegated_bandwidth_netWeight");
                    int _cursorIndexOfCpuWeight_2 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_self_delegated_bandwidth_cpuWeight");
                    int _cursorIndexOfOwner_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_voter_info_owner");
                    int _cursorIndexOfProxy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_voter_info_proxy");
                    int _cursorIndexOfStaked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_voter_info_staked");
                    int _cursorIndexOfLastVoteWeight = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_voter_info_lastVoteWeight");
                    int _cursorIndexOfProxiedVoteWeight = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_voter_info_proxiedVoteWeight");
                    int _cursorIndexOfIsProxy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requester_voter_info_isProxy");
                    ArrayList<ESRSession> _result = new ArrayList<ESRSession>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Account _tmpRequester;
                        String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                        String _tmpSigner = _cursor.isNull(_cursorIndexOfSigner) ? null : _cursor.getString(_cursorIndexOfSigner);
                        String _tmpCallbackUrl = _cursor.isNull(_cursorIndexOfCallbackUrl) ? null : _cursor.getString(_cursorIndexOfCallbackUrl);
                        String _tmpReceiveKey = _cursor.isNull(_cursorIndexOfReceiveKey) ? null : _cursor.getString(_cursorIndexOfReceiveKey);
                        String _tmpReceiveChannelUrl = _cursor.isNull(_cursorIndexOfReceiveChannelUrl) ? null : _cursor.getString(_cursorIndexOfReceiveChannelUrl);
                        long _tmpCreatedAt = _cursor.getLong(_cursorIndexOfCreatedAt);
                        long _tmpUpdatedAt = _cursor.getLong(_cursorIndexOfUpdatedAt);
                        if (!(_cursor.isNull(_cursorIndexOfAccountChainId) && _cursor.isNull(_cursorIndexOfAccountContact) && _cursor.isNull(_cursorIndexOfVotersXPRInfo) && _cursor.isNull(_cursorIndexOfRefundsXPRInfo) && _cursor.isNull(_cursorIndexOfAccountName) && _cursor.isNull(_cursorIndexOfHeadBlockNum) && _cursor.isNull(_cursorIndexOfHeadBlockTime) && _cursor.isNull(_cursorIndexOfPrivileged) && _cursor.isNull(_cursorIndexOfLastCodeUpdate) && _cursor.isNull(_cursorIndexOfCreated) && _cursor.isNull(_cursorIndexOfCoreLiquidBalance) && _cursor.isNull(_cursorIndexOfRamQuota) && _cursor.isNull(_cursorIndexOfNetWeight) && _cursor.isNull(_cursorIndexOfCpuWeight) && _cursor.isNull(_cursorIndexOfRamUsage) && _cursor.isNull(_cursorIndexOfPermissions) && _cursor.isNull(_cursorIndexOfUsed) && _cursor.isNull(_cursorIndexOfAvailable) && _cursor.isNull(_cursorIndexOfMax) && _cursor.isNull(_cursorIndexOfUsed_1) && _cursor.isNull(_cursorIndexOfAvailable_1) && _cursor.isNull(_cursorIndexOfMax_1) && _cursor.isNull(_cursorIndexOfOwner) && _cursor.isNull(_cursorIndexOfNetWeight_1) && _cursor.isNull(_cursorIndexOfCpuWeight_1) && _cursor.isNull(_cursorIndexOfRamBytes) && _cursor.isNull(_cursorIndexOfFrom) && _cursor.isNull(_cursorIndexOfTo) && _cursor.isNull(_cursorIndexOfNetWeight_2) && _cursor.isNull(_cursorIndexOfCpuWeight_2) && _cursor.isNull(_cursorIndexOfOwner_1) && _cursor.isNull(_cursorIndexOfProxy) && _cursor.isNull(_cursorIndexOfStaked) && _cursor.isNull(_cursorIndexOfLastVoteWeight) && _cursor.isNull(_cursorIndexOfProxiedVoteWeight) && _cursor.isNull(_cursorIndexOfIsProxy))) {
                            AccountVoterInfo _tmpVoterInfo;
                            AccountSelfDelegatedBandwidth _tmpSelfDelegatedBandwidth;
                            AccountTotalResources _tmpTotalResources;
                            AccountCpuLimit _tmpCpuLimit;
                            AccountNetLimit _tmpNetLimit;
                            String _tmpAccountName = _cursor.isNull(_cursorIndexOfAccountName) ? null : _cursor.getString(_cursorIndexOfAccountName);
                            int _tmpHeadBlockNum = _cursor.getInt(_cursorIndexOfHeadBlockNum);
                            String _tmpHeadBlockTime = _cursor.isNull(_cursorIndexOfHeadBlockTime) ? null : _cursor.getString(_cursorIndexOfHeadBlockTime);
                            int _tmp = _cursor.getInt(_cursorIndexOfPrivileged);
                            boolean _tmpPrivileged = _tmp != 0;
                            String _tmpLastCodeUpdate = _cursor.isNull(_cursorIndexOfLastCodeUpdate) ? null : _cursor.getString(_cursorIndexOfLastCodeUpdate);
                            String _tmpCreated = _cursor.isNull(_cursorIndexOfCreated) ? null : _cursor.getString(_cursorIndexOfCreated);
                            String _tmpCoreLiquidBalance = _cursor.isNull(_cursorIndexOfCoreLiquidBalance) ? null : _cursor.getString(_cursorIndexOfCoreLiquidBalance);
                            int _tmpRamQuota = _cursor.getInt(_cursorIndexOfRamQuota);
                            long _tmpNetWeight = _cursor.getLong(_cursorIndexOfNetWeight);
                            long _tmpCpuWeight = _cursor.getLong(_cursorIndexOfCpuWeight);
                            long _tmpRamUsage = _cursor.getLong(_cursorIndexOfRamUsage);
                            String _tmp_1 = _cursor.isNull(_cursorIndexOfPermissions) ? null : _cursor.getString(_cursorIndexOfPermissions);
                            List<AccountPermission> _tmpPermissions = EOSTypeConverters.stringToAccountPermissionList(_tmp_1);
                            if (!(_cursor.isNull(_cursorIndexOfUsed) && _cursor.isNull(_cursorIndexOfAvailable) && _cursor.isNull(_cursorIndexOfMax))) {
                                long _tmpUsed = _cursor.getLong(_cursorIndexOfUsed);
                                long _tmpAvailable = _cursor.getLong(_cursorIndexOfAvailable);
                                long _tmpMax = _cursor.getLong(_cursorIndexOfMax);
                                _tmpNetLimit = new AccountNetLimit(_tmpUsed, _tmpAvailable, _tmpMax);
                            } else {
                                _tmpNetLimit = null;
                            }
                            if (!(_cursor.isNull(_cursorIndexOfUsed_1) && _cursor.isNull(_cursorIndexOfAvailable_1) && _cursor.isNull(_cursorIndexOfMax_1))) {
                                long _tmpUsed_1 = _cursor.getLong(_cursorIndexOfUsed_1);
                                long _tmpAvailable_1 = _cursor.getLong(_cursorIndexOfAvailable_1);
                                long _tmpMax_1 = _cursor.getLong(_cursorIndexOfMax_1);
                                _tmpCpuLimit = new AccountCpuLimit(_tmpUsed_1, _tmpAvailable_1, _tmpMax_1);
                            } else {
                                _tmpCpuLimit = null;
                            }
                            if (!(_cursor.isNull(_cursorIndexOfOwner) && _cursor.isNull(_cursorIndexOfNetWeight_1) && _cursor.isNull(_cursorIndexOfCpuWeight_1) && _cursor.isNull(_cursorIndexOfRamBytes))) {
                                String _tmpOwner = _cursor.isNull(_cursorIndexOfOwner) ? null : _cursor.getString(_cursorIndexOfOwner);
                                String _tmpNetWeight_1 = _cursor.isNull(_cursorIndexOfNetWeight_1) ? null : _cursor.getString(_cursorIndexOfNetWeight_1);
                                String _tmpCpuWeight_1 = _cursor.isNull(_cursorIndexOfCpuWeight_1) ? null : _cursor.getString(_cursorIndexOfCpuWeight_1);
                                int _tmpRamBytes = _cursor.getInt(_cursorIndexOfRamBytes);
                                _tmpTotalResources = new AccountTotalResources(_tmpOwner, _tmpNetWeight_1, _tmpCpuWeight_1, _tmpRamBytes);
                            } else {
                                _tmpTotalResources = null;
                            }
                            if (!(_cursor.isNull(_cursorIndexOfFrom) && _cursor.isNull(_cursorIndexOfTo) && _cursor.isNull(_cursorIndexOfNetWeight_2) && _cursor.isNull(_cursorIndexOfCpuWeight_2))) {
                                String _tmpFrom = _cursor.isNull(_cursorIndexOfFrom) ? null : _cursor.getString(_cursorIndexOfFrom);
                                String _tmpTo = _cursor.isNull(_cursorIndexOfTo) ? null : _cursor.getString(_cursorIndexOfTo);
                                String _tmpNetWeight_2 = _cursor.isNull(_cursorIndexOfNetWeight_2) ? null : _cursor.getString(_cursorIndexOfNetWeight_2);
                                String _tmpCpuWeight_2 = _cursor.isNull(_cursorIndexOfCpuWeight_2) ? null : _cursor.getString(_cursorIndexOfCpuWeight_2);
                                _tmpSelfDelegatedBandwidth = new AccountSelfDelegatedBandwidth(_tmpFrom, _tmpTo, _tmpNetWeight_2, _tmpCpuWeight_2);
                            } else {
                                _tmpSelfDelegatedBandwidth = null;
                            }
                            if (!(_cursor.isNull(_cursorIndexOfOwner_1) && _cursor.isNull(_cursorIndexOfProxy) && _cursor.isNull(_cursorIndexOfStaked) && _cursor.isNull(_cursorIndexOfLastVoteWeight) && _cursor.isNull(_cursorIndexOfProxiedVoteWeight) && _cursor.isNull(_cursorIndexOfIsProxy))) {
                                String _tmpOwner_1 = _cursor.isNull(_cursorIndexOfOwner_1) ? null : _cursor.getString(_cursorIndexOfOwner_1);
                                String _tmpProxy = _cursor.isNull(_cursorIndexOfProxy) ? null : _cursor.getString(_cursorIndexOfProxy);
                                long _tmpStaked = _cursor.getLong(_cursorIndexOfStaked);
                                String _tmpLastVoteWeight = _cursor.isNull(_cursorIndexOfLastVoteWeight) ? null : _cursor.getString(_cursorIndexOfLastVoteWeight);
                                String _tmpProxiedVoteWeight = _cursor.isNull(_cursorIndexOfProxiedVoteWeight) ? null : _cursor.getString(_cursorIndexOfProxiedVoteWeight);
                                int _tmpIsProxy = _cursor.getInt(_cursorIndexOfIsProxy);
                                _tmpVoterInfo = new AccountVoterInfo(_tmpOwner_1, _tmpProxy, _tmpStaked, _tmpLastVoteWeight, _tmpProxiedVoteWeight, _tmpIsProxy);
                            } else {
                                _tmpVoterInfo = null;
                            }
                            _tmpRequester = new Account(_tmpAccountName, _tmpHeadBlockNum, _tmpHeadBlockTime, _tmpPrivileged, _tmpLastCodeUpdate, _tmpCreated, _tmpCoreLiquidBalance, _tmpRamQuota, _tmpNetWeight, _tmpCpuWeight, _tmpRamUsage, _tmpNetLimit, _tmpCpuLimit, _tmpPermissions, _tmpTotalResources, _tmpSelfDelegatedBandwidth, _tmpVoterInfo);
                            _tmpRequester.accountChainId = _cursor.isNull(_cursorIndexOfAccountChainId) ? null : _cursor.getString(_cursorIndexOfAccountChainId);
                            String _tmp_2 = _cursor.isNull(_cursorIndexOfAccountContact) ? null : _cursor.getString(_cursorIndexOfAccountContact);
                            _tmpRequester.accountContact = ProtonTypeConverters.stringToAccountContact(_tmp_2);
                            String _tmp_3 = _cursor.isNull(_cursorIndexOfVotersXPRInfo) ? null : _cursor.getString(_cursorIndexOfVotersXPRInfo);
                            _tmpRequester.votersXPRInfo = ProtonTypeConverters.stringToAccountVotersXPRInfo(_tmp_3);
                            String _tmp_4 = _cursor.isNull(_cursorIndexOfRefundsXPRInfo) ? null : _cursor.getString(_cursorIndexOfRefundsXPRInfo);
                            _tmpRequester.refundsXPRInfo = ProtonTypeConverters.stringToAccountRefundsXPRInfo(_tmp_4);
                        } else {
                            _tmpRequester = null;
                        }
                        ESRSession _item = new ESRSession(_tmpId, _tmpSigner, _tmpCallbackUrl, _tmpReceiveKey, _tmpReceiveChannelUrl, _tmpCreatedAt, _tmpUpdatedAt, _tmpRequester);
                        _result.add(_item);
                    }
                    ArrayList<ESRSession> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p0);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

