/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.db;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.metallicus.protonsdk.db.ChainProviderDao;
import com.metallicus.protonsdk.db.DefaultTypeConverters;
import com.metallicus.protonsdk.db.ProtonTypeConverters;
import com.metallicus.protonsdk.model.ChainProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class ChainProviderDao_Impl
implements ChainProviderDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ChainProvider> __insertionAdapterOfChainProvider;
    private final SharedSQLiteStatement __preparedStmtOfUpdateChainUrl;
    private final SharedSQLiteStatement __preparedStmtOfUpdateHyperionHistoryUrl;
    private final SharedSQLiteStatement __preparedStmtOfRemoveAll;

    public ChainProviderDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfChainProvider = new EntityInsertionAdapter<ChainProvider>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `ChainProvider` (`protonChainUrl`,`kycProviders`,`chainUrlStats`,`hyperionHistoryUrlStats`,`chainId`,`name`,`description`,`iconUrl`,`isTestnet`,`chainUrl`,`hyperionHistoryUrl`,`explorerName`,`explorerUrl`,`resourceTokenSymbol`,`resourceTokenContract`,`systemTokenSymbol`,`systemTokenContract`,`createAccountPath`,`updateAccountAvatarPath`,`updateAccountNamePath`,`exchangeRatePath`,`chainUrls`,`hyperionHistoryUrls`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ChainProvider value) {
                if (value.protonChainUrl == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.protonChainUrl);
                }
                String _tmp = ProtonTypeConverters.kycProviderListToString(value.kycProviders);
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = ProtonTypeConverters.chainUrlInfoListToString(value.chainUrlStats);
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                String _tmp_2 = ProtonTypeConverters.chainUrlInfoListToString(value.hyperionHistoryUrlStats);
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
                if (value.getChainId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getChainId());
                }
                if (value.getName() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getName());
                }
                if (value.getDescription() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getDescription());
                }
                if (value.getIconUrl() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getIconUrl());
                }
                int _tmp_3 = value.isTestnet() ? 1 : 0;
                stmt.bindLong(9, (long)_tmp_3);
                if (value.getChainUrl() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getChainUrl());
                }
                if (value.getHyperionHistoryUrl() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getHyperionHistoryUrl());
                }
                if (value.getExplorerName() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getExplorerName());
                }
                if (value.getExplorerUrl() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getExplorerUrl());
                }
                if (value.getResourceTokenSymbol() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getResourceTokenSymbol());
                }
                if (value.getResourceTokenContract() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, value.getResourceTokenContract());
                }
                if (value.getSystemTokenSymbol() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, value.getSystemTokenSymbol());
                }
                if (value.getSystemTokenContract() == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, value.getSystemTokenContract());
                }
                if (value.getCreateAccountPath() == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, value.getCreateAccountPath());
                }
                if (value.getUpdateAccountAvatarPath() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, value.getUpdateAccountAvatarPath());
                }
                if (value.getUpdateAccountNamePath() == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, value.getUpdateAccountNamePath());
                }
                if (value.getExchangeRatePath() == null) {
                    stmt.bindNull(21);
                } else {
                    stmt.bindString(21, value.getExchangeRatePath());
                }
                String _tmp_4 = DefaultTypeConverters.stringListToString(value.getChainUrls());
                if (_tmp_4 == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, _tmp_4);
                }
                String _tmp_5 = DefaultTypeConverters.stringListToString(value.getHyperionHistoryUrls());
                if (_tmp_5 == null) {
                    stmt.bindNull(23);
                } else {
                    stmt.bindString(23, _tmp_5);
                }
            }
        };
        this.__preparedStmtOfUpdateChainUrl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE chainProvider SET chainUrl = ? WHERE chainId = ?";
                return "UPDATE chainProvider SET chainUrl = ? WHERE chainId = ?";
            }
        };
        this.__preparedStmtOfUpdateHyperionHistoryUrl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE chainProvider SET hyperionHistoryUrl = ? WHERE chainId = ?";
                return "UPDATE chainProvider SET hyperionHistoryUrl = ? WHERE chainId = ?";
            }
        };
        this.__preparedStmtOfRemoveAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM chainProvider";
                return "DELETE FROM chainProvider";
            }
        };
    }

    @Override
    public Object insert(final ChainProvider chainProvider, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ChainProviderDao_Impl.this.__db.beginTransaction();
                try {
                    ChainProviderDao_Impl.this.__insertionAdapterOfChainProvider.insert((Object)chainProvider);
                    ChainProviderDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ChainProviderDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object updateChainUrl(final String chainId, final String chainUrl, Continuation<? super Unit> p2) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ChainProviderDao_Impl.this.__preparedStmtOfUpdateChainUrl.acquire();
                int _argIndex = 1;
                if (chainUrl == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, chainUrl);
                }
                _argIndex = 2;
                if (chainId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, chainId);
                }
                ChainProviderDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ChainProviderDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ChainProviderDao_Impl.this.__db.endTransaction();
                    ChainProviderDao_Impl.this.__preparedStmtOfUpdateChainUrl.release(_stmt);
                }
            }
        }, p2);
    }

    @Override
    public Object updateHyperionHistoryUrl(final String chainId, final String hyperionHistoryUrl, Continuation<? super Unit> p2) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ChainProviderDao_Impl.this.__preparedStmtOfUpdateHyperionHistoryUrl.acquire();
                int _argIndex = 1;
                if (hyperionHistoryUrl == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, hyperionHistoryUrl);
                }
                _argIndex = 2;
                if (chainId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, chainId);
                }
                ChainProviderDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ChainProviderDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ChainProviderDao_Impl.this.__db.endTransaction();
                    ChainProviderDao_Impl.this.__preparedStmtOfUpdateHyperionHistoryUrl.release(_stmt);
                }
            }
        }, p2);
    }

    @Override
    public Object removeAll(Continuation<? super Unit> p0) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ChainProviderDao_Impl.this.__preparedStmtOfRemoveAll.acquire();
                ChainProviderDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ChainProviderDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ChainProviderDao_Impl.this.__db.endTransaction();
                    ChainProviderDao_Impl.this.__preparedStmtOfRemoveAll.release(_stmt);
                }
            }
        }, p0);
    }

    @Override
    public Object findById(String id, Continuation<? super ChainProvider> p1) {
        String _sql = "SELECT * FROM chainProvider WHERE chainId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM chainProvider WHERE chainId = ?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ChainProvider>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ChainProvider call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ChainProviderDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    ChainProvider _result;
                    int _cursorIndexOfProtonChainUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"protonChainUrl");
                    int _cursorIndexOfKycProviders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kycProviders");
                    int _cursorIndexOfChainUrlStats = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"chainUrlStats");
                    int _cursorIndexOfHyperionHistoryUrlStats = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hyperionHistoryUrlStats");
                    int _cursorIndexOfChainId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"chainId");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfIconUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iconUrl");
                    int _cursorIndexOfIsTestnet = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isTestnet");
                    int _cursorIndexOfChainUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"chainUrl");
                    int _cursorIndexOfHyperionHistoryUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hyperionHistoryUrl");
                    int _cursorIndexOfExplorerName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"explorerName");
                    int _cursorIndexOfExplorerUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"explorerUrl");
                    int _cursorIndexOfResourceTokenSymbol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resourceTokenSymbol");
                    int _cursorIndexOfResourceTokenContract = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resourceTokenContract");
                    int _cursorIndexOfSystemTokenSymbol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"systemTokenSymbol");
                    int _cursorIndexOfSystemTokenContract = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"systemTokenContract");
                    int _cursorIndexOfCreateAccountPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createAccountPath");
                    int _cursorIndexOfUpdateAccountAvatarPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updateAccountAvatarPath");
                    int _cursorIndexOfUpdateAccountNamePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updateAccountNamePath");
                    int _cursorIndexOfExchangeRatePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"exchangeRatePath");
                    int _cursorIndexOfChainUrls = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"chainUrls");
                    int _cursorIndexOfHyperionHistoryUrls = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hyperionHistoryUrls");
                    if (_cursor.moveToFirst()) {
                        String _tmpChainId = _cursor.isNull(_cursorIndexOfChainId) ? null : _cursor.getString(_cursorIndexOfChainId);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        String _tmpIconUrl = _cursor.isNull(_cursorIndexOfIconUrl) ? null : _cursor.getString(_cursorIndexOfIconUrl);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsTestnet);
                        boolean _tmpIsTestnet = _tmp != 0;
                        String _tmpChainUrl = _cursor.isNull(_cursorIndexOfChainUrl) ? null : _cursor.getString(_cursorIndexOfChainUrl);
                        String _tmpHyperionHistoryUrl = _cursor.isNull(_cursorIndexOfHyperionHistoryUrl) ? null : _cursor.getString(_cursorIndexOfHyperionHistoryUrl);
                        String _tmpExplorerName = _cursor.isNull(_cursorIndexOfExplorerName) ? null : _cursor.getString(_cursorIndexOfExplorerName);
                        String _tmpExplorerUrl = _cursor.isNull(_cursorIndexOfExplorerUrl) ? null : _cursor.getString(_cursorIndexOfExplorerUrl);
                        String _tmpResourceTokenSymbol = _cursor.isNull(_cursorIndexOfResourceTokenSymbol) ? null : _cursor.getString(_cursorIndexOfResourceTokenSymbol);
                        String _tmpResourceTokenContract = _cursor.isNull(_cursorIndexOfResourceTokenContract) ? null : _cursor.getString(_cursorIndexOfResourceTokenContract);
                        String _tmpSystemTokenSymbol = _cursor.isNull(_cursorIndexOfSystemTokenSymbol) ? null : _cursor.getString(_cursorIndexOfSystemTokenSymbol);
                        String _tmpSystemTokenContract = _cursor.isNull(_cursorIndexOfSystemTokenContract) ? null : _cursor.getString(_cursorIndexOfSystemTokenContract);
                        String _tmpCreateAccountPath = _cursor.isNull(_cursorIndexOfCreateAccountPath) ? null : _cursor.getString(_cursorIndexOfCreateAccountPath);
                        String _tmpUpdateAccountAvatarPath = _cursor.isNull(_cursorIndexOfUpdateAccountAvatarPath) ? null : _cursor.getString(_cursorIndexOfUpdateAccountAvatarPath);
                        String _tmpUpdateAccountNamePath = _cursor.isNull(_cursorIndexOfUpdateAccountNamePath) ? null : _cursor.getString(_cursorIndexOfUpdateAccountNamePath);
                        String _tmpExchangeRatePath = _cursor.isNull(_cursorIndexOfExchangeRatePath) ? null : _cursor.getString(_cursorIndexOfExchangeRatePath);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfChainUrls) ? null : _cursor.getString(_cursorIndexOfChainUrls);
                        List<String> _tmpChainUrls = DefaultTypeConverters.stringToStringList(_tmp_1);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfHyperionHistoryUrls) ? null : _cursor.getString(_cursorIndexOfHyperionHistoryUrls);
                        List<String> _tmpHyperionHistoryUrls = DefaultTypeConverters.stringToStringList(_tmp_2);
                        _result = new ChainProvider(_tmpChainId, _tmpName, _tmpDescription, _tmpIconUrl, _tmpIsTestnet, _tmpChainUrl, _tmpHyperionHistoryUrl, _tmpExplorerName, _tmpExplorerUrl, _tmpResourceTokenSymbol, _tmpResourceTokenContract, _tmpSystemTokenSymbol, _tmpSystemTokenContract, _tmpCreateAccountPath, _tmpUpdateAccountAvatarPath, _tmpUpdateAccountNamePath, _tmpExchangeRatePath, _tmpChainUrls, _tmpHyperionHistoryUrls);
                        _result.protonChainUrl = _cursor.isNull(_cursorIndexOfProtonChainUrl) ? null : _cursor.getString(_cursorIndexOfProtonChainUrl);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfKycProviders) ? null : _cursor.getString(_cursorIndexOfKycProviders);
                        _result.kycProviders = ProtonTypeConverters.stringToKYCProviderList(_tmp_3);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfChainUrlStats) ? null : _cursor.getString(_cursorIndexOfChainUrlStats);
                        _result.chainUrlStats = ProtonTypeConverters.stringToChainUrlInfoList(_tmp_4);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfHyperionHistoryUrlStats) ? null : _cursor.getString(_cursorIndexOfHyperionHistoryUrlStats);
                        _result.hyperionHistoryUrlStats = ProtonTypeConverters.stringToChainUrlInfoList(_tmp_5);
                    } else {
                        _result = null;
                    }
                    ChainProvider chainProvider = _result;
                    return chainProvider;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p1);
    }

    @Override
    public Object findAll(Continuation<? super List<ChainProvider>> p0) {
        String _sql = "SELECT * FROM chainProvider";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM chainProvider", (int)0);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<ChainProvider>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ChainProvider> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ChainProviderDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfProtonChainUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"protonChainUrl");
                    int _cursorIndexOfKycProviders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kycProviders");
                    int _cursorIndexOfChainUrlStats = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"chainUrlStats");
                    int _cursorIndexOfHyperionHistoryUrlStats = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hyperionHistoryUrlStats");
                    int _cursorIndexOfChainId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"chainId");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfIconUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iconUrl");
                    int _cursorIndexOfIsTestnet = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isTestnet");
                    int _cursorIndexOfChainUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"chainUrl");
                    int _cursorIndexOfHyperionHistoryUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hyperionHistoryUrl");
                    int _cursorIndexOfExplorerName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"explorerName");
                    int _cursorIndexOfExplorerUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"explorerUrl");
                    int _cursorIndexOfResourceTokenSymbol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resourceTokenSymbol");
                    int _cursorIndexOfResourceTokenContract = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resourceTokenContract");
                    int _cursorIndexOfSystemTokenSymbol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"systemTokenSymbol");
                    int _cursorIndexOfSystemTokenContract = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"systemTokenContract");
                    int _cursorIndexOfCreateAccountPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createAccountPath");
                    int _cursorIndexOfUpdateAccountAvatarPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updateAccountAvatarPath");
                    int _cursorIndexOfUpdateAccountNamePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updateAccountNamePath");
                    int _cursorIndexOfExchangeRatePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"exchangeRatePath");
                    int _cursorIndexOfChainUrls = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"chainUrls");
                    int _cursorIndexOfHyperionHistoryUrls = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hyperionHistoryUrls");
                    ArrayList<ChainProvider> _result = new ArrayList<ChainProvider>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpChainId = _cursor.isNull(_cursorIndexOfChainId) ? null : _cursor.getString(_cursorIndexOfChainId);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        String _tmpIconUrl = _cursor.isNull(_cursorIndexOfIconUrl) ? null : _cursor.getString(_cursorIndexOfIconUrl);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsTestnet);
                        boolean _tmpIsTestnet = _tmp != 0;
                        String _tmpChainUrl = _cursor.isNull(_cursorIndexOfChainUrl) ? null : _cursor.getString(_cursorIndexOfChainUrl);
                        String _tmpHyperionHistoryUrl = _cursor.isNull(_cursorIndexOfHyperionHistoryUrl) ? null : _cursor.getString(_cursorIndexOfHyperionHistoryUrl);
                        String _tmpExplorerName = _cursor.isNull(_cursorIndexOfExplorerName) ? null : _cursor.getString(_cursorIndexOfExplorerName);
                        String _tmpExplorerUrl = _cursor.isNull(_cursorIndexOfExplorerUrl) ? null : _cursor.getString(_cursorIndexOfExplorerUrl);
                        String _tmpResourceTokenSymbol = _cursor.isNull(_cursorIndexOfResourceTokenSymbol) ? null : _cursor.getString(_cursorIndexOfResourceTokenSymbol);
                        String _tmpResourceTokenContract = _cursor.isNull(_cursorIndexOfResourceTokenContract) ? null : _cursor.getString(_cursorIndexOfResourceTokenContract);
                        String _tmpSystemTokenSymbol = _cursor.isNull(_cursorIndexOfSystemTokenSymbol) ? null : _cursor.getString(_cursorIndexOfSystemTokenSymbol);
                        String _tmpSystemTokenContract = _cursor.isNull(_cursorIndexOfSystemTokenContract) ? null : _cursor.getString(_cursorIndexOfSystemTokenContract);
                        String _tmpCreateAccountPath = _cursor.isNull(_cursorIndexOfCreateAccountPath) ? null : _cursor.getString(_cursorIndexOfCreateAccountPath);
                        String _tmpUpdateAccountAvatarPath = _cursor.isNull(_cursorIndexOfUpdateAccountAvatarPath) ? null : _cursor.getString(_cursorIndexOfUpdateAccountAvatarPath);
                        String _tmpUpdateAccountNamePath = _cursor.isNull(_cursorIndexOfUpdateAccountNamePath) ? null : _cursor.getString(_cursorIndexOfUpdateAccountNamePath);
                        String _tmpExchangeRatePath = _cursor.isNull(_cursorIndexOfExchangeRatePath) ? null : _cursor.getString(_cursorIndexOfExchangeRatePath);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfChainUrls) ? null : _cursor.getString(_cursorIndexOfChainUrls);
                        List<String> _tmpChainUrls = DefaultTypeConverters.stringToStringList(_tmp_1);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfHyperionHistoryUrls) ? null : _cursor.getString(_cursorIndexOfHyperionHistoryUrls);
                        List<String> _tmpHyperionHistoryUrls = DefaultTypeConverters.stringToStringList(_tmp_2);
                        ChainProvider _item = new ChainProvider(_tmpChainId, _tmpName, _tmpDescription, _tmpIconUrl, _tmpIsTestnet, _tmpChainUrl, _tmpHyperionHistoryUrl, _tmpExplorerName, _tmpExplorerUrl, _tmpResourceTokenSymbol, _tmpResourceTokenContract, _tmpSystemTokenSymbol, _tmpSystemTokenContract, _tmpCreateAccountPath, _tmpUpdateAccountAvatarPath, _tmpUpdateAccountNamePath, _tmpExchangeRatePath, _tmpChainUrls, _tmpHyperionHistoryUrls);
                        _item.protonChainUrl = _cursor.isNull(_cursorIndexOfProtonChainUrl) ? null : _cursor.getString(_cursorIndexOfProtonChainUrl);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfKycProviders) ? null : _cursor.getString(_cursorIndexOfKycProviders);
                        _item.kycProviders = ProtonTypeConverters.stringToKYCProviderList(_tmp_3);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfChainUrlStats) ? null : _cursor.getString(_cursorIndexOfChainUrlStats);
                        _item.chainUrlStats = ProtonTypeConverters.stringToChainUrlInfoList(_tmp_4);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfHyperionHistoryUrlStats) ? null : _cursor.getString(_cursorIndexOfHyperionHistoryUrlStats);
                        _item.hyperionHistoryUrlStats = ProtonTypeConverters.stringToChainUrlInfoList(_tmp_5);
                        _result.add(_item);
                    }
                    ArrayList<ChainProvider> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p0);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

