/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.db;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.collection.ArrayMap;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.metallicus.protonsdk.db.AccountDao;
import com.metallicus.protonsdk.db.DefaultTypeConverters;
import com.metallicus.protonsdk.db.EOSTypeConverters;
import com.metallicus.protonsdk.db.ProtonTypeConverters;
import com.metallicus.protonsdk.model.Account;
import com.metallicus.protonsdk.model.AccountCpuLimit;
import com.metallicus.protonsdk.model.AccountNetLimit;
import com.metallicus.protonsdk.model.AccountPermission;
import com.metallicus.protonsdk.model.AccountSelfDelegatedBandwidth;
import com.metallicus.protonsdk.model.AccountTotalResources;
import com.metallicus.protonsdk.model.AccountVoterInfo;
import com.metallicus.protonsdk.model.ChainAccount;
import com.metallicus.protonsdk.model.ChainProvider;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class AccountDao_Impl
implements AccountDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Account> __insertionAdapterOfAccount;
    private final EntityDeletionOrUpdateAdapter<Account> __updateAdapterOfAccount;
    private final SharedSQLiteStatement __preparedStmtOfRemoveAll;

    public AccountDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfAccount = new EntityInsertionAdapter<Account>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Account` (`accountChainId`,`accountContact`,`votersXPRInfo`,`refundsXPRInfo`,`accountName`,`headBlockNum`,`headBlockTime`,`privileged`,`lastCodeUpdate`,`created`,`coreLiquidBalance`,`ramQuota`,`netWeight`,`cpuWeight`,`ramUsage`,`permissions`,`net_limit_used`,`net_limit_available`,`net_limit_max`,`cpu_limit_used`,`cpu_limit_available`,`cpu_limit_max`,`total_resources_owner`,`total_resources_netWeight`,`total_resources_cpuWeight`,`total_resources_ramBytes`,`self_delegated_bandwidth_from`,`self_delegated_bandwidth_to`,`self_delegated_bandwidth_netWeight`,`self_delegated_bandwidth_cpuWeight`,`voter_info_owner`,`voter_info_proxy`,`voter_info_staked`,`voter_info_lastVoteWeight`,`voter_info_proxiedVoteWeight`,`voter_info_isProxy`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Account value) {
                if (value.accountChainId == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.accountChainId);
                }
                String _tmp = ProtonTypeConverters.accountContactToString(value.accountContact);
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = ProtonTypeConverters.accountVotersXPRInfoToString(value.votersXPRInfo);
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                String _tmp_2 = ProtonTypeConverters.accountRefundsXPRInfoToString(value.refundsXPRInfo);
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
                if (value.getAccountName() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getAccountName());
                }
                stmt.bindLong(6, (long)value.getHeadBlockNum());
                if (value.getHeadBlockTime() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getHeadBlockTime());
                }
                int _tmp_3 = value.getPrivileged() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_3);
                if (value.getLastCodeUpdate() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getLastCodeUpdate());
                }
                if (value.getCreated() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getCreated());
                }
                if (value.getCoreLiquidBalance() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getCoreLiquidBalance());
                }
                stmt.bindLong(12, (long)value.getRamQuota());
                stmt.bindLong(13, value.getNetWeight());
                stmt.bindLong(14, value.getCpuWeight());
                stmt.bindLong(15, value.getRamUsage());
                String _tmp_4 = EOSTypeConverters.accountPermissionListToString(value.getPermissions());
                if (_tmp_4 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_4);
                }
                AccountNetLimit _tmpNetLimit = value.getNetLimit();
                if (_tmpNetLimit != null) {
                    stmt.bindLong(17, _tmpNetLimit.getUsed());
                    stmt.bindLong(18, _tmpNetLimit.getAvailable());
                    stmt.bindLong(19, _tmpNetLimit.getMax());
                } else {
                    stmt.bindNull(17);
                    stmt.bindNull(18);
                    stmt.bindNull(19);
                }
                AccountCpuLimit _tmpCpuLimit = value.getCpuLimit();
                if (_tmpCpuLimit != null) {
                    stmt.bindLong(20, _tmpCpuLimit.getUsed());
                    stmt.bindLong(21, _tmpCpuLimit.getAvailable());
                    stmt.bindLong(22, _tmpCpuLimit.getMax());
                } else {
                    stmt.bindNull(20);
                    stmt.bindNull(21);
                    stmt.bindNull(22);
                }
                AccountTotalResources _tmpTotalResources = value.getTotalResources();
                if (_tmpTotalResources != null) {
                    if (_tmpTotalResources.getOwner() == null) {
                        stmt.bindNull(23);
                    } else {
                        stmt.bindString(23, _tmpTotalResources.getOwner());
                    }
                    if (_tmpTotalResources.getNetWeight() == null) {
                        stmt.bindNull(24);
                    } else {
                        stmt.bindString(24, _tmpTotalResources.getNetWeight());
                    }
                    if (_tmpTotalResources.getCpuWeight() == null) {
                        stmt.bindNull(25);
                    } else {
                        stmt.bindString(25, _tmpTotalResources.getCpuWeight());
                    }
                    stmt.bindLong(26, (long)_tmpTotalResources.getRamBytes());
                } else {
                    stmt.bindNull(23);
                    stmt.bindNull(24);
                    stmt.bindNull(25);
                    stmt.bindNull(26);
                }
                AccountSelfDelegatedBandwidth _tmpSelfDelegatedBandwidth = value.getSelfDelegatedBandwidth();
                if (_tmpSelfDelegatedBandwidth != null) {
                    if (_tmpSelfDelegatedBandwidth.getFrom() == null) {
                        stmt.bindNull(27);
                    } else {
                        stmt.bindString(27, _tmpSelfDelegatedBandwidth.getFrom());
                    }
                    if (_tmpSelfDelegatedBandwidth.getTo() == null) {
                        stmt.bindNull(28);
                    } else {
                        stmt.bindString(28, _tmpSelfDelegatedBandwidth.getTo());
                    }
                    if (_tmpSelfDelegatedBandwidth.getNetWeight() == null) {
                        stmt.bindNull(29);
                    } else {
                        stmt.bindString(29, _tmpSelfDelegatedBandwidth.getNetWeight());
                    }
                    if (_tmpSelfDelegatedBandwidth.getCpuWeight() == null) {
                        stmt.bindNull(30);
                    } else {
                        stmt.bindString(30, _tmpSelfDelegatedBandwidth.getCpuWeight());
                    }
                } else {
                    stmt.bindNull(27);
                    stmt.bindNull(28);
                    stmt.bindNull(29);
                    stmt.bindNull(30);
                }
                AccountVoterInfo _tmpVoterInfo = value.getVoterInfo();
                if (_tmpVoterInfo != null) {
                    if (_tmpVoterInfo.getOwner() == null) {
                        stmt.bindNull(31);
                    } else {
                        stmt.bindString(31, _tmpVoterInfo.getOwner());
                    }
                    if (_tmpVoterInfo.getProxy() == null) {
                        stmt.bindNull(32);
                    } else {
                        stmt.bindString(32, _tmpVoterInfo.getProxy());
                    }
                    stmt.bindLong(33, _tmpVoterInfo.getStaked());
                    if (_tmpVoterInfo.getLastVoteWeight() == null) {
                        stmt.bindNull(34);
                    } else {
                        stmt.bindString(34, _tmpVoterInfo.getLastVoteWeight());
                    }
                    if (_tmpVoterInfo.getProxiedVoteWeight() == null) {
                        stmt.bindNull(35);
                    } else {
                        stmt.bindString(35, _tmpVoterInfo.getProxiedVoteWeight());
                    }
                    stmt.bindLong(36, (long)_tmpVoterInfo.isProxy());
                } else {
                    stmt.bindNull(31);
                    stmt.bindNull(32);
                    stmt.bindNull(33);
                    stmt.bindNull(34);
                    stmt.bindNull(35);
                    stmt.bindNull(36);
                }
            }
        };
        this.__updateAdapterOfAccount = new EntityDeletionOrUpdateAdapter<Account>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `Account` SET `accountChainId` = ?,`accountContact` = ?,`votersXPRInfo` = ?,`refundsXPRInfo` = ?,`accountName` = ?,`headBlockNum` = ?,`headBlockTime` = ?,`privileged` = ?,`lastCodeUpdate` = ?,`created` = ?,`coreLiquidBalance` = ?,`ramQuota` = ?,`netWeight` = ?,`cpuWeight` = ?,`ramUsage` = ?,`permissions` = ?,`net_limit_used` = ?,`net_limit_available` = ?,`net_limit_max` = ?,`cpu_limit_used` = ?,`cpu_limit_available` = ?,`cpu_limit_max` = ?,`total_resources_owner` = ?,`total_resources_netWeight` = ?,`total_resources_cpuWeight` = ?,`total_resources_ramBytes` = ?,`self_delegated_bandwidth_from` = ?,`self_delegated_bandwidth_to` = ?,`self_delegated_bandwidth_netWeight` = ?,`self_delegated_bandwidth_cpuWeight` = ?,`voter_info_owner` = ?,`voter_info_proxy` = ?,`voter_info_staked` = ?,`voter_info_lastVoteWeight` = ?,`voter_info_proxiedVoteWeight` = ?,`voter_info_isProxy` = ? WHERE `accountName` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Account value) {
                if (value.accountChainId == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.accountChainId);
                }
                String _tmp = ProtonTypeConverters.accountContactToString(value.accountContact);
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = ProtonTypeConverters.accountVotersXPRInfoToString(value.votersXPRInfo);
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                String _tmp_2 = ProtonTypeConverters.accountRefundsXPRInfoToString(value.refundsXPRInfo);
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
                if (value.getAccountName() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getAccountName());
                }
                stmt.bindLong(6, (long)value.getHeadBlockNum());
                if (value.getHeadBlockTime() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getHeadBlockTime());
                }
                int _tmp_3 = value.getPrivileged() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_3);
                if (value.getLastCodeUpdate() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getLastCodeUpdate());
                }
                if (value.getCreated() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getCreated());
                }
                if (value.getCoreLiquidBalance() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getCoreLiquidBalance());
                }
                stmt.bindLong(12, (long)value.getRamQuota());
                stmt.bindLong(13, value.getNetWeight());
                stmt.bindLong(14, value.getCpuWeight());
                stmt.bindLong(15, value.getRamUsage());
                String _tmp_4 = EOSTypeConverters.accountPermissionListToString(value.getPermissions());
                if (_tmp_4 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_4);
                }
                AccountNetLimit _tmpNetLimit = value.getNetLimit();
                if (_tmpNetLimit != null) {
                    stmt.bindLong(17, _tmpNetLimit.getUsed());
                    stmt.bindLong(18, _tmpNetLimit.getAvailable());
                    stmt.bindLong(19, _tmpNetLimit.getMax());
                } else {
                    stmt.bindNull(17);
                    stmt.bindNull(18);
                    stmt.bindNull(19);
                }
                AccountCpuLimit _tmpCpuLimit = value.getCpuLimit();
                if (_tmpCpuLimit != null) {
                    stmt.bindLong(20, _tmpCpuLimit.getUsed());
                    stmt.bindLong(21, _tmpCpuLimit.getAvailable());
                    stmt.bindLong(22, _tmpCpuLimit.getMax());
                } else {
                    stmt.bindNull(20);
                    stmt.bindNull(21);
                    stmt.bindNull(22);
                }
                AccountTotalResources _tmpTotalResources = value.getTotalResources();
                if (_tmpTotalResources != null) {
                    if (_tmpTotalResources.getOwner() == null) {
                        stmt.bindNull(23);
                    } else {
                        stmt.bindString(23, _tmpTotalResources.getOwner());
                    }
                    if (_tmpTotalResources.getNetWeight() == null) {
                        stmt.bindNull(24);
                    } else {
                        stmt.bindString(24, _tmpTotalResources.getNetWeight());
                    }
                    if (_tmpTotalResources.getCpuWeight() == null) {
                        stmt.bindNull(25);
                    } else {
                        stmt.bindString(25, _tmpTotalResources.getCpuWeight());
                    }
                    stmt.bindLong(26, (long)_tmpTotalResources.getRamBytes());
                } else {
                    stmt.bindNull(23);
                    stmt.bindNull(24);
                    stmt.bindNull(25);
                    stmt.bindNull(26);
                }
                AccountSelfDelegatedBandwidth _tmpSelfDelegatedBandwidth = value.getSelfDelegatedBandwidth();
                if (_tmpSelfDelegatedBandwidth != null) {
                    if (_tmpSelfDelegatedBandwidth.getFrom() == null) {
                        stmt.bindNull(27);
                    } else {
                        stmt.bindString(27, _tmpSelfDelegatedBandwidth.getFrom());
                    }
                    if (_tmpSelfDelegatedBandwidth.getTo() == null) {
                        stmt.bindNull(28);
                    } else {
                        stmt.bindString(28, _tmpSelfDelegatedBandwidth.getTo());
                    }
                    if (_tmpSelfDelegatedBandwidth.getNetWeight() == null) {
                        stmt.bindNull(29);
                    } else {
                        stmt.bindString(29, _tmpSelfDelegatedBandwidth.getNetWeight());
                    }
                    if (_tmpSelfDelegatedBandwidth.getCpuWeight() == null) {
                        stmt.bindNull(30);
                    } else {
                        stmt.bindString(30, _tmpSelfDelegatedBandwidth.getCpuWeight());
                    }
                } else {
                    stmt.bindNull(27);
                    stmt.bindNull(28);
                    stmt.bindNull(29);
                    stmt.bindNull(30);
                }
                AccountVoterInfo _tmpVoterInfo = value.getVoterInfo();
                if (_tmpVoterInfo != null) {
                    if (_tmpVoterInfo.getOwner() == null) {
                        stmt.bindNull(31);
                    } else {
                        stmt.bindString(31, _tmpVoterInfo.getOwner());
                    }
                    if (_tmpVoterInfo.getProxy() == null) {
                        stmt.bindNull(32);
                    } else {
                        stmt.bindString(32, _tmpVoterInfo.getProxy());
                    }
                    stmt.bindLong(33, _tmpVoterInfo.getStaked());
                    if (_tmpVoterInfo.getLastVoteWeight() == null) {
                        stmt.bindNull(34);
                    } else {
                        stmt.bindString(34, _tmpVoterInfo.getLastVoteWeight());
                    }
                    if (_tmpVoterInfo.getProxiedVoteWeight() == null) {
                        stmt.bindNull(35);
                    } else {
                        stmt.bindString(35, _tmpVoterInfo.getProxiedVoteWeight());
                    }
                    stmt.bindLong(36, (long)_tmpVoterInfo.isProxy());
                } else {
                    stmt.bindNull(31);
                    stmt.bindNull(32);
                    stmt.bindNull(33);
                    stmt.bindNull(34);
                    stmt.bindNull(35);
                    stmt.bindNull(36);
                }
                if (value.getAccountName() == null) {
                    stmt.bindNull(37);
                } else {
                    stmt.bindString(37, value.getAccountName());
                }
            }
        };
        this.__preparedStmtOfRemoveAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM account";
                return "DELETE FROM account";
            }
        };
    }

    @Override
    public Object insert(final Account account, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AccountDao_Impl.this.__db.beginTransaction();
                try {
                    AccountDao_Impl.this.__insertionAdapterOfAccount.insert((Object)account);
                    AccountDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AccountDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object update(final Account account, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AccountDao_Impl.this.__db.beginTransaction();
                try {
                    AccountDao_Impl.this.__updateAdapterOfAccount.handle((Object)account);
                    AccountDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AccountDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object removeAll(Continuation<? super Unit> p0) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = AccountDao_Impl.this.__preparedStmtOfRemoveAll.acquire();
                AccountDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    AccountDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AccountDao_Impl.this.__db.endTransaction();
                    AccountDao_Impl.this.__preparedStmtOfRemoveAll.release(_stmt);
                }
            }
        }, p0);
    }

    @Override
    public Object findByAccountName(String accountName, Continuation<? super ChainAccount> p1) {
        String _sql = "SELECT * FROM account WHERE accountName = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM account WHERE accountName = ?", (int)1);
        int _argIndex = 1;
        if (accountName == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, accountName);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (CancellationSignal)_cancellationSignal, (Callable)new Callable<ChainAccount>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ChainAccount call() throws Exception {
                AccountDao_Impl.this.__db.beginTransaction();
                try {
                    ChainAccount chainAccount;
                    Cursor _cursor = DBUtil.query((RoomDatabase)AccountDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        ChainAccount _result;
                        int _cursorIndexOfAccountChainId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accountChainId");
                        int _cursorIndexOfAccountContact = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accountContact");
                        int _cursorIndexOfVotersXPRInfo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"votersXPRInfo");
                        int _cursorIndexOfRefundsXPRInfo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"refundsXPRInfo");
                        int _cursorIndexOfAccountName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accountName");
                        int _cursorIndexOfHeadBlockNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"headBlockNum");
                        int _cursorIndexOfHeadBlockTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"headBlockTime");
                        int _cursorIndexOfPrivileged = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"privileged");
                        int _cursorIndexOfLastCodeUpdate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastCodeUpdate");
                        int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"created");
                        int _cursorIndexOfCoreLiquidBalance = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"coreLiquidBalance");
                        int _cursorIndexOfRamQuota = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ramQuota");
                        int _cursorIndexOfNetWeight = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"netWeight");
                        int _cursorIndexOfCpuWeight = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpuWeight");
                        int _cursorIndexOfRamUsage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"ramUsage");
                        int _cursorIndexOfPermissions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"permissions");
                        int _cursorIndexOfUsed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"net_limit_used");
                        int _cursorIndexOfAvailable = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"net_limit_available");
                        int _cursorIndexOfMax = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"net_limit_max");
                        int _cursorIndexOfUsed_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpu_limit_used");
                        int _cursorIndexOfAvailable_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpu_limit_available");
                        int _cursorIndexOfMax_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cpu_limit_max");
                        int _cursorIndexOfOwner = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"total_resources_owner");
                        int _cursorIndexOfNetWeight_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"total_resources_netWeight");
                        int _cursorIndexOfCpuWeight_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"total_resources_cpuWeight");
                        int _cursorIndexOfRamBytes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"total_resources_ramBytes");
                        int _cursorIndexOfFrom = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"self_delegated_bandwidth_from");
                        int _cursorIndexOfTo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"self_delegated_bandwidth_to");
                        int _cursorIndexOfNetWeight_2 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"self_delegated_bandwidth_netWeight");
                        int _cursorIndexOfCpuWeight_2 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"self_delegated_bandwidth_cpuWeight");
                        int _cursorIndexOfOwner_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"voter_info_owner");
                        int _cursorIndexOfProxy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"voter_info_proxy");
                        int _cursorIndexOfStaked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"voter_info_staked");
                        int _cursorIndexOfLastVoteWeight = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"voter_info_lastVoteWeight");
                        int _cursorIndexOfProxiedVoteWeight = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"voter_info_proxiedVoteWeight");
                        int _cursorIndexOfIsProxy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"voter_info_isProxy");
                        ArrayMap _collectionChainProvider = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey = _cursor.getString(_cursorIndexOfAccountChainId);
                            _collectionChainProvider.put((Object)_tmpKey, null);
                        }
                        _cursor.moveToPosition(-1);
                        AccountDao_Impl.this.__fetchRelationshipChainProviderAscomMetallicusProtonsdkModelChainProvider((ArrayMap<String, ChainProvider>)_collectionChainProvider);
                        if (_cursor.moveToFirst()) {
                            Account _tmpAccount;
                            if (!(_cursor.isNull(_cursorIndexOfAccountChainId) && _cursor.isNull(_cursorIndexOfAccountContact) && _cursor.isNull(_cursorIndexOfVotersXPRInfo) && _cursor.isNull(_cursorIndexOfRefundsXPRInfo) && _cursor.isNull(_cursorIndexOfAccountName) && _cursor.isNull(_cursorIndexOfHeadBlockNum) && _cursor.isNull(_cursorIndexOfHeadBlockTime) && _cursor.isNull(_cursorIndexOfPrivileged) && _cursor.isNull(_cursorIndexOfLastCodeUpdate) && _cursor.isNull(_cursorIndexOfCreated) && _cursor.isNull(_cursorIndexOfCoreLiquidBalance) && _cursor.isNull(_cursorIndexOfRamQuota) && _cursor.isNull(_cursorIndexOfNetWeight) && _cursor.isNull(_cursorIndexOfCpuWeight) && _cursor.isNull(_cursorIndexOfRamUsage) && _cursor.isNull(_cursorIndexOfPermissions) && _cursor.isNull(_cursorIndexOfUsed) && _cursor.isNull(_cursorIndexOfAvailable) && _cursor.isNull(_cursorIndexOfMax) && _cursor.isNull(_cursorIndexOfUsed_1) && _cursor.isNull(_cursorIndexOfAvailable_1) && _cursor.isNull(_cursorIndexOfMax_1) && _cursor.isNull(_cursorIndexOfOwner) && _cursor.isNull(_cursorIndexOfNetWeight_1) && _cursor.isNull(_cursorIndexOfCpuWeight_1) && _cursor.isNull(_cursorIndexOfRamBytes) && _cursor.isNull(_cursorIndexOfFrom) && _cursor.isNull(_cursorIndexOfTo) && _cursor.isNull(_cursorIndexOfNetWeight_2) && _cursor.isNull(_cursorIndexOfCpuWeight_2) && _cursor.isNull(_cursorIndexOfOwner_1) && _cursor.isNull(_cursorIndexOfProxy) && _cursor.isNull(_cursorIndexOfStaked) && _cursor.isNull(_cursorIndexOfLastVoteWeight) && _cursor.isNull(_cursorIndexOfProxiedVoteWeight) && _cursor.isNull(_cursorIndexOfIsProxy))) {
                                AccountVoterInfo _tmpVoterInfo;
                                AccountSelfDelegatedBandwidth _tmpSelfDelegatedBandwidth;
                                AccountTotalResources _tmpTotalResources;
                                AccountCpuLimit _tmpCpuLimit;
                                AccountNetLimit _tmpNetLimit;
                                String _tmpAccountName = _cursor.isNull(_cursorIndexOfAccountName) ? null : _cursor.getString(_cursorIndexOfAccountName);
                                int _tmpHeadBlockNum = _cursor.getInt(_cursorIndexOfHeadBlockNum);
                                String _tmpHeadBlockTime = _cursor.isNull(_cursorIndexOfHeadBlockTime) ? null : _cursor.getString(_cursorIndexOfHeadBlockTime);
                                int _tmp = _cursor.getInt(_cursorIndexOfPrivileged);
                                boolean _tmpPrivileged = _tmp != 0;
                                String _tmpLastCodeUpdate = _cursor.isNull(_cursorIndexOfLastCodeUpdate) ? null : _cursor.getString(_cursorIndexOfLastCodeUpdate);
                                String _tmpCreated = _cursor.isNull(_cursorIndexOfCreated) ? null : _cursor.getString(_cursorIndexOfCreated);
                                String _tmpCoreLiquidBalance = _cursor.isNull(_cursorIndexOfCoreLiquidBalance) ? null : _cursor.getString(_cursorIndexOfCoreLiquidBalance);
                                int _tmpRamQuota = _cursor.getInt(_cursorIndexOfRamQuota);
                                long _tmpNetWeight = _cursor.getLong(_cursorIndexOfNetWeight);
                                long _tmpCpuWeight = _cursor.getLong(_cursorIndexOfCpuWeight);
                                long _tmpRamUsage = _cursor.getLong(_cursorIndexOfRamUsage);
                                String _tmp_1 = _cursor.isNull(_cursorIndexOfPermissions) ? null : _cursor.getString(_cursorIndexOfPermissions);
                                List<AccountPermission> _tmpPermissions = EOSTypeConverters.stringToAccountPermissionList(_tmp_1);
                                if (!(_cursor.isNull(_cursorIndexOfUsed) && _cursor.isNull(_cursorIndexOfAvailable) && _cursor.isNull(_cursorIndexOfMax))) {
                                    long _tmpUsed = _cursor.getLong(_cursorIndexOfUsed);
                                    long _tmpAvailable = _cursor.getLong(_cursorIndexOfAvailable);
                                    long _tmpMax = _cursor.getLong(_cursorIndexOfMax);
                                    _tmpNetLimit = new AccountNetLimit(_tmpUsed, _tmpAvailable, _tmpMax);
                                } else {
                                    _tmpNetLimit = null;
                                }
                                if (!(_cursor.isNull(_cursorIndexOfUsed_1) && _cursor.isNull(_cursorIndexOfAvailable_1) && _cursor.isNull(_cursorIndexOfMax_1))) {
                                    long _tmpUsed_1 = _cursor.getLong(_cursorIndexOfUsed_1);
                                    long _tmpAvailable_1 = _cursor.getLong(_cursorIndexOfAvailable_1);
                                    long _tmpMax_1 = _cursor.getLong(_cursorIndexOfMax_1);
                                    _tmpCpuLimit = new AccountCpuLimit(_tmpUsed_1, _tmpAvailable_1, _tmpMax_1);
                                } else {
                                    _tmpCpuLimit = null;
                                }
                                if (!(_cursor.isNull(_cursorIndexOfOwner) && _cursor.isNull(_cursorIndexOfNetWeight_1) && _cursor.isNull(_cursorIndexOfCpuWeight_1) && _cursor.isNull(_cursorIndexOfRamBytes))) {
                                    String _tmpOwner = _cursor.isNull(_cursorIndexOfOwner) ? null : _cursor.getString(_cursorIndexOfOwner);
                                    String _tmpNetWeight_1 = _cursor.isNull(_cursorIndexOfNetWeight_1) ? null : _cursor.getString(_cursorIndexOfNetWeight_1);
                                    String _tmpCpuWeight_1 = _cursor.isNull(_cursorIndexOfCpuWeight_1) ? null : _cursor.getString(_cursorIndexOfCpuWeight_1);
                                    int _tmpRamBytes = _cursor.getInt(_cursorIndexOfRamBytes);
                                    _tmpTotalResources = new AccountTotalResources(_tmpOwner, _tmpNetWeight_1, _tmpCpuWeight_1, _tmpRamBytes);
                                } else {
                                    _tmpTotalResources = null;
                                }
                                if (!(_cursor.isNull(_cursorIndexOfFrom) && _cursor.isNull(_cursorIndexOfTo) && _cursor.isNull(_cursorIndexOfNetWeight_2) && _cursor.isNull(_cursorIndexOfCpuWeight_2))) {
                                    String _tmpFrom = _cursor.isNull(_cursorIndexOfFrom) ? null : _cursor.getString(_cursorIndexOfFrom);
                                    String _tmpTo = _cursor.isNull(_cursorIndexOfTo) ? null : _cursor.getString(_cursorIndexOfTo);
                                    String _tmpNetWeight_2 = _cursor.isNull(_cursorIndexOfNetWeight_2) ? null : _cursor.getString(_cursorIndexOfNetWeight_2);
                                    String _tmpCpuWeight_2 = _cursor.isNull(_cursorIndexOfCpuWeight_2) ? null : _cursor.getString(_cursorIndexOfCpuWeight_2);
                                    _tmpSelfDelegatedBandwidth = new AccountSelfDelegatedBandwidth(_tmpFrom, _tmpTo, _tmpNetWeight_2, _tmpCpuWeight_2);
                                } else {
                                    _tmpSelfDelegatedBandwidth = null;
                                }
                                if (!(_cursor.isNull(_cursorIndexOfOwner_1) && _cursor.isNull(_cursorIndexOfProxy) && _cursor.isNull(_cursorIndexOfStaked) && _cursor.isNull(_cursorIndexOfLastVoteWeight) && _cursor.isNull(_cursorIndexOfProxiedVoteWeight) && _cursor.isNull(_cursorIndexOfIsProxy))) {
                                    String _tmpOwner_1 = _cursor.isNull(_cursorIndexOfOwner_1) ? null : _cursor.getString(_cursorIndexOfOwner_1);
                                    String _tmpProxy = _cursor.isNull(_cursorIndexOfProxy) ? null : _cursor.getString(_cursorIndexOfProxy);
                                    long _tmpStaked = _cursor.getLong(_cursorIndexOfStaked);
                                    String _tmpLastVoteWeight = _cursor.isNull(_cursorIndexOfLastVoteWeight) ? null : _cursor.getString(_cursorIndexOfLastVoteWeight);
                                    String _tmpProxiedVoteWeight = _cursor.isNull(_cursorIndexOfProxiedVoteWeight) ? null : _cursor.getString(_cursorIndexOfProxiedVoteWeight);
                                    int _tmpIsProxy = _cursor.getInt(_cursorIndexOfIsProxy);
                                    _tmpVoterInfo = new AccountVoterInfo(_tmpOwner_1, _tmpProxy, _tmpStaked, _tmpLastVoteWeight, _tmpProxiedVoteWeight, _tmpIsProxy);
                                } else {
                                    _tmpVoterInfo = null;
                                }
                                _tmpAccount = new Account(_tmpAccountName, _tmpHeadBlockNum, _tmpHeadBlockTime, _tmpPrivileged, _tmpLastCodeUpdate, _tmpCreated, _tmpCoreLiquidBalance, _tmpRamQuota, _tmpNetWeight, _tmpCpuWeight, _tmpRamUsage, _tmpNetLimit, _tmpCpuLimit, _tmpPermissions, _tmpTotalResources, _tmpSelfDelegatedBandwidth, _tmpVoterInfo);
                                _tmpAccount.accountChainId = _cursor.isNull(_cursorIndexOfAccountChainId) ? null : _cursor.getString(_cursorIndexOfAccountChainId);
                                String _tmp_2 = _cursor.isNull(_cursorIndexOfAccountContact) ? null : _cursor.getString(_cursorIndexOfAccountContact);
                                _tmpAccount.accountContact = ProtonTypeConverters.stringToAccountContact(_tmp_2);
                                String _tmp_3 = _cursor.isNull(_cursorIndexOfVotersXPRInfo) ? null : _cursor.getString(_cursorIndexOfVotersXPRInfo);
                                _tmpAccount.votersXPRInfo = ProtonTypeConverters.stringToAccountVotersXPRInfo(_tmp_3);
                                String _tmp_4 = _cursor.isNull(_cursorIndexOfRefundsXPRInfo) ? null : _cursor.getString(_cursorIndexOfRefundsXPRInfo);
                                _tmpAccount.refundsXPRInfo = ProtonTypeConverters.stringToAccountRefundsXPRInfo(_tmp_4);
                            } else {
                                _tmpAccount = null;
                            }
                            ChainProvider _tmpChainProvider = null;
                            String _tmpKey_1 = _cursor.getString(_cursorIndexOfAccountChainId);
                            _tmpChainProvider = (ChainProvider)_collectionChainProvider.get((Object)_tmpKey_1);
                            _result = new ChainAccount(_tmpAccount, _tmpChainProvider);
                        } else {
                            _result = null;
                        }
                        AccountDao_Impl.this.__db.setTransactionSuccessful();
                        chainAccount = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return chainAccount;
                }
                finally {
                    AccountDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __fetchRelationshipChainProviderAscomMetallicusProtonsdkModelChainProvider(ArrayMap<String, ChainProvider> _map) {
        Set __mapKeySet = _map.keySet();
        if (__mapKeySet.isEmpty()) {
            return;
        }
        if (_map.size() > 999) {
            ArrayMap _tmpInnerMap = new ArrayMap(999);
            int _tmpIndex = 0;
            int _limit = _map.size();
            for (int _mapIndex = 0; _mapIndex < _limit; ++_mapIndex) {
                _tmpInnerMap.put(_map.keyAt(_mapIndex), null);
                if (++_tmpIndex != 999) continue;
                this.__fetchRelationshipChainProviderAscomMetallicusProtonsdkModelChainProvider((ArrayMap<String, ChainProvider>)_tmpInnerMap);
                _map.putAll((Map)_tmpInnerMap);
                _tmpInnerMap = new ArrayMap(999);
                _tmpIndex = 0;
            }
            if (_tmpIndex > 0) {
                this.__fetchRelationshipChainProviderAscomMetallicusProtonsdkModelChainProvider((ArrayMap<String, ChainProvider>)_tmpInnerMap);
                _map.putAll((Map)_tmpInnerMap);
            }
            return;
        }
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT `protonChainUrl`,`kycProviders`,`chainUrlStats`,`hyperionHistoryUrlStats`,`chainId`,`name`,`description`,`iconUrl`,`isTestnet`,`chainUrl`,`hyperionHistoryUrl`,`explorerName`,`explorerUrl`,`resourceTokenSymbol`,`resourceTokenContract`,`systemTokenSymbol`,`systemTokenContract`,`createAccountPath`,`updateAccountAvatarPath`,`updateAccountNamePath`,`exchangeRatePath`,`chainUrls`,`hyperionHistoryUrls` FROM `ChainProvider` WHERE `chainId` IN (");
        int _inputSize = __mapKeySet.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : __mapKeySet) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        try (Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_stmt, (boolean)false, null);){
            int _itemKeyIndex = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"chainId");
            if (_itemKeyIndex == -1) {
                return;
            }
            int _cursorIndexOfProtonChainUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"protonChainUrl");
            int _cursorIndexOfKycProviders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kycProviders");
            int _cursorIndexOfChainUrlStats = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"chainUrlStats");
            int _cursorIndexOfHyperionHistoryUrlStats = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hyperionHistoryUrlStats");
            int _cursorIndexOfChainId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"chainId");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
            int _cursorIndexOfIconUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iconUrl");
            int _cursorIndexOfIsTestnet = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isTestnet");
            int _cursorIndexOfChainUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"chainUrl");
            int _cursorIndexOfHyperionHistoryUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hyperionHistoryUrl");
            int _cursorIndexOfExplorerName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"explorerName");
            int _cursorIndexOfExplorerUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"explorerUrl");
            int _cursorIndexOfResourceTokenSymbol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resourceTokenSymbol");
            int _cursorIndexOfResourceTokenContract = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resourceTokenContract");
            int _cursorIndexOfSystemTokenSymbol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"systemTokenSymbol");
            int _cursorIndexOfSystemTokenContract = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"systemTokenContract");
            int _cursorIndexOfCreateAccountPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createAccountPath");
            int _cursorIndexOfUpdateAccountAvatarPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updateAccountAvatarPath");
            int _cursorIndexOfUpdateAccountNamePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updateAccountNamePath");
            int _cursorIndexOfExchangeRatePath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"exchangeRatePath");
            int _cursorIndexOfChainUrls = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"chainUrls");
            int _cursorIndexOfHyperionHistoryUrls = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hyperionHistoryUrls");
            while (_cursor.moveToNext()) {
                String _tmpKey = _cursor.getString(_itemKeyIndex);
                if (!_map.containsKey((Object)_tmpKey)) continue;
                String _tmpChainId = _cursor.isNull(_cursorIndexOfChainId) ? null : _cursor.getString(_cursorIndexOfChainId);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                String _tmpIconUrl = _cursor.isNull(_cursorIndexOfIconUrl) ? null : _cursor.getString(_cursorIndexOfIconUrl);
                int _tmp = _cursor.getInt(_cursorIndexOfIsTestnet);
                boolean _tmpIsTestnet = _tmp != 0;
                String _tmpChainUrl = _cursor.isNull(_cursorIndexOfChainUrl) ? null : _cursor.getString(_cursorIndexOfChainUrl);
                String _tmpHyperionHistoryUrl = _cursor.isNull(_cursorIndexOfHyperionHistoryUrl) ? null : _cursor.getString(_cursorIndexOfHyperionHistoryUrl);
                String _tmpExplorerName = _cursor.isNull(_cursorIndexOfExplorerName) ? null : _cursor.getString(_cursorIndexOfExplorerName);
                String _tmpExplorerUrl = _cursor.isNull(_cursorIndexOfExplorerUrl) ? null : _cursor.getString(_cursorIndexOfExplorerUrl);
                String _tmpResourceTokenSymbol = _cursor.isNull(_cursorIndexOfResourceTokenSymbol) ? null : _cursor.getString(_cursorIndexOfResourceTokenSymbol);
                String _tmpResourceTokenContract = _cursor.isNull(_cursorIndexOfResourceTokenContract) ? null : _cursor.getString(_cursorIndexOfResourceTokenContract);
                String _tmpSystemTokenSymbol = _cursor.isNull(_cursorIndexOfSystemTokenSymbol) ? null : _cursor.getString(_cursorIndexOfSystemTokenSymbol);
                String _tmpSystemTokenContract = _cursor.isNull(_cursorIndexOfSystemTokenContract) ? null : _cursor.getString(_cursorIndexOfSystemTokenContract);
                String _tmpCreateAccountPath = _cursor.isNull(_cursorIndexOfCreateAccountPath) ? null : _cursor.getString(_cursorIndexOfCreateAccountPath);
                String _tmpUpdateAccountAvatarPath = _cursor.isNull(_cursorIndexOfUpdateAccountAvatarPath) ? null : _cursor.getString(_cursorIndexOfUpdateAccountAvatarPath);
                String _tmpUpdateAccountNamePath = _cursor.isNull(_cursorIndexOfUpdateAccountNamePath) ? null : _cursor.getString(_cursorIndexOfUpdateAccountNamePath);
                String _tmpExchangeRatePath = _cursor.isNull(_cursorIndexOfExchangeRatePath) ? null : _cursor.getString(_cursorIndexOfExchangeRatePath);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfChainUrls) ? null : _cursor.getString(_cursorIndexOfChainUrls);
                List<String> _tmpChainUrls = DefaultTypeConverters.stringToStringList(_tmp_1);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfHyperionHistoryUrls) ? null : _cursor.getString(_cursorIndexOfHyperionHistoryUrls);
                List<String> _tmpHyperionHistoryUrls = DefaultTypeConverters.stringToStringList(_tmp_2);
                ChainProvider _item_1 = new ChainProvider(_tmpChainId, _tmpName, _tmpDescription, _tmpIconUrl, _tmpIsTestnet, _tmpChainUrl, _tmpHyperionHistoryUrl, _tmpExplorerName, _tmpExplorerUrl, _tmpResourceTokenSymbol, _tmpResourceTokenContract, _tmpSystemTokenSymbol, _tmpSystemTokenContract, _tmpCreateAccountPath, _tmpUpdateAccountAvatarPath, _tmpUpdateAccountNamePath, _tmpExchangeRatePath, _tmpChainUrls, _tmpHyperionHistoryUrls);
                _item_1.protonChainUrl = _cursor.isNull(_cursorIndexOfProtonChainUrl) ? null : _cursor.getString(_cursorIndexOfProtonChainUrl);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfKycProviders) ? null : _cursor.getString(_cursorIndexOfKycProviders);
                _item_1.kycProviders = ProtonTypeConverters.stringToKYCProviderList(_tmp_3);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfChainUrlStats) ? null : _cursor.getString(_cursorIndexOfChainUrlStats);
                _item_1.chainUrlStats = ProtonTypeConverters.stringToChainUrlInfoList(_tmp_4);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfHyperionHistoryUrlStats) ? null : _cursor.getString(_cursorIndexOfHyperionHistoryUrlStats);
                _item_1.hyperionHistoryUrlStats = ProtonTypeConverters.stringToChainUrlInfoList(_tmp_5);
                _map.put((Object)_tmpKey, (Object)_item_1);
            }
        }
    }
}

