/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.model;

import com.metallicus.protonsdk.model.TokenContract;
import java.text.NumberFormat;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u0014\u001a\u00020\u0003J\u0006\u0010\u0015\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lcom/metallicus/protonsdk/model/MarketTokenPrice;", "", "contract", "", "symbol", "price", "", "priceChangePercent", "tokenContract", "Lcom/metallicus/protonsdk/model/TokenContract;", "(Ljava/lang/String;Ljava/lang/String;DDLcom/metallicus/protonsdk/model/TokenContract;)V", "getContract", "()Ljava/lang/String;", "getPrice", "()D", "getPriceChangePercent", "getSymbol", "getTokenContract", "()Lcom/metallicus/protonsdk/model/TokenContract;", "formatPrice", "getName", "getPriceChangePercentStr", "protonsdk_release"})
public final class MarketTokenPrice {
    @NotNull
    private final String contract;
    @NotNull
    private final String symbol;
    private final double price;
    private final double priceChangePercent;
    @Nullable
    private final TokenContract tokenContract;

    @NotNull
    public final String getName() {
        Object object = this.tokenContract;
        if (object == null || (object = ((TokenContract)object).getName()) == null) {
            object = this.symbol;
        }
        return object;
    }

    @NotNull
    public final String formatPrice() {
        NumberFormat nf = NumberFormat.getCurrencyInstance(Locale.US);
        String string2 = nf.format(this.price);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nf.format(price)");
        return string2;
    }

    @NotNull
    public final String getPriceChangePercentStr() {
        return this.priceChangePercent <= 0.0 ? "" + this.priceChangePercent + '%' : "" + '+' + this.priceChangePercent + '%';
    }

    @NotNull
    public final String getContract() {
        return this.contract;
    }

    @NotNull
    public final String getSymbol() {
        return this.symbol;
    }

    public final double getPrice() {
        return this.price;
    }

    public final double getPriceChangePercent() {
        return this.priceChangePercent;
    }

    @Nullable
    public final TokenContract getTokenContract() {
        return this.tokenContract;
    }

    public MarketTokenPrice(@NotNull String contract, @NotNull String symbol, double price, double priceChangePercent, @Nullable TokenContract tokenContract) {
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        this.contract = contract;
        this.symbol = symbol;
        this.price = price;
        this.priceChangePercent = priceChangePercent;
        this.tokenContract = tokenContract;
    }
}

