/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander.model.chain;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.Expose;
import com.metallicus.protonsdk.eosio.commander.HexUtils;
import com.metallicus.protonsdk.eosio.commander.model.types.EosType;
import com.metallicus.protonsdk.eosio.commander.model.types.TypeAccountName;
import com.metallicus.protonsdk.eosio.commander.model.types.TypeActionName;
import com.metallicus.protonsdk.eosio.commander.model.types.TypePermissionLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Action
implements EosType.Packer {
    @Expose
    private TypeAccountName account;
    @Expose
    private TypeActionName name;
    @Expose
    private List<TypePermissionLevel> authorization = null;
    @Expose
    private JsonElement data;

    public Action(String account, String name, TypePermissionLevel authorization, String data) {
        this.account = new TypeAccountName(account);
        this.name = new TypeActionName(name);
        this.authorization = new ArrayList<TypePermissionLevel>();
        if (null != authorization) {
            this.authorization.add(authorization);
        }
        if (null != data) {
            this.data = new JsonPrimitive(data);
        }
    }

    public Action(String account, String name) {
        this(account, name, null, null);
    }

    public Action() {
        this(null, null, null, null);
    }

    public Action(Action other) {
        this.account = other.account;
        this.name = other.name;
        this.authorization = this.deepCopyOnlyContainer(other.authorization);
        this.data = other.data;
    }

    public String getAccount() {
        return this.account.toString();
    }

    public void setAccount(String account) {
        this.account = new TypeAccountName(account);
    }

    public String getName() {
        return this.name.toString();
    }

    public void setName(String name) {
        this.name = new TypeActionName(name);
    }

    public List<TypePermissionLevel> getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(List<TypePermissionLevel> authorization) {
        this.authorization = authorization;
    }

    public void setAuthorization(TypePermissionLevel[] authorization) {
        this.authorization.addAll(Arrays.asList(authorization));
    }

    public void setAuthorization(String[] accountWithPermLevel) {
        if (null == accountWithPermLevel) {
            return;
        }
        for (String permissionStr : accountWithPermLevel) {
            String[] split = permissionStr.split("@", 2);
            this.authorization.add(new TypePermissionLevel(split[0], split[1]));
        }
    }

    public JsonElement getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = new JsonPrimitive(data);
    }

    private <T> List<T> deepCopyOnlyContainer(List<T> srcList) {
        if (null == srcList) {
            return null;
        }
        ArrayList<T> newList = new ArrayList<T>(srcList.size());
        newList.addAll(srcList);
        return newList;
    }

    @Override
    public void pack(EosType.Writer writer) {
        this.account.pack(writer);
        this.name.pack(writer);
        writer.putCollection(this.authorization);
        if (null != this.data) {
            byte[] dataAsBytes = HexUtils.toBytes(this.data.getAsString());
            writer.putVariableUInt(dataAsBytes.length);
            writer.putBytes(dataAsBytes);
        } else {
            writer.putVariableUInt(0L);
        }
    }
}

