/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.repository;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.metallicus.protonsdk.api.ProtonChainService;
import com.metallicus.protonsdk.api.TableRowsBody;
import com.metallicus.protonsdk.db.TokenContractDao;
import com.metallicus.protonsdk.model.TokenContract;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;

@Singleton
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J7\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u0019\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001cH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0011\u0010\u001e\u001a\u00020\bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ!\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2={"Lcom/metallicus/protonsdk/repository/TokenContractRepository;", "", "tokenContractDao", "Lcom/metallicus/protonsdk/db/TokenContractDao;", "protonChainService", "Lcom/metallicus/protonsdk/api/ProtonChainService;", "(Lcom/metallicus/protonsdk/db/TokenContractDao;Lcom/metallicus/protonsdk/api/ProtonChainService;)V", "addTokenContract", "", "tokenContract", "Lcom/metallicus/protonsdk/model/TokenContract;", "(Lcom/metallicus/protonsdk/model/TokenContract;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchExchangeRates", "Lretrofit2/Response;", "Lcom/google/gson/JsonArray;", "exchangeRateUrl", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchTokenContracts", "Lcom/google/gson/JsonObject;", "chainUrl", "tokensTableScope", "tokensTableCode", "tokensTableName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getTokenContract", "tokenContractId", "getTokenContracts", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeAll", "updateRates", "rates", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "protonsdk_release"})
public final class TokenContractRepository {
    private final TokenContractDao tokenContractDao;
    private final ProtonChainService protonChainService;

    @Nullable
    public final Object removeAll(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.tokenContractDao.removeAll($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object addTokenContract(@NotNull TokenContract tokenContract, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.tokenContractDao.insert(tokenContract, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object fetchTokenContracts(@NotNull String chainUrl, @NotNull String tokensTableScope, @NotNull String tokensTableCode, @NotNull String tokensTableName, @NotNull Continuation<? super Response<JsonObject>> $completion) {
        return this.protonChainService.getTableRows(chainUrl + "/v1/chain/get_table_rows", new TableRowsBody(tokensTableScope, tokensTableCode, tokensTableName, "", "", 100L, false, 64, null), $completion);
    }

    @Nullable
    public final Object getTokenContract(@NotNull String tokenContractId, @NotNull Continuation<? super TokenContract> $completion) {
        return this.tokenContractDao.findById(tokenContractId, $completion);
    }

    @Nullable
    public final Object getTokenContracts(@NotNull Continuation<? super List<TokenContract>> $completion) {
        return this.tokenContractDao.findAll($completion);
    }

    @Nullable
    public final Object fetchExchangeRates(@NotNull String exchangeRateUrl, @NotNull Continuation<? super Response<JsonArray>> $completion) {
        return this.protonChainService.getExchangeRates(exchangeRateUrl, $completion);
    }

    @Nullable
    public final Object updateRates(@NotNull String tokenContractId, @NotNull String rates, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.tokenContractDao.updateRates(tokenContractId, rates, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Inject
    public TokenContractRepository(@NotNull TokenContractDao tokenContractDao, @NotNull ProtonChainService protonChainService) {
        Intrinsics.checkNotNullParameter((Object)tokenContractDao, (String)"tokenContractDao");
        Intrinsics.checkNotNullParameter((Object)protonChainService, (String)"protonChainService");
        this.tokenContractDao = tokenContractDao;
        this.protonChainService = protonChainService;
    }
}

