/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.securestorage;

import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.metallicus.protonsdk.securestorage.SecureStorageException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.util.ArrayList;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

final class SecretKeyTool {
    private static final String KEY_FACTORY_ALGORITHM = "PBKDF2WithHmacSHA1";
    private static final String KEY_ENCRYPTION_ALGORITHM = "AES";
    private static final String KEY_CHARSET = "UTF-8";
    private static final String KEY_TRANSFORMATION_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final int KEY_ITERATION_COUNT = 100;
    private static final int KEY_LENGTH = 256;

    private SecretKeyTool() {
    }

    @Nullable
    static String encryptMessage(@NonNull String key, @NonNull String plainMessage, @NonNull String password) throws SecureStorageException {
        try {
            byte[] salt = key.getBytes();
            byte[] iv = key.substring(0, 16).getBytes();
            SecretKeyFactory factory = SecretKeyFactory.getInstance(KEY_FACTORY_ALGORITHM);
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, 100, 256);
            SecretKeySpec secretKey = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), KEY_ENCRYPTION_ALGORITHM);
            Cipher cipher = Cipher.getInstance(KEY_TRANSFORMATION_ALGORITHM);
            cipher.init(1, (Key)secretKey, new IvParameterSpec(iv));
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, cipher);
            cipherOutputStream.write(plainMessage.getBytes(KEY_CHARSET));
            cipherOutputStream.close();
            byte[] values = outputStream.toByteArray();
            return Base64.encodeToString((byte[])values, (int)0);
        }
        catch (Exception e) {
            throw new SecureStorageException(e.getMessage(), e, SecureStorageException.ExceptionType.KEYSTORE_EXCEPTION);
        }
    }

    @NonNull
    static String decryptMessage(@NonNull String key, @NonNull String encryptedMessage, @NonNull String password) throws SecureStorageException {
        try {
            int nextByte;
            byte[] salt = key.getBytes();
            byte[] iv = key.substring(0, 16).getBytes();
            SecretKeyFactory factory = SecretKeyFactory.getInstance(KEY_FACTORY_ALGORITHM);
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, 100, 256);
            SecretKeySpec secretKey = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), KEY_ENCRYPTION_ALGORITHM);
            Cipher cipher = Cipher.getInstance(KEY_TRANSFORMATION_ALGORITHM);
            cipher.init(2, (Key)secretKey, new IvParameterSpec(iv));
            CipherInputStream cipherInputStream = new CipherInputStream(new ByteArrayInputStream(Base64.decode((String)encryptedMessage, (int)0)), cipher);
            ArrayList<Byte> values = new ArrayList<Byte>();
            while ((nextByte = cipherInputStream.read()) != -1) {
                values.add((byte)nextByte);
            }
            byte[] bytes = new byte[values.size()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (Byte)values.get(i);
            }
            return new String(bytes, 0, bytes.length, KEY_CHARSET);
        }
        catch (Exception e) {
            throw new SecureStorageException(e.getMessage(), e, SecureStorageException.ExceptionType.CRYPTO_EXCEPTION);
        }
    }
}

