/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.repository;

import com.google.gson.JsonObject;
import com.metallicus.protonsdk.api.AccountBody;
import com.metallicus.protonsdk.api.ProtonChainService;
import com.metallicus.protonsdk.api.UserNameBody;
import com.metallicus.protonsdk.db.AccountDao;
import com.metallicus.protonsdk.model.Account;
import com.metallicus.protonsdk.model.ChainAccount;
import com.metallicus.protonsdk.model.KeyAccount;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;

@Singleton
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ'\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J'\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0019\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u000fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u0011\u0010\u0019\u001a\u00020\bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0019\u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ7\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\r2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J7\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\r2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006'"}, d2={"Lcom/metallicus/protonsdk/repository/AccountRepository;", "", "accountDao", "Lcom/metallicus/protonsdk/db/AccountDao;", "protonChainService", "Lcom/metallicus/protonsdk/api/ProtonChainService;", "(Lcom/metallicus/protonsdk/db/AccountDao;Lcom/metallicus/protonsdk/api/ProtonChainService;)V", "addAccount", "", "account", "Lcom/metallicus/protonsdk/model/Account;", "(Lcom/metallicus/protonsdk/model/Account;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchAccount", "Lretrofit2/Response;", "chainUrl", "", "accountName", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchKeyAccount", "Lcom/metallicus/protonsdk/model/KeyAccount;", "hyperionHistoryUrl", "publicKey", "getChainAccount", "Lcom/metallicus/protonsdk/model/ChainAccount;", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeAll", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateAccount", "updateAccountAvatar", "Lcom/google/gson/JsonObject;", "updateAccountAvatarUrl", "signature", "imageByteArray", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateAccountName", "updateAccountNameUrl", "name", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "protonsdk_release"})
public final class AccountRepository {
    private final AccountDao accountDao;
    private final ProtonChainService protonChainService;

    @Nullable
    public final Object removeAll(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.accountDao.removeAll($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object addAccount(@NotNull Account account, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.accountDao.insert(account, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object updateAccount(@NotNull Account account, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.accountDao.update(account, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object updateAccountName(@NotNull String updateAccountNameUrl, @NotNull String accountName, @NotNull String signature, @NotNull String name, @NotNull Continuation<? super Response<JsonObject>> $completion) {
        String url = StringsKt.replace$default((String)updateAccountNameUrl, (String)"{{account}}", (String)accountName, (boolean)false, (int)4, null);
        return this.protonChainService.updateUserName(url, "Bearer " + signature, new UserNameBody(name), $completion);
    }

    @Nullable
    public final Object updateAccountAvatar(@NotNull String updateAccountAvatarUrl, @NotNull String accountName, @NotNull String signature, @NotNull byte[] imageByteArray, @NotNull Continuation<? super Response<JsonObject>> $completion) {
        String url = StringsKt.replace$default((String)updateAccountAvatarUrl, (String)"{{account}}", (String)accountName, (boolean)false, (int)4, null);
        MultipartBody.Builder builder = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
        builder.addFormDataPart("img", "img.jpeg", RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])imageByteArray, (MediaType)MediaType.Companion.parse("image/jpeg"), (int)0, (int)0, (int)6, null));
        MultipartBody multipartBody = builder.build();
        return this.protonChainService.uploadUserAvatar(url, "Bearer " + signature, multipartBody, $completion);
    }

    @Nullable
    public final Object getChainAccount(@NotNull String accountName, @NotNull Continuation<? super ChainAccount> $completion) {
        return this.accountDao.findByAccountName(accountName, $completion);
    }

    @Nullable
    public final Object fetchKeyAccount(@NotNull String hyperionHistoryUrl, @NotNull String publicKey, @NotNull Continuation<? super Response<KeyAccount>> $completion) {
        return this.protonChainService.getKeyAccounts(hyperionHistoryUrl + "/v2/state/get_key_accounts", publicKey, $completion);
    }

    @Nullable
    public final Object fetchAccount(@NotNull String chainUrl, @NotNull String accountName, @NotNull Continuation<? super Response<Account>> $completion) {
        return this.protonChainService.getAccount(chainUrl + "/v1/chain/get_account", new AccountBody(accountName), $completion);
    }

    @Inject
    public AccountRepository(@NotNull AccountDao accountDao, @NotNull ProtonChainService protonChainService) {
        Intrinsics.checkNotNullParameter((Object)accountDao, (String)"accountDao");
        Intrinsics.checkNotNullParameter((Object)protonChainService, (String)"protonChainService");
        this.accountDao = accountDao;
        this.protonChainService = protonChainService;
    }
}

