/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander.model.types;

import com.metallicus.protonsdk.eosio.commander.model.types.EosType;
import java.util.Collection;

public class EosByteWriter
implements EosType.Writer {
    private byte[] _buf;
    private int _index;

    public EosByteWriter(int capacity) {
        this._buf = new byte[capacity];
        this._index = 0;
    }

    public EosByteWriter(byte[] buf) {
        this._buf = buf;
        this._index = buf.length;
    }

    private void ensureCapacity(int capacity) {
        if (this._buf.length - this._index < capacity) {
            byte[] temp = new byte[this._buf.length * 2 + capacity];
            System.arraycopy(this._buf, 0, temp, 0, this._index);
            this._buf = temp;
        }
    }

    @Override
    public void put(byte b) {
        this.ensureCapacity(1);
        this._buf[this._index++] = b;
    }

    @Override
    public void putShortLE(short value) {
        this.ensureCapacity(2);
        this._buf[this._index++] = (byte)(0xFF & value);
        this._buf[this._index++] = (byte)(0xFF & value >> 8);
    }

    @Override
    public void putIntLE(int value) {
        this.ensureCapacity(4);
        this._buf[this._index++] = (byte)(0xFF & value);
        this._buf[this._index++] = (byte)(0xFF & value >> 8);
        this._buf[this._index++] = (byte)(0xFF & value >> 16);
        this._buf[this._index++] = (byte)(0xFF & value >> 24);
    }

    @Override
    public void putLongLE(long value) {
        this.ensureCapacity(8);
        this._buf[this._index++] = (byte)(0xFFL & value);
        this._buf[this._index++] = (byte)(0xFFL & value >> 8);
        this._buf[this._index++] = (byte)(0xFFL & value >> 16);
        this._buf[this._index++] = (byte)(0xFFL & value >> 24);
        this._buf[this._index++] = (byte)(0xFFL & value >> 32);
        this._buf[this._index++] = (byte)(0xFFL & value >> 40);
        this._buf[this._index++] = (byte)(0xFFL & value >> 48);
        this._buf[this._index++] = (byte)(0xFFL & value >> 56);
    }

    @Override
    public void putBytes(byte[] value) {
        this.ensureCapacity(value.length);
        System.arraycopy(value, 0, this._buf, this._index, value.length);
        this._index += value.length;
    }

    public void putBytes(byte[] value, int offset, int length) {
        this.ensureCapacity(length);
        System.arraycopy(value, offset, this._buf, this._index, length);
        this._index += length;
    }

    @Override
    public byte[] toBytes() {
        byte[] bytes = new byte[this._index];
        System.arraycopy(this._buf, 0, bytes, 0, this._index);
        return bytes;
    }

    @Override
    public int length() {
        return this._index;
    }

    @Override
    public void putString(String value) {
        if (null == value) {
            this.putVariableUInt(0L);
            return;
        }
        this.putVariableUInt(value.length());
        this.putBytes(value.getBytes());
    }

    @Override
    public void putCollection(Collection<? extends EosType.Packer> collection) {
        if (null == collection) {
            this.putVariableUInt(0L);
            return;
        }
        this.putVariableUInt(collection.size());
        for (EosType.Packer packer : collection) {
            packer.pack(this);
        }
    }

    @Override
    public void putVariableUInt(long val) {
        do {
            byte b = (byte)(val & 0x7FL);
            b = (byte)(b | ((val >>= 7) > 0L ? 1 : 0) << 7);
            this.put(b);
        } while (val != 0L);
    }
}

