/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander.ec;

import com.metallicus.protonsdk.eosio.commander.ec.EcCurve;
import com.metallicus.protonsdk.eosio.commander.ec.EcFieldElement;
import com.metallicus.protonsdk.eosio.commander.ec.EcTools;
import java.math.BigInteger;

public class EcPoint {
    private EcCurve _curve;
    private EcFieldElement _x;
    private EcFieldElement _y;
    private boolean _compressed;

    public EcPoint(EcCurve curve, EcFieldElement x, EcFieldElement y) {
        this(curve, x, y, false);
    }

    public EcPoint(EcCurve curve, EcFieldElement x, EcFieldElement y, boolean compressed) {
        this._curve = curve;
        this._x = x;
        this._y = y;
        this._compressed = compressed;
    }

    public EcCurve getCurve() {
        return this._curve;
    }

    public EcFieldElement getX() {
        return this._x;
    }

    public EcFieldElement getY() {
        return this._y;
    }

    public boolean isInfinity() {
        return this._x == null && this._y == null;
    }

    public boolean isCompressed() {
        return this._compressed;
    }

    public byte[] getEncoded() {
        if (this.isInfinity()) {
            return new byte[1];
        }
        int length = EcTools.getByteLength(this._x.getFieldSize());
        if (this._compressed) {
            int PC = this.getY().toBigInteger().testBit(0) ? 3 : 2;
            byte[] X = EcTools.integerToBytes(this.getX().toBigInteger(), length);
            byte[] PO = new byte[X.length + 1];
            PO[0] = PC;
            System.arraycopy(X, 0, PO, 1, X.length);
            return PO;
        }
        byte[] X = EcTools.integerToBytes(this.getX().toBigInteger(), length);
        byte[] Y = EcTools.integerToBytes(this.getY().toBigInteger(), length);
        byte[] PO = new byte[X.length + Y.length + 1];
        PO[0] = 4;
        System.arraycopy(X, 0, PO, 1, X.length);
        System.arraycopy(Y, 0, PO, X.length + 1, Y.length);
        return PO;
    }

    public EcPoint add(EcPoint b) {
        if (this.isInfinity()) {
            return b;
        }
        if (b.isInfinity()) {
            return this;
        }
        if (this._x.equals(b._x)) {
            if (this._y.equals(b._y)) {
                return this.twice();
            }
            return this._curve.getInfinity();
        }
        EcFieldElement gamma = b._y.subtract(this._y).divide(b._x.subtract(this._x));
        EcFieldElement x3 = gamma.square().subtract(this._x).subtract(b._x);
        EcFieldElement y3 = gamma.multiply(this._x.subtract(x3)).subtract(this._y);
        return new EcPoint(this._curve, x3, y3);
    }

    public EcPoint twice() {
        if (this.isInfinity()) {
            return this;
        }
        if (this._y.toBigInteger().signum() == 0) {
            return this._curve.getInfinity();
        }
        EcFieldElement TWO = this._curve.fromBigInteger(BigInteger.valueOf(2L));
        EcFieldElement THREE = this._curve.fromBigInteger(BigInteger.valueOf(3L));
        EcFieldElement gamma = this._x.square().multiply(THREE).add(this._curve.getA()).divide(this._y.multiply(TWO));
        EcFieldElement x3 = gamma.square().subtract(this._x.multiply(TWO));
        EcFieldElement y3 = gamma.multiply(this._x.subtract(x3)).subtract(this._y);
        return new EcPoint(this._curve, x3, y3, this._compressed);
    }

    public EcPoint subtract(EcPoint b) {
        if (b.isInfinity()) {
            return this;
        }
        return this.add(b.negate());
    }

    public EcPoint negate() {
        return new EcPoint(this._curve, this._x, this._y.negate(), this._compressed);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof EcPoint)) {
            return false;
        }
        EcPoint o = (EcPoint)other;
        if (this.isInfinity()) {
            return o.isInfinity();
        }
        return this._x.equals(o._x) && this._y.equals(o._y);
    }

    public int hashCode() {
        if (this.isInfinity()) {
            return 0;
        }
        return this._x.hashCode() ^ this._y.hashCode();
    }

    public EcPoint multiply(BigInteger n) {
        return EcTools.multiply(this, n);
    }
}

