/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.db;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.metallicus.protonsdk.db.ActionDao;
import com.metallicus.protonsdk.db.EOSTypeConverters;
import com.metallicus.protonsdk.db.ProtonTypeConverters;
import com.metallicus.protonsdk.model.Action;
import com.metallicus.protonsdk.model.ActionTrace;
import com.metallicus.protonsdk.model.ActionTraceAct;
import com.metallicus.protonsdk.model.ActionTraceActAuthorization;
import com.metallicus.protonsdk.model.ActionTraceActData;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class ActionDao_Impl
implements ActionDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Action> __insertionAdapterOfAction;
    private final SharedSQLiteStatement __preparedStmtOfRemoveAll;

    public ActionDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfAction = new EntityInsertionAdapter<Action>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Action` (`accountName`,`accountContact`,`globalActionSeq`,`blockNum`,`blockTime`,`action_trace_trxId`,`action_trace_act_account`,`action_trace_act_name`,`action_trace_act_authorization`,`action_trace_act_data_from`,`action_trace_act_data_to`,`action_trace_act_data_quantity`,`action_trace_act_data_memo`,`action_trace_act_data_receiver`,`action_trace_act_data_stakeCpuQuantity`,`action_trace_act_data_stakeNetQuantity`,`action_trace_act_data_unStakeCpuQuantity`,`action_trace_act_data_unStakeNetQuantity`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Action value) {
                if (value.accountName == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.accountName);
                }
                String _tmp = ProtonTypeConverters.accountContactToString(value.accountContact);
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                stmt.bindLong(3, (long)value.getGlobalActionSeq());
                stmt.bindLong(4, (long)value.getBlockNum());
                if (value.getBlockTime() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getBlockTime());
                }
                ActionTrace _tmpActionTrace = value.getActionTrace();
                if (_tmpActionTrace != null) {
                    if (_tmpActionTrace.getTrxId() == null) {
                        stmt.bindNull(6);
                    } else {
                        stmt.bindString(6, _tmpActionTrace.getTrxId());
                    }
                    ActionTraceAct _tmpAct = _tmpActionTrace.getAct();
                    if (_tmpAct != null) {
                        if (_tmpAct.getAccount() == null) {
                            stmt.bindNull(7);
                        } else {
                            stmt.bindString(7, _tmpAct.getAccount());
                        }
                        if (_tmpAct.getName() == null) {
                            stmt.bindNull(8);
                        } else {
                            stmt.bindString(8, _tmpAct.getName());
                        }
                        String _tmp_1 = EOSTypeConverters.actionTraceActAuthorizationListToString(_tmpAct.getAuthorization());
                        if (_tmp_1 == null) {
                            stmt.bindNull(9);
                        } else {
                            stmt.bindString(9, _tmp_1);
                        }
                        ActionTraceActData _tmpData = _tmpAct.getData();
                        if (_tmpData != null) {
                            if (_tmpData.getFrom() == null) {
                                stmt.bindNull(10);
                            } else {
                                stmt.bindString(10, _tmpData.getFrom());
                            }
                            if (_tmpData.getTo() == null) {
                                stmt.bindNull(11);
                            } else {
                                stmt.bindString(11, _tmpData.getTo());
                            }
                            if (_tmpData.getQuantity() == null) {
                                stmt.bindNull(12);
                            } else {
                                stmt.bindString(12, _tmpData.getQuantity());
                            }
                            if (_tmpData.getMemo() == null) {
                                stmt.bindNull(13);
                            } else {
                                stmt.bindString(13, _tmpData.getMemo());
                            }
                            if (_tmpData.getReceiver() == null) {
                                stmt.bindNull(14);
                            } else {
                                stmt.bindString(14, _tmpData.getReceiver());
                            }
                            if (_tmpData.getStakeCpuQuantity() == null) {
                                stmt.bindNull(15);
                            } else {
                                stmt.bindString(15, _tmpData.getStakeCpuQuantity());
                            }
                            if (_tmpData.getStakeNetQuantity() == null) {
                                stmt.bindNull(16);
                            } else {
                                stmt.bindString(16, _tmpData.getStakeNetQuantity());
                            }
                            if (_tmpData.getUnStakeCpuQuantity() == null) {
                                stmt.bindNull(17);
                            } else {
                                stmt.bindString(17, _tmpData.getUnStakeCpuQuantity());
                            }
                            if (_tmpData.getUnStakeNetQuantity() == null) {
                                stmt.bindNull(18);
                            } else {
                                stmt.bindString(18, _tmpData.getUnStakeNetQuantity());
                            }
                        } else {
                            stmt.bindNull(10);
                            stmt.bindNull(11);
                            stmt.bindNull(12);
                            stmt.bindNull(13);
                            stmt.bindNull(14);
                            stmt.bindNull(15);
                            stmt.bindNull(16);
                            stmt.bindNull(17);
                            stmt.bindNull(18);
                        }
                    } else {
                        stmt.bindNull(7);
                        stmt.bindNull(8);
                        stmt.bindNull(9);
                        stmt.bindNull(10);
                        stmt.bindNull(11);
                        stmt.bindNull(12);
                        stmt.bindNull(13);
                        stmt.bindNull(14);
                        stmt.bindNull(15);
                        stmt.bindNull(16);
                        stmt.bindNull(17);
                        stmt.bindNull(18);
                    }
                } else {
                    stmt.bindNull(6);
                    stmt.bindNull(7);
                    stmt.bindNull(8);
                    stmt.bindNull(9);
                    stmt.bindNull(10);
                    stmt.bindNull(11);
                    stmt.bindNull(12);
                    stmt.bindNull(13);
                    stmt.bindNull(14);
                    stmt.bindNull(15);
                    stmt.bindNull(16);
                    stmt.bindNull(17);
                    stmt.bindNull(18);
                }
            }
        };
        this.__preparedStmtOfRemoveAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM `action`";
                return "DELETE FROM `action`";
            }
        };
    }

    @Override
    public Object insert(final Action action, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ActionDao_Impl.this.__db.beginTransaction();
                try {
                    ActionDao_Impl.this.__insertionAdapterOfAction.insert((Object)action);
                    ActionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ActionDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object removeAll(Continuation<? super Unit> p0) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = ActionDao_Impl.this.__preparedStmtOfRemoveAll.acquire();
                ActionDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ActionDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ActionDao_Impl.this.__db.endTransaction();
                    ActionDao_Impl.this.__preparedStmtOfRemoveAll.release(_stmt);
                }
            }
        }, p0);
    }

    @Override
    public Object findBySystemTokenContract(String accountName, String contract, String symbol, Continuation<? super List<Action>> p3) {
        String _sql = "SELECT * FROM `action` WHERE accountName = ? AND ((action_trace_act_account = ? AND action_trace_act_data_quantity LIKE '% ' || ?) OR action_trace_act_account = 'eosio')";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM `action` WHERE accountName = ? AND ((action_trace_act_account = ? AND action_trace_act_data_quantity LIKE '% ' || ?) OR action_trace_act_account = 'eosio')", (int)3);
        int _argIndex = 1;
        if (accountName == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, accountName);
        }
        _argIndex = 2;
        if (contract == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, contract);
        }
        _argIndex = 3;
        if (symbol == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, symbol);
        }
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<List<Action>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Action> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ActionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfAccountName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accountName");
                    int _cursorIndexOfAccountContact = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accountContact");
                    int _cursorIndexOfGlobalActionSeq = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"globalActionSeq");
                    int _cursorIndexOfBlockNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blockNum");
                    int _cursorIndexOfBlockTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blockTime");
                    int _cursorIndexOfTrxId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_trxId");
                    int _cursorIndexOfAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_account");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_name");
                    int _cursorIndexOfAuthorization = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_authorization");
                    int _cursorIndexOfFrom = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_data_from");
                    int _cursorIndexOfTo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_data_to");
                    int _cursorIndexOfQuantity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_data_quantity");
                    int _cursorIndexOfMemo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_data_memo");
                    int _cursorIndexOfReceiver = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_data_receiver");
                    int _cursorIndexOfStakeCpuQuantity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_data_stakeCpuQuantity");
                    int _cursorIndexOfStakeNetQuantity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_data_stakeNetQuantity");
                    int _cursorIndexOfUnStakeCpuQuantity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_data_unStakeCpuQuantity");
                    int _cursorIndexOfUnStakeNetQuantity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_data_unStakeNetQuantity");
                    ArrayList<Action> _result = new ArrayList<Action>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ActionTrace _tmpActionTrace;
                        int _tmpGlobalActionSeq = _cursor.getInt(_cursorIndexOfGlobalActionSeq);
                        int _tmpBlockNum = _cursor.getInt(_cursorIndexOfBlockNum);
                        String _tmpBlockTime = _cursor.getString(_cursorIndexOfBlockTime);
                        if (!(_cursor.isNull(_cursorIndexOfTrxId) && _cursor.isNull(_cursorIndexOfAccount) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfAuthorization) && _cursor.isNull(_cursorIndexOfFrom) && _cursor.isNull(_cursorIndexOfTo) && _cursor.isNull(_cursorIndexOfQuantity) && _cursor.isNull(_cursorIndexOfMemo) && _cursor.isNull(_cursorIndexOfReceiver) && _cursor.isNull(_cursorIndexOfStakeCpuQuantity) && _cursor.isNull(_cursorIndexOfStakeNetQuantity) && _cursor.isNull(_cursorIndexOfUnStakeCpuQuantity) && _cursor.isNull(_cursorIndexOfUnStakeNetQuantity))) {
                            ActionTraceAct _tmpAct;
                            String _tmpTrxId = _cursor.getString(_cursorIndexOfTrxId);
                            if (!(_cursor.isNull(_cursorIndexOfAccount) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfAuthorization) && _cursor.isNull(_cursorIndexOfFrom) && _cursor.isNull(_cursorIndexOfTo) && _cursor.isNull(_cursorIndexOfQuantity) && _cursor.isNull(_cursorIndexOfMemo) && _cursor.isNull(_cursorIndexOfReceiver) && _cursor.isNull(_cursorIndexOfStakeCpuQuantity) && _cursor.isNull(_cursorIndexOfStakeNetQuantity) && _cursor.isNull(_cursorIndexOfUnStakeCpuQuantity) && _cursor.isNull(_cursorIndexOfUnStakeNetQuantity))) {
                                ActionTraceActData _tmpData;
                                String _tmpAccount = _cursor.getString(_cursorIndexOfAccount);
                                String _tmpName = _cursor.getString(_cursorIndexOfName);
                                String _tmp = _cursor.getString(_cursorIndexOfAuthorization);
                                List<ActionTraceActAuthorization> _tmpAuthorization = EOSTypeConverters.stringToActionTraceActAuthorizationList(_tmp);
                                if (!(_cursor.isNull(_cursorIndexOfFrom) && _cursor.isNull(_cursorIndexOfTo) && _cursor.isNull(_cursorIndexOfQuantity) && _cursor.isNull(_cursorIndexOfMemo) && _cursor.isNull(_cursorIndexOfReceiver) && _cursor.isNull(_cursorIndexOfStakeCpuQuantity) && _cursor.isNull(_cursorIndexOfStakeNetQuantity) && _cursor.isNull(_cursorIndexOfUnStakeCpuQuantity) && _cursor.isNull(_cursorIndexOfUnStakeNetQuantity))) {
                                    String _tmpFrom = _cursor.getString(_cursorIndexOfFrom);
                                    String _tmpTo = _cursor.getString(_cursorIndexOfTo);
                                    String _tmpQuantity = _cursor.getString(_cursorIndexOfQuantity);
                                    String _tmpMemo = _cursor.getString(_cursorIndexOfMemo);
                                    String _tmpReceiver = _cursor.getString(_cursorIndexOfReceiver);
                                    String _tmpStakeCpuQuantity = _cursor.getString(_cursorIndexOfStakeCpuQuantity);
                                    String _tmpStakeNetQuantity = _cursor.getString(_cursorIndexOfStakeNetQuantity);
                                    String _tmpUnStakeCpuQuantity = _cursor.getString(_cursorIndexOfUnStakeCpuQuantity);
                                    String _tmpUnStakeNetQuantity = _cursor.getString(_cursorIndexOfUnStakeNetQuantity);
                                    _tmpData = new ActionTraceActData(_tmpFrom, _tmpTo, _tmpQuantity, _tmpMemo, _tmpReceiver, _tmpStakeCpuQuantity, _tmpStakeNetQuantity, _tmpUnStakeCpuQuantity, _tmpUnStakeNetQuantity);
                                } else {
                                    _tmpData = null;
                                }
                                _tmpAct = new ActionTraceAct(_tmpAccount, _tmpName, _tmpAuthorization, _tmpData);
                            } else {
                                _tmpAct = null;
                            }
                            _tmpActionTrace = new ActionTrace(_tmpTrxId, _tmpAct);
                        } else {
                            _tmpActionTrace = null;
                        }
                        Action _item = new Action(_tmpGlobalActionSeq, _tmpBlockNum, _tmpBlockTime, _tmpActionTrace);
                        _item.accountName = _cursor.getString(_cursorIndexOfAccountName);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfAccountContact);
                        _item.accountContact = ProtonTypeConverters.stringToAccountContact(_tmp_1);
                        _result.add(_item);
                    }
                    ArrayList<Action> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p3);
    }

    @Override
    public Object findByTokenContract(String accountName, String contract, String symbol, Continuation<? super List<Action>> p3) {
        String _sql = "SELECT * FROM `action` WHERE accountName = ? AND action_trace_act_account = ? AND action_trace_act_data_quantity LIKE '% ' || ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM `action` WHERE accountName = ? AND action_trace_act_account = ? AND action_trace_act_data_quantity LIKE '% ' || ?", (int)3);
        int _argIndex = 1;
        if (accountName == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, accountName);
        }
        _argIndex = 2;
        if (contract == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, contract);
        }
        _argIndex = 3;
        if (symbol == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, symbol);
        }
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<List<Action>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Action> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)ActionDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfAccountName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accountName");
                    int _cursorIndexOfAccountContact = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accountContact");
                    int _cursorIndexOfGlobalActionSeq = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"globalActionSeq");
                    int _cursorIndexOfBlockNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blockNum");
                    int _cursorIndexOfBlockTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blockTime");
                    int _cursorIndexOfTrxId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_trxId");
                    int _cursorIndexOfAccount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_account");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_name");
                    int _cursorIndexOfAuthorization = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_authorization");
                    int _cursorIndexOfFrom = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_data_from");
                    int _cursorIndexOfTo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_data_to");
                    int _cursorIndexOfQuantity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_data_quantity");
                    int _cursorIndexOfMemo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_data_memo");
                    int _cursorIndexOfReceiver = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_data_receiver");
                    int _cursorIndexOfStakeCpuQuantity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_data_stakeCpuQuantity");
                    int _cursorIndexOfStakeNetQuantity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_data_stakeNetQuantity");
                    int _cursorIndexOfUnStakeCpuQuantity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_data_unStakeCpuQuantity");
                    int _cursorIndexOfUnStakeNetQuantity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"action_trace_act_data_unStakeNetQuantity");
                    ArrayList<Action> _result = new ArrayList<Action>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        ActionTrace _tmpActionTrace;
                        int _tmpGlobalActionSeq = _cursor.getInt(_cursorIndexOfGlobalActionSeq);
                        int _tmpBlockNum = _cursor.getInt(_cursorIndexOfBlockNum);
                        String _tmpBlockTime = _cursor.getString(_cursorIndexOfBlockTime);
                        if (!(_cursor.isNull(_cursorIndexOfTrxId) && _cursor.isNull(_cursorIndexOfAccount) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfAuthorization) && _cursor.isNull(_cursorIndexOfFrom) && _cursor.isNull(_cursorIndexOfTo) && _cursor.isNull(_cursorIndexOfQuantity) && _cursor.isNull(_cursorIndexOfMemo) && _cursor.isNull(_cursorIndexOfReceiver) && _cursor.isNull(_cursorIndexOfStakeCpuQuantity) && _cursor.isNull(_cursorIndexOfStakeNetQuantity) && _cursor.isNull(_cursorIndexOfUnStakeCpuQuantity) && _cursor.isNull(_cursorIndexOfUnStakeNetQuantity))) {
                            ActionTraceAct _tmpAct;
                            String _tmpTrxId = _cursor.getString(_cursorIndexOfTrxId);
                            if (!(_cursor.isNull(_cursorIndexOfAccount) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfAuthorization) && _cursor.isNull(_cursorIndexOfFrom) && _cursor.isNull(_cursorIndexOfTo) && _cursor.isNull(_cursorIndexOfQuantity) && _cursor.isNull(_cursorIndexOfMemo) && _cursor.isNull(_cursorIndexOfReceiver) && _cursor.isNull(_cursorIndexOfStakeCpuQuantity) && _cursor.isNull(_cursorIndexOfStakeNetQuantity) && _cursor.isNull(_cursorIndexOfUnStakeCpuQuantity) && _cursor.isNull(_cursorIndexOfUnStakeNetQuantity))) {
                                ActionTraceActData _tmpData;
                                String _tmpAccount = _cursor.getString(_cursorIndexOfAccount);
                                String _tmpName = _cursor.getString(_cursorIndexOfName);
                                String _tmp = _cursor.getString(_cursorIndexOfAuthorization);
                                List<ActionTraceActAuthorization> _tmpAuthorization = EOSTypeConverters.stringToActionTraceActAuthorizationList(_tmp);
                                if (!(_cursor.isNull(_cursorIndexOfFrom) && _cursor.isNull(_cursorIndexOfTo) && _cursor.isNull(_cursorIndexOfQuantity) && _cursor.isNull(_cursorIndexOfMemo) && _cursor.isNull(_cursorIndexOfReceiver) && _cursor.isNull(_cursorIndexOfStakeCpuQuantity) && _cursor.isNull(_cursorIndexOfStakeNetQuantity) && _cursor.isNull(_cursorIndexOfUnStakeCpuQuantity) && _cursor.isNull(_cursorIndexOfUnStakeNetQuantity))) {
                                    String _tmpFrom = _cursor.getString(_cursorIndexOfFrom);
                                    String _tmpTo = _cursor.getString(_cursorIndexOfTo);
                                    String _tmpQuantity = _cursor.getString(_cursorIndexOfQuantity);
                                    String _tmpMemo = _cursor.getString(_cursorIndexOfMemo);
                                    String _tmpReceiver = _cursor.getString(_cursorIndexOfReceiver);
                                    String _tmpStakeCpuQuantity = _cursor.getString(_cursorIndexOfStakeCpuQuantity);
                                    String _tmpStakeNetQuantity = _cursor.getString(_cursorIndexOfStakeNetQuantity);
                                    String _tmpUnStakeCpuQuantity = _cursor.getString(_cursorIndexOfUnStakeCpuQuantity);
                                    String _tmpUnStakeNetQuantity = _cursor.getString(_cursorIndexOfUnStakeNetQuantity);
                                    _tmpData = new ActionTraceActData(_tmpFrom, _tmpTo, _tmpQuantity, _tmpMemo, _tmpReceiver, _tmpStakeCpuQuantity, _tmpStakeNetQuantity, _tmpUnStakeCpuQuantity, _tmpUnStakeNetQuantity);
                                } else {
                                    _tmpData = null;
                                }
                                _tmpAct = new ActionTraceAct(_tmpAccount, _tmpName, _tmpAuthorization, _tmpData);
                            } else {
                                _tmpAct = null;
                            }
                            _tmpActionTrace = new ActionTrace(_tmpTrxId, _tmpAct);
                        } else {
                            _tmpActionTrace = null;
                        }
                        Action _item = new Action(_tmpGlobalActionSeq, _tmpBlockNum, _tmpBlockTime, _tmpActionTrace);
                        _item.accountName = _cursor.getString(_cursorIndexOfAccountName);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfAccountContact);
                        _item.accountContact = ProtonTypeConverters.stringToAccountContact(_tmp_1);
                        _result.add(_item);
                    }
                    ArrayList<Action> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p3);
    }
}

