/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.db;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.metallicus.protonsdk.db.AccountContactDao;
import com.metallicus.protonsdk.model.AccountContact;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class AccountContactDao_Impl
implements AccountContactDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<AccountContact> __insertionAdapterOfAccountContact;
    private final EntityDeletionOrUpdateAdapter<AccountContact> __updateAdapterOfAccountContact;
    private final SharedSQLiteStatement __preparedStmtOfRemoveAll;

    public AccountContactDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfAccountContact = new EntityInsertionAdapter<AccountContact>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `AccountContact` (`accountName`,`id`,`name`,`avatar`,`verified`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, AccountContact value) {
                if (value.accountName == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.accountName);
                }
                if (value.getId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getId());
                }
                if (value.getName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getName());
                }
                if (value.getAvatar() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getAvatar());
                }
                int _tmp = value.getVerified() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp);
            }
        };
        this.__updateAdapterOfAccountContact = new EntityDeletionOrUpdateAdapter<AccountContact>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `AccountContact` SET `accountName` = ?,`id` = ?,`name` = ?,`avatar` = ?,`verified` = ? WHERE `id` = ? AND `accountName` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AccountContact value) {
                if (value.accountName == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.accountName);
                }
                if (value.getId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getId());
                }
                if (value.getName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getName());
                }
                if (value.getAvatar() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getAvatar());
                }
                int _tmp = value.getVerified() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp);
                if (value.getId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getId());
                }
                if (value.accountName == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.accountName);
                }
            }
        };
        this.__preparedStmtOfRemoveAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM accountContact";
                return "DELETE FROM accountContact";
            }
        };
    }

    @Override
    public Object insert(final AccountContact accountContact, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AccountContactDao_Impl.this.__db.beginTransaction();
                try {
                    AccountContactDao_Impl.this.__insertionAdapterOfAccountContact.insert((Object)accountContact);
                    AccountContactDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AccountContactDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object update(final AccountContact accountContact, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AccountContactDao_Impl.this.__db.beginTransaction();
                try {
                    AccountContactDao_Impl.this.__updateAdapterOfAccountContact.handle((Object)accountContact);
                    AccountContactDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AccountContactDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object removeAll(Continuation<? super Unit> p0) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = AccountContactDao_Impl.this.__preparedStmtOfRemoveAll.acquire();
                AccountContactDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    AccountContactDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AccountContactDao_Impl.this.__db.endTransaction();
                    AccountContactDao_Impl.this.__preparedStmtOfRemoveAll.release(_stmt);
                }
            }
        }, p0);
    }

    @Override
    public Object findByAccountName(String accountName, Continuation<? super List<AccountContact>> p1) {
        String _sql = "SELECT * FROM accountContact WHERE accountName = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM accountContact WHERE accountName = ?", (int)1);
        int _argIndex = 1;
        if (accountName == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, accountName);
        }
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<List<AccountContact>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AccountContact> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)AccountContactDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfAccountName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accountName");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfAvatar = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatar");
                    int _cursorIndexOfVerified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"verified");
                    ArrayList<AccountContact> _result = new ArrayList<AccountContact>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        String _tmpName = _cursor.getString(_cursorIndexOfName);
                        String _tmpAvatar = _cursor.getString(_cursorIndexOfAvatar);
                        int _tmp = _cursor.getInt(_cursorIndexOfVerified);
                        boolean _tmpVerified = _tmp != 0;
                        AccountContact _item = new AccountContact(_tmpId, _tmpName, _tmpAvatar, _tmpVerified);
                        _item.accountName = _cursor.getString(_cursorIndexOfAccountName);
                        _result.add(_item);
                    }
                    ArrayList<AccountContact> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p1);
    }
}

