/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander.model.types;

import com.metallicus.protonsdk.eosio.commander.model.types.EosType;

public class EosByteReader
implements EosType.Reader {
    private byte[] _buf;
    private int _index;

    public EosByteReader(byte[] buf) {
        this._buf = buf;
        this._index = 0;
    }

    public EosByteReader(byte[] buf, int index) {
        this._buf = buf;
        this._index = index;
    }

    @Override
    public byte get() throws EosType.InsufficientBytesException {
        this.checkAvailable(1);
        return this._buf[this._index++];
    }

    @Override
    public int getShortLE() throws EosType.InsufficientBytesException {
        this.checkAvailable(2);
        return (this._buf[this._index++] & 0xFF | (this._buf[this._index++] & 0xFF) << 8) & 0xFFFF;
    }

    @Override
    public int getIntLE() throws EosType.InsufficientBytesException {
        this.checkAvailable(4);
        return this._buf[this._index++] & 0xFF | (this._buf[this._index++] & 0xFF) << 8 | (this._buf[this._index++] & 0xFF) << 16 | (this._buf[this._index++] & 0xFF) << 24;
    }

    @Override
    public long getLongLE() throws EosType.InsufficientBytesException {
        this.checkAvailable(8);
        return (long)this._buf[this._index++] & 0xFFL | ((long)this._buf[this._index++] & 0xFFL) << 8 | ((long)this._buf[this._index++] & 0xFFL) << 16 | ((long)this._buf[this._index++] & 0xFFL) << 24 | ((long)this._buf[this._index++] & 0xFFL) << 32 | ((long)this._buf[this._index++] & 0xFFL) << 40 | ((long)this._buf[this._index++] & 0xFFL) << 48 | ((long)this._buf[this._index++] & 0xFFL) << 56;
    }

    @Override
    public byte[] getBytes(int size) throws EosType.InsufficientBytesException {
        this.checkAvailable(size);
        byte[] bytes = new byte[size];
        System.arraycopy(this._buf, this._index, bytes, 0, size);
        this._index += size;
        return bytes;
    }

    @Override
    public String getString() throws EosType.InsufficientBytesException {
        int size = (int)(this.getVariableUint() & Integer.MAX_VALUE);
        byte[] bytes = this.getBytes(size);
        return new String(bytes);
    }

    @Override
    public long getVariableUint() throws EosType.InsufficientBytesException {
        byte b;
        long v = 0L;
        int by = 0;
        do {
            b = this.get();
            v |= (long)((b & 0x7F) << by);
            by = (byte)(by + 7);
        } while ((b & 0x80) != 0);
        return v;
    }

    private void checkAvailable(int num) throws EosType.InsufficientBytesException {
        if (this._buf.length - this._index < num) {
            throw new EosType.InsufficientBytesException();
        }
    }
}

