/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.eosio.commander.ec;

import com.metallicus.protonsdk.eosio.commander.HexUtils;
import com.metallicus.protonsdk.eosio.commander.StringUtils;
import com.metallicus.protonsdk.eosio.commander.ec.CurveParam;
import com.metallicus.protonsdk.eosio.commander.ec.EcTools;
import com.metallicus.protonsdk.eosio.commander.ec.EosEcUtil;
import java.math.BigInteger;
import java.util.Arrays;

public class EcSignature {
    private static final String PREFIX = "SIG";
    public int recId = -1;
    public final BigInteger r;
    public final BigInteger s;
    public final CurveParam curveParam;

    public EcSignature(BigInteger r, BigInteger s, CurveParam curveParam) {
        this.r = r;
        this.s = s;
        this.curveParam = curveParam;
    }

    public EcSignature(BigInteger r, BigInteger s, CurveParam curveParam, int recId) {
        this(r, s, curveParam);
        this.setRecid(recId);
    }

    public EcSignature(String base58Str) {
        String[] parts = EosEcUtil.safeSplitEosCryptoString(base58Str);
        if (parts.length < 3) {
            throw new IllegalArgumentException("Invalid private key format: " + base58Str);
        }
        if (!PREFIX.equals(parts[0])) {
            throw new IllegalArgumentException("Signature Key has invalid prefix: " + base58Str);
        }
        if (StringUtils.isEmpty(parts[2])) {
            throw new IllegalArgumentException("Signature has no data: " + base58Str);
        }
        this.curveParam = EosEcUtil.getCurveParamFrom(parts[1]);
        byte[] rawBytes = EosEcUtil.getBytesIfMatchedRipemd160(parts[2], parts[1], null);
        if (null == rawBytes) {
            // empty if block
        }
        this.setRecid(rawBytes[0] - 27 - 4);
        this.r = new BigInteger(Arrays.copyOfRange(rawBytes, 1, 33));
        this.s = new BigInteger(Arrays.copyOfRange(rawBytes, 33, 65));
    }

    public void setRecid(int recid) {
        this.recId = recid;
    }

    public boolean isCanonical() {
        return this.s.compareTo(this.curveParam.halfCurveOrder()) <= 0;
    }

    public EcSignature toCanonicalised() {
        if (!this.isCanonical()) {
            return new EcSignature(this.r, this.curveParam.n().subtract(this.s), this.curveParam);
        }
        return this;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (null == other || this.getClass() != other.getClass()) {
            return false;
        }
        EcSignature otherSig = (EcSignature)other;
        return this.r.equals(otherSig.r) && this.s.equals(otherSig.s);
    }

    public boolean isRSEachLength(int length) {
        return this.r.toByteArray().length == length && this.s.toByteArray().length == length;
    }

    public String eosEncodingHex(boolean compressed) {
        if (this.recId < 0 || this.recId > 3) {
            throw new IllegalStateException("signature has invalid recid.");
        }
        int headerByte = this.recId + 27 + (compressed ? 4 : 0);
        byte[] sigData = new byte[65];
        sigData[0] = (byte)headerByte;
        System.arraycopy(EcTools.integerToBytes(this.r, 32), 0, sigData, 1, 32);
        System.arraycopy(EcTools.integerToBytes(this.s, 32), 0, sigData, 33, 32);
        return EosEcUtil.encodeEosCrypto(PREFIX, this.curveParam, sigData);
    }

    public String toString() {
        if (this.recId < 0 || this.recId > 3) {
            return "no recovery sig: " + HexUtils.toHex(this.r.toByteArray()) + HexUtils.toHex(this.s.toByteArray());
        }
        return this.eosEncodingHex(true);
    }
}

