/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.db;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.metallicus.protonsdk.db.DefaultTypeConverters;
import com.metallicus.protonsdk.db.TokenContractDao;
import com.metallicus.protonsdk.model.TokenContract;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class TokenContractDao_Impl
implements TokenContractDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<TokenContract> __insertionAdapterOfTokenContract;
    private final EntityDeletionOrUpdateAdapter<TokenContract> __updateAdapterOfTokenContract;
    private final SharedSQLiteStatement __preparedStmtOfUpdateRates;
    private final SharedSQLiteStatement __preparedStmtOfRemoveAll;

    public TokenContractDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfTokenContract = new EntityInsertionAdapter<TokenContract>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `TokenContract` (`rates`,`id`,`contract`,`name`,`url`,`description`,`iconUrl`,`precisionSymbol`,`blacklisted`,`isSystemToken`) VALUES (?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, TokenContract value) {
                String _tmp = DefaultTypeConverters.stringDoubleMapToString(value.rates);
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getId());
                }
                if (value.getContract() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getContract());
                }
                if (value.getName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getName());
                }
                if (value.getUrl() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getUrl());
                }
                if (value.getDescription() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getDescription());
                }
                if (value.getIconUrl() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getIconUrl());
                }
                if (value.getPrecisionSymbol() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getPrecisionSymbol());
                }
                stmt.bindLong(9, (long)value.getBlacklisted());
                int _tmp_1 = value.isSystemToken() ? 1 : 0;
                stmt.bindLong(10, (long)_tmp_1);
            }
        };
        this.__updateAdapterOfTokenContract = new EntityDeletionOrUpdateAdapter<TokenContract>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `TokenContract` SET `rates` = ?,`id` = ?,`contract` = ?,`name` = ?,`url` = ?,`description` = ?,`iconUrl` = ?,`precisionSymbol` = ?,`blacklisted` = ?,`isSystemToken` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, TokenContract value) {
                String _tmp = DefaultTypeConverters.stringDoubleMapToString(value.rates);
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getId());
                }
                if (value.getContract() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getContract());
                }
                if (value.getName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getName());
                }
                if (value.getUrl() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getUrl());
                }
                if (value.getDescription() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getDescription());
                }
                if (value.getIconUrl() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getIconUrl());
                }
                if (value.getPrecisionSymbol() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getPrecisionSymbol());
                }
                stmt.bindLong(9, (long)value.getBlacklisted());
                int _tmp_1 = value.isSystemToken() ? 1 : 0;
                stmt.bindLong(10, (long)_tmp_1);
                if (value.getId() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getId());
                }
            }
        };
        this.__preparedStmtOfUpdateRates = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE tokenContract SET rates = ? WHERE id = ?";
                return "UPDATE tokenContract SET rates = ? WHERE id = ?";
            }
        };
        this.__preparedStmtOfRemoveAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM tokenContract";
                return "DELETE FROM tokenContract";
            }
        };
    }

    @Override
    public Object insert(final TokenContract tokenContract, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                TokenContractDao_Impl.this.__db.beginTransaction();
                try {
                    TokenContractDao_Impl.this.__insertionAdapterOfTokenContract.insert((Object)tokenContract);
                    TokenContractDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    TokenContractDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object update(final TokenContract tokenContract, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                TokenContractDao_Impl.this.__db.beginTransaction();
                try {
                    TokenContractDao_Impl.this.__updateAdapterOfTokenContract.handle((Object)tokenContract);
                    TokenContractDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    TokenContractDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object updateRates(final String tokenContractId, final String rates, Continuation<? super Unit> p2) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = TokenContractDao_Impl.this.__preparedStmtOfUpdateRates.acquire();
                int _argIndex = 1;
                if (rates == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, rates);
                }
                _argIndex = 2;
                if (tokenContractId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, tokenContractId);
                }
                TokenContractDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    TokenContractDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    TokenContractDao_Impl.this.__db.endTransaction();
                    TokenContractDao_Impl.this.__preparedStmtOfUpdateRates.release(_stmt);
                }
            }
        }, p2);
    }

    @Override
    public Object removeAll(Continuation<? super Unit> p0) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = TokenContractDao_Impl.this.__preparedStmtOfRemoveAll.acquire();
                TokenContractDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    TokenContractDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    TokenContractDao_Impl.this.__db.endTransaction();
                    TokenContractDao_Impl.this.__preparedStmtOfRemoveAll.release(_stmt);
                }
            }
        }, p0);
    }

    @Override
    public Object findById(String id, Continuation<? super TokenContract> p1) {
        String _sql = "SELECT * FROM tokenContract WHERE id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM tokenContract WHERE id = ?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<TokenContract>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TokenContract call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)TokenContractDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    TokenContract _result;
                    int _cursorIndexOfRates = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rates");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfContract = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contract");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfIconUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iconUrl");
                    int _cursorIndexOfPrecisionSymbol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"precisionSymbol");
                    int _cursorIndexOfBlacklisted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blacklisted");
                    int _cursorIndexOfIsSystemToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSystemToken");
                    if (_cursor.moveToFirst()) {
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        String _tmpContract = _cursor.getString(_cursorIndexOfContract);
                        String _tmpName = _cursor.getString(_cursorIndexOfName);
                        String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                        String _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
                        String _tmpIconUrl = _cursor.getString(_cursorIndexOfIconUrl);
                        String _tmpPrecisionSymbol = _cursor.getString(_cursorIndexOfPrecisionSymbol);
                        int _tmpBlacklisted = _cursor.getInt(_cursorIndexOfBlacklisted);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsSystemToken);
                        boolean _tmpIsSystemToken = _tmp != 0;
                        _result = new TokenContract(_tmpId, _tmpContract, _tmpName, _tmpUrl, _tmpDescription, _tmpIconUrl, _tmpPrecisionSymbol, _tmpBlacklisted, _tmpIsSystemToken);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfRates);
                        _result.rates = DefaultTypeConverters.stringToStringDoubleMap(_tmp_1);
                    } else {
                        _result = null;
                    }
                    TokenContract tokenContract = _result;
                    return tokenContract;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p1);
    }

    @Override
    public Object findAll(Continuation<? super List<TokenContract>> p0) {
        String _sql = "SELECT * FROM tokenContract";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM tokenContract", (int)0);
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (Callable)new Callable<List<TokenContract>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<TokenContract> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)TokenContractDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfRates = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rates");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfContract = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contract");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfIconUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iconUrl");
                    int _cursorIndexOfPrecisionSymbol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"precisionSymbol");
                    int _cursorIndexOfBlacklisted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blacklisted");
                    int _cursorIndexOfIsSystemToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSystemToken");
                    ArrayList<TokenContract> _result = new ArrayList<TokenContract>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        String _tmpContract = _cursor.getString(_cursorIndexOfContract);
                        String _tmpName = _cursor.getString(_cursorIndexOfName);
                        String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                        String _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
                        String _tmpIconUrl = _cursor.getString(_cursorIndexOfIconUrl);
                        String _tmpPrecisionSymbol = _cursor.getString(_cursorIndexOfPrecisionSymbol);
                        int _tmpBlacklisted = _cursor.getInt(_cursorIndexOfBlacklisted);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsSystemToken);
                        boolean _tmpIsSystemToken = _tmp != 0;
                        TokenContract _item = new TokenContract(_tmpId, _tmpContract, _tmpName, _tmpUrl, _tmpDescription, _tmpIconUrl, _tmpPrecisionSymbol, _tmpBlacklisted, _tmpIsSystemToken);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfRates);
                        _item.rates = DefaultTypeConverters.stringToStringDoubleMap(_tmp_1);
                        _result.add(_item);
                    }
                    ArrayList<TokenContract> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p0);
    }
}

