/*
 * Decompiled with CFR 0.152.
 */
package com.metallicus.protonsdk.securestorage;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.metallicus.protonsdk.R;
import com.metallicus.protonsdk.securestorage.PRNGFixes;
import com.metallicus.protonsdk.securestorage.SecureStorageException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.security.auth.x500.X500Principal;

final class KeystoreTool {
    private static final String KEY_ALIAS = "ProtonKeyPair";
    private static final String KEY_ENCRYPTION_ALGORITHM = "RSA";
    private static final String KEY_CHARSET = "UTF-8";
    private static final String KEY_KEYSTORE_NAME = "AndroidKeyStore";
    private static final String KEY_CIPHER_JELLYBEAN_PROVIDER = "AndroidOpenSSL";
    private static final String KEY_CIPHER_MARSHMALLOW_PROVIDER = "AndroidKeyStoreBCWorkaround";
    private static final String KEY_TRANSFORMATION_ALGORITHM = "RSA/ECB/PKCS1Padding";

    private KeystoreTool() {
    }

    @Nullable
    static String encryptMessage(@NonNull Context context, @NonNull String plainMessage) throws SecureStorageException {
        try {
            Cipher input = Build.VERSION.SDK_INT >= 23 ? Cipher.getInstance(KEY_TRANSFORMATION_ALGORITHM, KEY_CIPHER_MARSHMALLOW_PROVIDER) : Cipher.getInstance(KEY_TRANSFORMATION_ALGORITHM, KEY_CIPHER_JELLYBEAN_PROVIDER);
            input.init(1, KeystoreTool.getPublicKey(context));
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, input);
            cipherOutputStream.write(plainMessage.getBytes(KEY_CHARSET));
            cipherOutputStream.close();
            byte[] values = outputStream.toByteArray();
            return Base64.encodeToString((byte[])values, (int)0);
        }
        catch (Exception e) {
            throw new SecureStorageException(e.getMessage(), e, SecureStorageException.ExceptionType.KEYSTORE_EXCEPTION);
        }
    }

    @NonNull
    static String decryptMessage(@NonNull Context context, @NonNull String encryptedMessage) throws SecureStorageException {
        try {
            int nextByte;
            Cipher output = Build.VERSION.SDK_INT >= 23 ? Cipher.getInstance(KEY_TRANSFORMATION_ALGORITHM, KEY_CIPHER_MARSHMALLOW_PROVIDER) : Cipher.getInstance(KEY_TRANSFORMATION_ALGORITHM, KEY_CIPHER_JELLYBEAN_PROVIDER);
            output.init(2, KeystoreTool.getPrivateKey(context));
            CipherInputStream cipherInputStream = new CipherInputStream(new ByteArrayInputStream(Base64.decode((String)encryptedMessage, (int)0)), output);
            ArrayList<Byte> values = new ArrayList<Byte>();
            while ((nextByte = cipherInputStream.read()) != -1) {
                values.add((byte)nextByte);
            }
            byte[] bytes = new byte[values.size()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (Byte)values.get(i);
            }
            return new String(bytes, 0, bytes.length, KEY_CHARSET);
        }
        catch (Exception e) {
            throw new SecureStorageException(e.getMessage(), e, SecureStorageException.ExceptionType.CRYPTO_EXCEPTION);
        }
    }

    static boolean keyPairExists() {
        boolean keyExists;
        try {
            keyExists = KeystoreTool.getKeyStoreInstance().getKey(KEY_ALIAS, null) != null;
        }
        catch (Exception e) {
            keyExists = false;
        }
        return keyExists;
    }

    static void generateKeyPair(@NonNull Context context) throws SecureStorageException {
        if (KeystoreTool.isRTL(context)) {
            Locale.setDefault(Locale.US);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            KeystoreTool.generateMarshmallowKeyPair();
        } else {
            PRNGFixes.apply();
            KeystoreTool.generateDeprecatedKeyPair(context);
        }
    }

    @RequiresApi(api=23)
    private static void generateMarshmallowKeyPair() throws SecureStorageException {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance(KEY_ENCRYPTION_ALGORITHM, KEY_KEYSTORE_NAME);
            KeyGenParameterSpec keyGenParameterSpec = new KeyGenParameterSpec.Builder(KEY_ALIAS, 3).setEncryptionPaddings(new String[]{"PKCS1Padding"}).build();
            generator.initialize((AlgorithmParameterSpec)keyGenParameterSpec);
            generator.generateKeyPair();
        }
        catch (Exception e) {
            throw new SecureStorageException(e.getMessage(), e, SecureStorageException.ExceptionType.KEYSTORE_EXCEPTION);
        }
    }

    private static void generateDeprecatedKeyPair(@NonNull Context context) throws SecureStorageException {
        try {
            Calendar start = Calendar.getInstance();
            Calendar end = Calendar.getInstance();
            end.add(1, 99);
            KeyPairGeneratorSpec spec = new KeyPairGeneratorSpec.Builder(context).setAlias(KEY_ALIAS).setSubject(new X500Principal("CN=ProtonKeyPair")).setSerialNumber(BigInteger.TEN).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
            KeyPairGenerator generator = KeyPairGenerator.getInstance(KEY_ENCRYPTION_ALGORITHM, KEY_KEYSTORE_NAME);
            generator.initialize((AlgorithmParameterSpec)spec);
            generator.generateKeyPair();
        }
        catch (Exception e) {
            throw new SecureStorageException(e.getMessage(), e, SecureStorageException.ExceptionType.KEYSTORE_EXCEPTION);
        }
    }

    static void deleteKeyPair() throws SecureStorageException {
        try {
            KeystoreTool.getKeyStoreInstance().deleteEntry(KEY_ALIAS);
        }
        catch (KeyStoreException e) {
            throw new SecureStorageException(e.getMessage(), e, SecureStorageException.ExceptionType.KEYSTORE_EXCEPTION);
        }
    }

    @Nullable
    private static PublicKey getPublicKey(@NonNull Context context) throws SecureStorageException {
        PublicKey publicKey;
        block5: {
            try {
                if (KeystoreTool.keyPairExists()) {
                    if (Build.VERSION.SDK_INT >= 28) {
                        publicKey = KeystoreTool.getKeyStoreInstance().getCertificate(KEY_ALIAS).getPublicKey();
                    } else {
                        KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)KeystoreTool.getKeyStoreInstance().getEntry(KEY_ALIAS, null);
                        publicKey = privateKeyEntry.getCertificate().getPublicKey();
                    }
                    break block5;
                }
                throw new SecureStorageException(context.getString(R.string.secureStorageKeyPairDoesNotExist), null, SecureStorageException.ExceptionType.INTERNAL_LIBRARY_EXCEPTION);
            }
            catch (Exception e) {
                throw new SecureStorageException(e.getMessage(), e, SecureStorageException.ExceptionType.KEYSTORE_EXCEPTION);
            }
        }
        return publicKey;
    }

    @Nullable
    private static PrivateKey getPrivateKey(@NonNull Context context) throws SecureStorageException {
        PrivateKey privateKey;
        block5: {
            try {
                if (KeystoreTool.keyPairExists()) {
                    if (Build.VERSION.SDK_INT >= 28) {
                        privateKey = (PrivateKey)KeystoreTool.getKeyStoreInstance().getKey(KEY_ALIAS, null);
                    } else {
                        KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)KeystoreTool.getKeyStoreInstance().getEntry(KEY_ALIAS, null);
                        privateKey = privateKeyEntry.getPrivateKey();
                    }
                    break block5;
                }
                throw new SecureStorageException(context.getString(R.string.secureStorageKeyPairDoesNotExist), null, SecureStorageException.ExceptionType.INTERNAL_LIBRARY_EXCEPTION);
            }
            catch (Exception e) {
                throw new SecureStorageException(e.getMessage(), e, SecureStorageException.ExceptionType.KEYSTORE_EXCEPTION);
            }
        }
        return privateKey;
    }

    private static boolean isRTL(@NonNull Context context) {
        Configuration config = context.getResources().getConfiguration();
        return config.getLayoutDirection() == 1;
    }

    @NonNull
    private static KeyStore getKeyStoreInstance() throws SecureStorageException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KEY_KEYSTORE_NAME);
            keyStore.load(null);
            return keyStore;
        }
        catch (Exception e) {
            throw new SecureStorageException(e.getMessage(), e, SecureStorageException.ExceptionType.KEYSTORE_EXCEPTION);
        }
    }
}

